/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Engine;
import org.mapdb.Serializer;

public class EngineWrapper
implements Engine {
    protected Engine engine;

    protected EngineWrapper(Engine engine) {
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
    }

    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        return this.engine.put(value, serializer);
    }

    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        return this.engine.get(recid, serializer);
    }

    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        this.engine.update(recid, value, serializer);
    }

    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        return this.engine.compareAndSwap(recid, expectedOldValue, newValue, serializer);
    }

    public void delete(long recid) {
        this.engine.delete(recid);
    }

    @Override
    public void close() {
        if (this.engine != null) {
            this.engine.close();
        }
        this.engine = null;
    }

    @Override
    public boolean isClosed() {
        return this.engine == null;
    }

    @Override
    public void commit() {
        this.engine.commit();
    }

    @Override
    public void rollback() {
        this.engine.rollback();
    }

    public long serializerRecid() {
        return this.engine.serializerRecid();
    }

    public long nameDirRecid() {
        return this.engine.nameDirRecid();
    }

    @Override
    public boolean isReadOnly() {
        return this.engine.isReadOnly();
    }

    @Override
    public Engine getWrappedEngine() {
        return this.engine;
    }

    public static class DebugEngine
    extends EngineWrapper {
        final Queue<Record> records = new ConcurrentLinkedQueue<Record>();

        public DebugEngine(Engine engine) {
            super(engine);
        }

        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            long recid = super.put(value, serializer);
            this.records.add(new Record(recid, "INSERT \n  val:" + value + "\n  ser:" + serializer));
            return recid;
        }

        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            A ret = super.get(recid, serializer);
            this.records.add(new Record(recid, "GET \n  val:" + ret + "\n  ser:" + serializer));
            return ret;
        }

        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            super.update(recid, value, serializer);
            this.records.add(new Record(recid, "UPDATE \n  val:" + value + "\n  ser:" + serializer));
        }

        @Override
        public void delete(long recid) {
            super.delete(recid);
            this.records.add(new Record(recid, "DEL"));
        }

        protected static final class Record {
            final long recid;
            final String desc;

            public Record(long recid, String desc) {
                this.recid = recid;
                this.desc = desc;
            }
        }
    }

    public static class ByteTransformEngine
    extends EngineWrapper {
        protected Serializer<byte[]> blockSerializer;

        public ByteTransformEngine(Engine engine, Serializer<byte[]> blockSerializer) {
            super(engine);
            this.blockSerializer = blockSerializer;
        }

        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            try {
                if (value == null) {
                    return this.engine.put(null, this.blockSerializer);
                }
                DataOutput2 out = new DataOutput2();
                serializer.serialize(out, value);
                byte[] b = out.copyBytes();
                return this.engine.put(b, this.blockSerializer);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            try {
                byte[] b = this.engine.get(recid, this.blockSerializer);
                if (b == null) {
                    return null;
                }
                DataInput2 in = new DataInput2(ByteBuffer.wrap(b), 0);
                return serializer.deserialize(in, b.length);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            try {
                DataOutput2 out = new DataOutput2();
                serializer.serialize(out, value);
                byte[] b = out.copyBytes();
                this.engine.update(recid, b, this.blockSerializer);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void close() {
            super.close();
            this.blockSerializer = null;
        }
    }

    public static class ReadOnlyEngine
    extends EngineWrapper {
        public ReadOnlyEngine(Engine engine) {
            super(engine);
        }

        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public void delete(long recid) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public void commit() {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public void rollback() {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }
}

