/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.Locks;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.Serializer;

public class CacheWeakSoftRef
extends EngineWrapper
implements Engine {
    protected final Locks.RecidLocks locks = new Locks.LongHashMapRecidLocks();
    protected ReferenceQueue queue = new ReferenceQueue();
    protected Thread queueThread = new Thread("MapDB GC collector"){

        @Override
        public void run() {
            CacheWeakSoftRef.this.runRefQueue();
        }
    };
    protected LongConcurrentHashMap<CacheItem> items = new LongConcurrentHashMap();
    protected final boolean useWeakRef;

    public CacheWeakSoftRef(Engine engine, boolean useWeakRef) {
        super(engine);
        this.useWeakRef = useWeakRef;
        this.queueThread.setDaemon(true);
        this.queueThread.start();
    }

    protected void runRefQueue() {
        try {
            ReferenceQueue queue = this.queue;
            LongConcurrentHashMap<CacheItem> items = this.items;
            do {
                CacheItem item = (CacheItem)((Object)queue.remove());
                items.remove(item.getRecid(), item);
            } while (!Thread.interrupted());
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        long recid = this.engine.put(value, serializer);
        this.putItemIntoCache(recid, value);
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        CacheItem item = this.items.get(recid);
        if (item != null) {
            Object o = item.get();
            if (o == null) {
                this.items.remove(recid);
            } else {
                return (A)o;
            }
        }
        try {
            this.locks.lock(recid);
            A value = this.engine.get(recid, serializer);
            if (value != null) {
                this.putItemIntoCache(recid, value);
            }
            A a = value;
            return a;
        }
        finally {
            this.locks.unlock(recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        try {
            this.locks.lock(recid);
            this.putItemIntoCache(recid, value);
            this.engine.update(recid, value, serializer);
        }
        finally {
            this.locks.unlock(recid);
        }
    }

    private <A> void putItemIntoCache(long recid, A value) {
        this.items.put(recid, (CacheItem)((Object)(this.useWeakRef ? new CacheWeakItem<A>(value, this.queue, recid) : new CacheSoftItem<A>(value, this.queue, recid))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(long recid) {
        try {
            this.locks.lock(recid);
            this.items.remove(recid);
            this.engine.delete(recid);
        }
        finally {
            this.locks.unlock(recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        try {
            Object oldValue;
            this.locks.lock(recid);
            CacheItem item = this.items.get(recid);
            Object object = oldValue = item == null ? null : item.get();
            if (item != null && oldValue != null && item.getRecid() == recid && (oldValue == expectedOldValue || oldValue.equals(expectedOldValue))) {
                this.putItemIntoCache(recid, newValue);
                this.engine.update(recid, newValue, serializer);
                boolean bl = true;
                return bl;
            }
            boolean ret = this.engine.compareAndSwap(recid, expectedOldValue, newValue, serializer);
            if (ret) {
                this.putItemIntoCache(recid, newValue);
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.locks.unlock(recid);
        }
    }

    @Override
    public void close() {
        this.engine = null;
        this.items = null;
        this.queue = null;
        if (this.queueThread != null) {
            this.queueThread.interrupt();
            this.queueThread = null;
        }
    }

    @Override
    public void rollback() {
        this.items.clear();
        this.engine.rollback();
    }

    protected static final class CacheSoftItem<A>
    extends SoftReference<A>
    implements CacheItem {
        final long recid;

        public CacheSoftItem(A referent, ReferenceQueue<A> q, long recid) {
            super(referent, q);
            this.recid = recid;
        }

        @Override
        public long getRecid() {
            return this.recid;
        }
    }

    protected static final class CacheWeakItem<A>
    extends WeakReference<A>
    implements CacheItem {
        final long recid;

        public CacheWeakItem(A referent, ReferenceQueue<A> q, long recid) {
            super(referent, q);
            this.recid = recid;
        }

        @Override
        public long getRecid() {
            return this.recid;
        }
    }

    protected static interface CacheItem {
        public long getRecid();

        public Object get();
    }
}

