/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.lang.ref.WeakReference;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.LongMap;
import org.mapdb.Serializer;

public class AsyncWriteEngine
extends EngineWrapper
implements Engine {
    protected final boolean powerSavingMode;
    protected final int flushDelay;
    protected static final AtomicInteger threadCounter = new AtomicInteger();
    private final int threadNum = threadCounter.incrementAndGet();
    protected static final Object DELETED = new Object();
    protected static final Object DONE = new Object();
    protected final Thread writerThread = new Thread("MapDB writer #" + this.threadNum){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    if (AsyncWriteEngine.this.throwed != null) {
                        return;
                    }
                    LongMap.LongMapIterator iter = AsyncWriteEngine.this.writeCache.longMapIterator();
                    if (!iter.moveToNext()) {
                        LockSupport.parkNanos(10000L);
                    } else {
                        do {
                            WriteItem item;
                            long recid = iter.key();
                            WriteItem writeItem = item = (WriteItem)iter.value();
                            synchronized (writeItem) {
                                if (item.value == DONE) {
                                    throw new InternalError();
                                }
                                if (item.value == DELETED) {
                                    AsyncWriteEngine.this.engine.delete(recid);
                                } else {
                                    AsyncWriteEngine.this.engine.update(recid, item.value, item.serializer);
                                }
                                item.value = DONE;
                                iter.remove();
                            }
                        } while (iter.moveToNext());
                    }
                    if (AsyncWriteEngine.this.parentEngineWeakRef != null && AsyncWriteEngine.this.parentEngineWeakRef.get() == null && AsyncWriteEngine.this.writeCache.isEmpty()) {
                        AsyncWriteEngine.this.throwed = new Error("Parent engine was GCed. No more items should be added");
                        return;
                    }
                    if (AsyncWriteEngine.this.flushDelay <= 0) continue;
                    Thread.sleep(AsyncWriteEngine.this.flushDelay);
                    continue;
                    break;
                }
            }
            catch (Throwable e) {
                AsyncWriteEngine.this.throwed = e;
                return;
            }
            finally {
                AsyncWriteEngine.this.writerThreadDown.countDown();
            }
        }
    };
    BlockingQueue<Long> preallocRecids = new ArrayBlockingQueue<Long>(128);
    protected final Thread preallocThread = new Thread("MapDB prealloc #" + this.threadNum){
        {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (AsyncWriteEngine.this.throwed != null) {
                        return;
                    }
                    Long recid = AsyncWriteEngine.super.put(null, Serializer.NULL_SERIALIZER);
                    AsyncWriteEngine.this.preallocRecids.put(recid);
                }
            }
            catch (Throwable e) {
                AsyncWriteEngine.this.throwed = e;
                return;
            }
        }
    };
    protected final CountDownLatch writerThreadDown = new CountDownLatch(1);
    protected final AtomicBoolean writerThreadRunning = new AtomicBoolean(false);
    protected Throwable throwed = null;
    protected final ReentrantReadWriteLock commitLock = new ReentrantReadWriteLock();
    protected final LongConcurrentHashMap<WriteItem> writeCache = new LongConcurrentHashMap();
    protected WeakReference<Engine> parentEngineWeakRef = null;

    public AsyncWriteEngine(Engine engine, boolean asyncThreadDaemon, boolean powerSavingMode, int flushDelay) {
        super(engine);
        this.powerSavingMode = powerSavingMode;
        this.flushDelay = flushDelay;
        this.writerThread.setDaemon(asyncThreadDaemon);
    }

    protected void checkAndStartWriter() {
        if (this.throwed != null) {
            throw new RuntimeException("Writer Thread failed with an exception.", this.throwed);
        }
        if (!this.writerThreadRunning.get() && this.writerThreadRunning.compareAndSet(false, true)) {
            this.writerThread.start();
            this.preallocThread.start();
        }
    }

    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        this.checkAndStartWriter();
        try {
            long recid = this.preallocRecids.take();
            this.update(recid, value, serializer);
            return recid;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        this.checkAndStartWriter();
        this.commitLock.readLock().lock();
        try {
            while (true) {
                WriteItem item;
                if ((item = this.writeCache.get(recid)) == null) {
                    if (this.writeCache.putIfAbsent(recid, new WriteItem(value, serializer)) != null) continue;
                    return;
                }
                WriteItem writeItem = item;
                synchronized (writeItem) {
                    if (item.value != DONE) break;
                }
            }
            {
                item.serializer = serializer;
                item.value = value;
                return;
            }
        }
        finally {
            this.commitLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        boolean bl;
        WriteItem item;
        this.checkAndStartWriter();
        this.commitLock.readLock().lock();
        while (true) {
            if ((item = this.writeCache.get(recid)) == null) {
                A oldValue = super.get(recid, serializer);
                if (oldValue != expectedOldValue) {
                    if (oldValue == null) return false;
                    if (!oldValue.equals(expectedOldValue)) return false;
                }
                if (this.writeCache.putIfAbsent(recid, new WriteItem(newValue, serializer)) != null) continue;
                boolean bl2 = true;
                this.commitLock.writeLock().unlock();
                return bl2;
            }
            WriteItem writeItem = item;
            synchronized (writeItem) {
                if (item.value != DONE) break;
            }
        }
        {
            if (item.value == expectedOldValue || item.value != null && item.value.equals(expectedOldValue)) {
                item.serializer = serializer;
                item.value = newValue;
                boolean bl3 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 6, 10] lbl23 : MonitorExitStatement: MONITOREXIT : var7_6
                this.commitLock.writeLock().unlock();
                return bl3;
            }
            bl = false;
        }
        this.commitLock.writeLock().unlock();
        return bl;
    }

    @Override
    public void delete(long recid) {
        this.update(recid, DELETED, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        this.commitLock.writeLock().lock();
        try {
            while (!this.writeCache.isEmpty()) {
                LockSupport.parkNanos(100L);
            }
            super.commit();
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.commitLock.writeLock().lock();
        try {
            while (!this.writeCache.isEmpty()) {
                LockSupport.parkNanos(100L);
            }
            super.close();
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        this.commitLock.writeLock().lock();
        try {
            while (!this.writeCache.isEmpty()) {
                LockSupport.parkNanos(100L);
            }
            super.rollback();
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    public void setParentEngineReference(Engine parentEngineReference) {
        this.parentEngineWeakRef = new WeakReference<Engine>(parentEngineReference);
    }

    protected static final class WriteItem {
        protected volatile Object value;
        protected volatile Serializer serializer;

        public WriteItem(Object value, Serializer serializer) {
            this.value = value;
            this.serializer = serializer;
        }
    }
}

