/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.twoSample.K_STest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.tests.KolmogorovTwoSampleDistribution;
import javanpst.tests.StatisticalTest;

public class K_STest
extends StatisticalTest {
    private KolmogorovTwoSampleDistribution distribution = KolmogorovTwoSampleDistribution.getInstance();
    private DataTable data;
    private double[] Sn;
    private double[] Sm;
    private double[] Fn;
    private double[] Fm;
    private double Dn;
    private double DnPos;
    private double DnNeg;
    private double[] combined;
    private double asymptoticLeftTail;
    private double asymptoticRightTail;
    private double asymptoticDoubleTail;
    private double exactLeftTail;
    private double exactRightTail;
    private double exactDoubleTail;

    public K_STest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.Dn = 0.0;
        this.Sn = null;
        this.Sm = null;
        this.Fn = null;
        this.Fm = null;
        this.exactLeftTail = -1.0;
        this.exactRightTail = -1.0;
        this.exactDoubleTail = -1.0;
        this.asymptoticLeftTail = -1.0;
        this.asymptoticRightTail = -1.0;
        this.asymptoticDoubleTail = -1.0;
    }

    public K_STest(DataTable newData) {
        int i;
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Kolmogorov-Smirnov test only can be employed with two samples");
            this.clearData();
            return;
        }
        this.Fn = new double[this.data.getRows()];
        this.Fm = new double[this.data.getRows()];
        this.combined = new double[this.data.getRows() + this.data.getRows()];
        for (i = 0; i < this.data.getRows(); ++i) {
            this.Fm[i] = this.data.get(i, 0);
            this.combined[i] = this.data.get(i, 0);
        }
        for (i = 0; i < this.data.getRows(); ++i) {
            this.Fn[i] = this.data.get(i, 1);
            this.combined[i + this.data.getRows()] = this.data.get(i, 1);
        }
        this.Sn = new double[this.data.getRows() + this.data.getRows()];
        this.Sm = new double[this.data.getRows() + this.data.getRows()];
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        int i;
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Kolmogorov-Smirnov test only can be employed with two samples");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.Fn = new double[this.data.getRows()];
        this.Fm = new double[this.data.getRows()];
        this.combined = new double[this.data.getRows() + this.data.getRows()];
        for (i = 0; i < this.data.getRows(); ++i) {
            this.Fm[i] = this.data.get(i, 0);
            this.combined[i] = this.data.get(i, 0);
        }
        for (i = 0; i < this.data.getRows(); ++i) {
            this.Fn[i] = this.data.get(i, 1);
            this.combined[i + this.data.getRows()] = this.data.get(i, 1);
        }
        this.Sn = new double[this.data.getRows() + this.data.getRows()];
        this.Sm = new double[this.data.getRows() + this.data.getRows()];
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        double value;
        int index;
        int i;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        Arrays.sort(this.Fn);
        Arrays.sort(this.Fm);
        Arrays.sort(this.combined);
        double distinct = 1.0;
        for (i = 1; i < this.combined.length; ++i) {
            if (this.combined[i] == this.combined[i - 1]) continue;
            distinct += 1.0;
        }
        double increment = 1.0 / distinct;
        double[] combinedCdf = new double[this.combined.length];
        combinedCdf[0] = 0.0;
        for (i = 1; i < this.combined.length; ++i) {
            combinedCdf[i] = this.combined[i] == this.combined[i - 1] ? combinedCdf[i - 1] : combinedCdf[i - 1] + increment;
        }
        int cdfIndex = 0;
        for (index = 0; index < this.Fn.length; ++index) {
            value = this.Fn[index];
            while (this.combined[cdfIndex] != value) {
                ++cdfIndex;
            }
            this.Sn[index] = combinedCdf[cdfIndex];
        }
        cdfIndex = 0;
        for (index = 0; index < this.Fm.length; ++index) {
            value = this.Fm[index];
            while (this.combined[cdfIndex] != value) {
                ++cdfIndex;
            }
            this.Sm[index] = combinedCdf[cdfIndex];
        }
        this.Dn = 0.0;
        this.DnPos = 0.0;
        this.DnNeg = 0.0;
        for (i = 0; i < this.Sn.length; ++i) {
            value = this.Sm[i] - this.Sn[i];
            this.DnPos = Math.max(this.DnPos, value);
            this.DnNeg = Math.min(this.DnNeg, value);
            this.Dn = Math.max(this.Dn, Math.abs(value));
        }
        this.exactLeftTail = this.distribution.computeExactProbability(this.data.getRows(), Math.abs(this.DnNeg));
        this.exactRightTail = this.distribution.computeExactProbability(this.data.getRows(), Math.abs(this.DnPos));
        this.exactDoubleTail = this.distribution.computeExactProbability(this.data.getRows(), Math.abs(this.Dn));
        this.asymptoticLeftTail = this.distribution.computeAsymptoticProbability(this.data.getRows(), Math.abs(this.DnNeg));
        this.asymptoticRightTail = this.distribution.computeAsymptoticProbability(this.data.getRows(), Math.abs(this.DnPos));
        this.asymptoticDoubleTail = this.distribution.computeAsymptoticProbability(this.data.getRows(), Math.abs(this.Dn));
        this.performed = true;
    }

    public double getDn() {
        return this.Dn;
    }

    public double getDnNeg() {
        return this.DnNeg;
    }

    public double getDnPos() {
        return this.DnPos;
    }

    public double getExactLeftPValue() {
        return this.exactLeftTail;
    }

    public double getExactRightPValue() {
        return this.exactRightTail;
    }

    public double getExactDoublePValue() {
        return this.exactDoubleTail;
    }

    public double getLeftPValue() {
        return this.asymptoticLeftTail;
    }

    public double getRightPValue() {
        return this.asymptoticRightTail;
    }

    public double getDoublePValue() {
        return this.asymptoticDoubleTail;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n***************************************\n";
        report = report + "Kolmogorov Two Sample test\n";
        report = report + "***************************************\n\n";
        report = report + "Dn+ statistic: " + this.nf6.format(this.DnPos) + "\n";
        report = report + "Dn- statistic: " + this.nf6.format(this.DnNeg) + "\n";
        report = report + "Dn statistic: " + this.nf6.format(this.Dn) + "\n\n";
        if (this.Fn.length < 9) {
            report = report + "Exact P-Value (Left tail, Y > X): " + this.nf6.format(this.exactLeftTail) + "\n";
            report = report + "Exact P-Value (Right tail, Y < X): " + this.nf6.format(this.exactRightTail) + "\n";
            report = report + "Exact P-Value (Double tail, Y != X): " + this.nf6.format(this.exactDoubleTail) + "\n\n";
        } else {
            report = report + "Asymptotic P-Value (Left tail, Y > X): " + this.nf6.format(this.asymptoticLeftTail) + "\n";
            report = report + "Asymptotic P-Value (Right tail, Y > X): " + this.nf6.format(this.asymptoticRightTail) + "\n";
            report = report + "Asymptotic P-Value (Double tail, Y != X): " + this.nf6.format(this.asymptoticDoubleTail) + "\n\n";
        }
        return report;
    }
}

