/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.multiple.partialCorrelationTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.tests.PartialCorrelationDistribution;
import javanpst.tests.StatisticalTest;

public class PartialCorrelationTest
extends StatisticalTest {
    private PartialCorrelationDistribution distribution = PartialCorrelationDistribution.getInstance();
    private DataTable data;
    private double[][] samples;
    private double[][] ranks;
    private double TxyC;
    private double TxzC;
    private double TyzC;
    private double TxyQ;
    private double TxzQ;
    private double TyzQ;
    private double Txy;
    private double Txz;
    private double Tyz;
    private double tau;
    private double pValue;

    public PartialCorrelationTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.Txy = 0.0;
        this.Txz = 0.0;
        this.Tyz = 0.0;
        this.tau = 0.0;
        this.samples = null;
        this.ranks = null;
        this.pValue = -1.0;
    }

    public PartialCorrelationTest(DataTable newData) {
        int i;
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Partial correlation test only can be employed with three variables: X, Y and Z");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        this.ranks = new double[this.data.getRows()][this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            Arrays.fill(this.ranks[i], -1.0);
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
            }
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        int i;
        this.distribution = PartialCorrelationDistribution.getInstance();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Partial correlation test only can be employed with three variables: X, Y and Z");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        this.ranks = new double[this.data.getRows()][this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            Arrays.fill(this.ranks[i], -1.0);
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
            }
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        int j;
        int i;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.computeRanks();
        this.sortRanksZ();
        this.TxzC = 0.0;
        this.TxzQ = 0.0;
        for (i = 0; i < this.ranks[0].length - 1; ++i) {
            for (j = i + 1; j < this.ranks[0].length; ++j) {
                if (this.ranks[0][i] > this.ranks[0][j]) {
                    this.TxzQ += 1.0;
                    continue;
                }
                this.TxzC += 1.0;
            }
        }
        this.TyzC = 0.0;
        this.TyzQ = 0.0;
        for (i = 0; i < this.ranks[0].length - 1; ++i) {
            for (j = i + 1; j < this.ranks[0].length; ++j) {
                if (this.ranks[1][i] > this.ranks[1][j]) {
                    this.TyzQ += 1.0;
                    continue;
                }
                this.TyzC += 1.0;
            }
        }
        this.sortRanksY();
        this.TxyC = 0.0;
        this.TxyQ = 0.0;
        for (i = 0; i < this.ranks[0].length - 1; ++i) {
            for (j = i + 1; j < this.ranks[0].length; ++j) {
                if (this.ranks[0][i] > this.ranks[0][j]) {
                    this.TxyQ += 1.0;
                    continue;
                }
                this.TxyC += 1.0;
            }
        }
        int n = this.ranks[0].length;
        this.Txy = 2.0 * (this.TxyC - this.TxyQ) / (double)(n * (n - 1));
        this.Txz = 2.0 * (this.TxzC - this.TxzQ) / (double)(n * (n - 1));
        this.Tyz = 2.0 * (this.TyzC - this.TyzQ) / (double)(n * (n - 1));
        this.tau = this.Txy - this.Txz * this.Tyz;
        this.tau /= Math.sqrt((1.0 - this.Txz * this.Txz) * (1.0 - this.Tyz * this.Tyz));
        this.pValue = this.distribution.computeProbability(n, this.tau);
        this.performed = true;
    }

    private void sortRanksZ() {
        for (int i = 0; i < this.ranks[0].length - 1; ++i) {
            for (int j = i + 1; j < this.ranks[0].length; ++j) {
                if (!(this.ranks[2][j] < this.ranks[2][i])) continue;
                this.swapColumns(i, j);
            }
        }
    }

    private void sortRanksY() {
        for (int i = 0; i < this.ranks[0].length - 1; ++i) {
            for (int j = i + 1; j < this.ranks[0].length; ++j) {
                if (!(this.ranks[1][j] < this.ranks[1][i])) continue;
                this.swapColumns(i, j);
            }
        }
    }

    private void swapColumns(int a, int b) {
        double aux1 = this.ranks[0][a];
        double aux2 = this.ranks[1][a];
        double aux3 = this.ranks[2][a];
        this.ranks[0][a] = this.ranks[0][b];
        this.ranks[1][a] = this.ranks[1][b];
        this.ranks[2][a] = this.ranks[2][b];
        this.ranks[0][b] = aux1;
        this.ranks[1][b] = aux2;
        this.ranks[2][b] = aux3;
    }

    private void computeRanks() {
        for (int i = 0; i < this.data.getRows(); ++i) {
            int count;
            double rank = 1.0;
            do {
                double newRank;
                int j;
                double min = Double.MAX_VALUE;
                count = 0;
                for (j = 0; j < this.data.getColumns(); ++j) {
                    if (this.ranks[i][j] == -1.0 && this.samples[i][j] == min) {
                        ++count;
                    }
                    if (this.ranks[i][j] != -1.0 || !(this.samples[i][j] < min)) continue;
                    min = this.samples[i][j];
                    count = 1;
                }
                if (count == 1) {
                    newRank = rank;
                } else {
                    newRank = 0.0;
                    for (int k = 0; k < count; ++k) {
                        newRank += rank + (double)k;
                    }
                    newRank /= (double)count;
                }
                for (j = 0; j < this.data.getColumns(); ++j) {
                    if (this.samples[i][j] != min) continue;
                    this.ranks[i][j] = newRank;
                }
            } while ((rank += (double)count) <= (double)this.data.getColumns());
        }
    }

    public double getTau() {
        return this.tau;
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n**************\n";
        report = report + "Partial Correlation test\n";
        report = report + "**************\n\n";
        report = report + "X-Y --- C: " + this.TxyC + " Q: " + this.TxyQ + " T: " + this.Txy + "\n";
        report = report + "X-Z --- C: " + this.TxzC + " Q: " + this.TxzQ + " T: " + this.Txz + "\n";
        report = report + "Y-Z --- C: " + this.TyzC + " Q: " + this.TyzQ + " T: " + this.Tyz + "\n";
        report = report + "Tau statistic: " + this.nf6.format(this.tau) + "\n";
        report = report + "P-value computed : <= " + this.nf6.format(this.pValue) + "\n\n";
        return report;
    }
}

