/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.multiple.pageTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.tests.PageDistribution;
import javanpst.tests.StatisticalTest;

public class PageTest
extends StatisticalTest {
    private PageDistribution distribution = PageDistribution.getInstance();
    private DataTable data;
    private double[][] samples;
    private double[][] ranks;
    private double[] sumRanks;
    private double L;
    private double asymptoticPValue;
    private double exactPValue;

    public PageTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.L = 0.0;
        this.samples = null;
        this.ranks = null;
        this.sumRanks = null;
        this.asymptoticPValue = -1.0;
        this.exactPValue = -1.0;
    }

    public PageTest(DataTable newData) {
        int i;
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Extended median test only can be employed with more than two samples");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        this.ranks = new double[this.data.getRows()][this.data.getColumns()];
        this.sumRanks = new double[this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            Arrays.fill(this.ranks[i], -1.0);
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
            }
        }
        Arrays.fill(this.sumRanks, 0.0);
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        int i;
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Page test only can be employed with more than two samples");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        this.ranks = new double[this.data.getRows()][this.data.getColumns()];
        this.sumRanks = new double[this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            Arrays.fill(this.ranks[i], -1.0);
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
            }
        }
        Arrays.fill(this.sumRanks, 0.0);
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.computeRanks();
        for (int i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                int n = j;
                this.sumRanks[n] = this.sumRanks[n] + this.ranks[i][j];
            }
        }
        this.L = 0.0;
        for (int j = 0; j < this.data.getColumns(); ++j) {
            this.L += this.sumRanks[j] * ((double)j + 1.0);
        }
        this.exactPValue = this.distribution.computeExactProbability(this.data.getColumns(), this.data.getRows(), this.L);
        this.asymptoticPValue = this.distribution.computeAsymptoticProbability(this.data.getColumns(), this.data.getRows(), this.L);
        this.performed = true;
    }

    private void computeRanks() {
        for (int i = 0; i < this.data.getRows(); ++i) {
            int count;
            double rank = 1.0;
            do {
                double newRank;
                int j;
                double min = Double.MAX_VALUE;
                count = 0;
                for (j = 0; j < this.data.getColumns(); ++j) {
                    if (this.ranks[i][j] == -1.0 && this.samples[i][j] == min) {
                        ++count;
                    }
                    if (this.ranks[i][j] != -1.0 || !(this.samples[i][j] < min)) continue;
                    min = this.samples[i][j];
                    count = 1;
                }
                if (count == 1) {
                    newRank = rank;
                } else {
                    newRank = 0.0;
                    for (int k = 0; k < count; ++k) {
                        newRank += rank + (double)k;
                    }
                    newRank /= (double)count;
                }
                for (j = 0; j < this.data.getColumns(); ++j) {
                    if (this.samples[i][j] != min) continue;
                    this.ranks[i][j] = newRank;
                }
            } while ((rank += (double)count) <= (double)this.data.getColumns());
        }
    }

    public double getL() {
        return this.L;
    }

    public double getAsymptoticPValue() {
        return this.asymptoticPValue;
    }

    public double getExactPValue() {
        return this.exactPValue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        int j;
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n**************\n";
        report = report + "Page test\n";
        report = report + "**************\n\n";
        report = report + "Sum of ranks:\n";
        for (j = 0; j < this.sumRanks.length; ++j) {
            report = report + "S" + (j + 1) + "\t";
        }
        report = report + "\n";
        for (j = 0; j < this.sumRanks.length; ++j) {
            report = report + this.nf6.format(this.sumRanks[j]) + "\t";
        }
        report = report + "\n";
        report = report + "\n";
        report = report + "L statistic: " + this.nf6.format(this.L) + "\n";
        report = report + "Exact p-value: <= " + this.nf6.format(this.exactPValue) + "\n";
        report = report + "Asymptotic p-value:" + this.nf6.format(this.asymptoticPValue) + "\n\n";
        return report;
    }
}

