/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.equality.CDTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.tests.CDDistribution;
import javanpst.tests.StatisticalTest;

public class CDTest
extends StatisticalTest {
    private CDDistribution distribution = CDDistribution.getInstance();
    private DataTable data;
    private double[][] samples;
    private double median;
    private double[] control;
    private double W;
    private double asymptoticPValue;
    private double exactPValue;

    public CDTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.W = 0.0;
        this.median = 0.0;
        this.samples = null;
        this.asymptoticPValue = -1.0;
        this.exactPValue = -1.0;
    }

    public CDTest(DataTable newData) {
        int i;
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Extended median test only can be employed with more than two samples");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
            }
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        int i;
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Extended median test only can be employed with more than two samples");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
            }
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.control = new double[this.data.getRows()];
        for (int i = 0; i < this.data.getRows(); ++i) {
            this.control[i] = this.data.get(i, 0);
        }
        Arrays.sort(this.control);
        this.median = this.samples[0].length % 2 == 0 ? (this.control[this.control.length / 2] + this.control[this.control.length / 2 - 1]) / 2.0 : this.control[(this.control.length - 1) / 2];
        this.W = 0.0;
        for (int sample = 1; sample < this.samples[0].length; ++sample) {
            for (int j = 0; j < this.samples.length; ++j) {
                if (!(this.samples[j][sample] < this.median)) continue;
                this.W += 1.0;
            }
        }
        this.exactPValue = this.distribution.computeExactProbability(this.W, this.data.getRows() * this.data.getColumns(), this.data.getColumns(), this.data.getRows());
        this.asymptoticPValue = this.distribution.computeAsymptoticProbability(this.W, this.data.getRows() * this.data.getColumns(), this.data.getColumns(), this.data.getRows());
        this.performed = true;
    }

    public double getW() {
        return this.W;
    }

    public double getZ() {
        return this.median;
    }

    public double getExactPValue() {
        return this.exactPValue;
    }

    public double getAsymptoticPValue() {
        return this.asymptoticPValue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n***************************************\n";
        report = report + "Charkraborti and Desu test (CD test)\n";
        report = report + "***************************************\n\n";
        report = report + "Median value of the control: " + this.nf6.format(this.median) + "\n\n";
        report = report + "W statistic: " + this.nf6.format(this.W) + "\n\n";
        report = report + "Exact P-Value:" + this.nf6.format(this.exactPValue) + "\n";
        report = report + "Asymptotic P-Value:" + this.nf6.format(this.asymptoticPValue) + "\n\n";
        return report;
    }
}

