/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.tests;

import java.io.IOException;
import javanpst.data.distributions.criticalTable.Critical1KeyTable;
import javanpst.data.readers.distributionReaders.LillieforsExponentialReaderFormat;
import javanpst.data.readers.distributionReaders.LillieforsNormalReaderFormat;
import javanpst.distributions.tests.TestDistribution;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LillieforsDistribution
extends TestDistribution {
    private static Critical1KeyTable tableNormal;
    private static Critical1KeyTable tableExponential;
    private static boolean aproximated;

    private LillieforsDistribution() {
        this.initialize();
    }

    public static LillieforsDistribution getInstance() {
        return SingletonHolder.distribution;
    }

    @Override
    protected void generateTables() {
        double[] tags = new double[]{0.1, 0.05, 0.01, 0.001};
        tableNormal = new Critical1KeyTable(101, tags);
        tableExponential = new Critical1KeyTable(101, tags);
        this.loadFiles();
    }

    @Override
    protected void loadFiles() {
        SAXParser sp;
        SAXParserFactory spf;
        try {
            spf = SAXParserFactory.newInstance();
            sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/Lilliefors/LillieforsNormal.xml"), (DefaultHandler)new LillieforsNormalReaderFormat());
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
        try {
            spf = SAXParserFactory.newInstance();
            sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/Lilliefors/LillieforsExponential.xml"), (DefaultHandler)new LillieforsExponentialReaderFormat());
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
    }

    public static Critical1KeyTable getNormalTable() {
        return tableNormal;
    }

    public static Critical1KeyTable getExponentialTable() {
        return tableExponential;
    }

    public double computeProbabilityNormal(int n, double Dn) {
        double[] asymptoticValuesNormal = new double[]{0.816, 0.888, 1.038, 1.212};
        if (n > 3) {
            if (tableNormal.get(n, 0) == -1.0) {
                aproximated = false;
                for (int i = 3; i > -1; --i) {
                    if (!(Dn >= tableNormal.get(n, i))) continue;
                    return tableNormal.getHeader(i);
                }
            } else {
                aproximated = true;
                double size = Math.sqrt(n);
                for (int i = 3; i > -1; --i) {
                    if (!(Dn >= asymptoticValuesNormal[i] / size)) continue;
                    return tableNormal.getHeader(i);
                }
            }
        } else {
            aproximated = true;
            return 1.0;
        }
        return 1.0;
    }

    public double computeProbabilityExponential(int n, double Dn) {
        double[] asymptoticValuesExponential = new double[]{0.98, 1.077, 1.274, 1.501};
        if (n > 3) {
            if (tableExponential.get(n, 0) == -1.0) {
                aproximated = false;
                for (int i = 3; i > -1; --i) {
                    if (!(Dn >= tableExponential.get(n, i))) continue;
                    return tableExponential.getHeader(i);
                }
            } else {
                aproximated = true;
                double size = Math.sqrt(n);
                for (int i = 3; i > -1; --i) {
                    if (!(Dn >= asymptoticValuesExponential[i] / size)) continue;
                    return tableExponential.getHeader(i);
                }
            }
        } else {
            aproximated = true;
            return 1.0;
        }
        return 1.0;
    }

    public boolean isApproximate() {
        return aproximated;
    }

    private static class SingletonHolder {
        public static final LillieforsDistribution distribution = new LillieforsDistribution();

        private SingletonHolder() {
        }
    }
}

