/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.tests;

import javanpst.distributions.common.continuous.ChiSquareDistribution;
import javanpst.distributions.tests.TestDistribution;
import javanpst.utils.Operations;

public class FisherDistribution
extends TestDistribution {
    private ChiSquareDistribution chi;

    private FisherDistribution() {
        this.initialize();
    }

    public static FisherDistribution getInstance() {
        return SingletonHolder.distribution;
    }

    @Override
    protected void generateTables() {
        this.chi = new ChiSquareDistribution();
    }

    @Override
    protected void loadFiles() {
    }

    public double computeLeftExactProbability(int N, int n1, int n2, int Y, int n00) {
        double numerator = 0.0;
        for (int i = n00; i <= n1; ++i) {
            numerator += Operations.combinatorial(n1, i) * Operations.combinatorial(n2, Y - i);
        }
        double denominator = Operations.combinatorial(N, Y);
        double pValue = numerator / denominator;
        return pValue;
    }

    public double computeRightExactProbability(int N, int n1, int n2, int Y, int n00) {
        double numerator = 0.0;
        for (int i = n00; i >= 0; --i) {
            numerator += Operations.combinatorial(n1, i) * Operations.combinatorial(n2, Y - i);
        }
        double denominator = Operations.combinatorial(N, Y);
        double pValue = numerator / denominator;
        return pValue;
    }

    public double computeAsymptoticProbability(double Q, int freedom) {
        this.chi.setDegree(freedom);
        return this.chi.computeCumulativeProbability(Q);
    }

    private static class SingletonHolder {
        public static final FisherDistribution distribution = new FisherDistribution();

        private SingletonHolder() {
        }
    }
}

