/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.common.continuous;

import javanpst.distributions.common.Distribution;

public class UniformCDistribution
implements Distribution {
    private double start;
    private double end;

    public UniformCDistribution() {
        this.start = 0.0;
        this.end = 1.0;
    }

    public UniformCDistribution(double start, double end) {
        if (start < end) {
            this.start = start;
            this.end = end;
        }
    }

    public UniformCDistribution(UniformCDistribution old) {
        this(old.getStart(), old.getEnd());
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.end;
    }

    public void setStart(double value) {
        if (value < this.end) {
            this.start = value;
        }
    }

    public void setEnd(double value) {
        if (value > this.start) {
            this.end = value;
        }
    }

    @Override
    public double computeProbability(double x) {
        double value = this.start <= x && x <= this.end ? 1.0 / (this.end - this.start) : 0.0;
        return value;
    }

    @Override
    public double computeCumulativeProbability(double x) {
        double value = (x - this.start) / (this.end - this.start);
        value = Math.max(Math.min(value, 1.0), 0.0);
        return value;
    }

    public String toString() {
        String text = "";
        text = text + "Continuous Uniform distribution. Start: " + this.start + " End: " + this.end;
        return text;
    }
}

