/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.common.continuous;

import javanpst.distributions.common.Distribution;

public final class ExponentialDistribution
implements Distribution {
    private double lambda;

    public ExponentialDistribution() {
        this.lambda = 1.0;
    }

    public ExponentialDistribution(double lambda) {
        this.lambda = lambda;
    }

    public ExponentialDistribution(ExponentialDistribution old) {
        this(old.getLambda());
    }

    public void setLambda(double value) {
        this.lambda = value;
    }

    public void setMean(double value) {
        this.lambda = 1.0 / value;
    }

    public double getMean() {
        return 1.0 / this.lambda;
    }

    public double getLambda() {
        return this.lambda;
    }

    @Override
    public double computeProbability(double x) {
        double value = x >= 0.0 ? this.lambda * Math.pow(Math.E, -this.lambda * x) : 0.0;
        return value;
    }

    @Override
    public double computeCumulativeProbability(double x) {
        double value = x >= 0.0 ? 1.0 - Math.pow(Math.E, -this.lambda * x) : 0.0;
        return value;
    }

    public String toString() {
        String text = "";
        text = text + "Exponential distribution. Parameters Lambda: " + this.lambda;
        return text;
    }
}

