/*
 * Decompiled with CFR 0.152.
 */
package javanpst.data.distributions.criticalTable;

import java.util.Arrays;

public class Critical2KeyTable {
    private double[][][] body;
    private double[] pValues;

    public Critical2KeyTable(int dim1, int dim2, double[] criticals) {
        this.pValues = new double[criticals.length];
        this.body = new double[dim1][dim2][criticals.length];
        System.arraycopy(criticals, 0, this.pValues, 0, criticals.length);
        this.clear();
    }

    public void clear() {
        for (int i = 0; i < this.body.length; ++i) {
            for (int j = 0; j < this.body[0].length; ++j) {
                Arrays.fill(this.body[i][j], -1.0);
            }
        }
    }

    public double getHeader(int index) {
        return this.pValues[index];
    }

    public double estimate(int dim1, int dim2, double critical) {
        boolean found = false;
        int pointer = 0;
        while (!found && pointer < this.pValues.length) {
            if (critical >= this.body[dim1][dim2][pointer]) {
                found = true;
                continue;
            }
            ++pointer;
        }
        if (found) {
            return this.getHeader(pointer);
        }
        return 1.0;
    }

    public void set(int dim1, int dim2, int keyCritical, double value) {
        this.body[dim1][dim2][keyCritical] = value;
    }
}

