/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.SurfaceParametric;

public class Torus
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "1.75", "1.2", "1.2");
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", "0.4", "0.3", "1.2");
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", "0.4", "0.3", "1.2");

    public Torus() {
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(32);
        this.umin.reset("0");
        this.umax.reset("2 pi");
        this.vmin.reset("0");
        this.vmax.reset("2 pi");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.5, 2.5, -2.5, 2.5);
        this.setDefaultOrientation(2);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.addParameter(this.cc);
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = this.aa.getValue();
        double BB = this.bb.getValue();
        double CC = this.cc.getValue();
        double x = (AA + BB * Math.cos(u)) * Math.cos(v);
        double y = (AA + BB * Math.cos(u)) * Math.sin(v);
        double z = CC * Math.sin(u);
        return new Vector3D(x, y, z);
    }
}

