/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import vmm3d.core.Complex;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.SurfaceParametric;

public class Kusner_Dihedral_Symmetric
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "0", "0", "pi / 2");
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", 4.0, 4.0, 4.0);

    public Kusner_Dihedral_Symmetric() {
        this.uPatchCount.setValueAndDefault(8);
        this.vPatchCount.setValueAndDefault(34);
        this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 17.3));
        this.setDefaultWindow(-1.25, 1.25, -1.25, 1.25);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.umin.reset(Math.log(0.002));
        this.umax.reset(-0.45);
        this.vmin.reset(0.0);
        this.vmax.reset("2*pi");
        this.addParameter(this.aa);
        this.addParameter(this.bb);
    }

    private static Complex Pow(Complex z, int k) {
        Complex w = new Complex(z);
        for (int i = 2; i <= k; ++i) {
            w = w.times(z);
        }
        return w;
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double afp = this.aa.getValue();
        double BB = this.bb.getValue();
        int Pp = Math.max(Math.round((int)BB), 2);
        int Qq = Pp - 1;
        Complex a = new Complex(2.0 * Math.sqrt(2 * Pp - 1) / (double)Qq, 0.0);
        Complex b = new Complex(0.0, (double)Qq / (double)Pp);
        double COSafp = Math.cos(afp);
        double SINafp = Math.sin(afp);
        Complex One_C = new Complex(1.0, 0.0);
        Complex I_C = new Complex(0.0, 1.0);
        Complex z = new Complex(Math.exp(u) * Math.cos(v), Math.exp(u) * Math.sin(v));
        Complex temp1 = new Complex();
        Complex temp2 = new Complex();
        temp1 = Kusner_Dihedral_Symmetric.Pow(z, Qq);
        temp2 = One_C.dividedBy(temp1);
        Complex zToQqPlusOneOverZToQq = new Complex();
        Complex zToQqMinusOneOverZToQq = new Complex();
        zToQqPlusOneOverZToQq = temp1.plus(temp2);
        zToQqMinusOneOverZToQq = temp1.minus(temp2);
        temp1 = temp1.times(z);
        temp2 = temp2.dividedBy(z);
        Complex zToPpPlusOneOverZToPp = new Complex();
        Complex zToPpMinusOneOverZToPp = new Complex();
        zToPpPlusOneOverZToPp = temp1.plus(temp2);
        zToPpMinusOneOverZToPp = temp1.minus(temp2);
        Complex multiplier = new Complex();
        multiplier = One_C.dividedBy(zToPpMinusOneOverZToPp.plus(a));
        Complex Wx = new Complex();
        Wx = I_C.times(zToQqMinusOneOverZToQq);
        Wx = multiplier.times(Wx);
        Complex Wy = new Complex();
        Wy = multiplier.times(zToQqPlusOneOverZToQq);
        Complex Wz = new Complex();
        Wz = b.times(zToPpPlusOneOverZToPp);
        Wz = multiplier.times(Wz);
        double x = COSafp * Wx.re + SINafp * Wx.im;
        double y = COSafp * Wy.re + SINafp * Wy.im;
        double zz = COSafp * Wz.re + SINafp * Wz.im;
        return new Vector3D(x, y, zz);
    }
}

