/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import vmm3d.core.Complex;
import vmm3d.core.IntegerParam;
import vmm3d.core.Parameter;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.View;
import vmm3d.core3D.ComplexVector3D;
import vmm3d.core3D.GridTransformMatrix;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.WeierstrassMinimalSurface;

public class CostaHoffmanMeeks
extends WeierstrassMinimalSurface {
    private IntegerParam exponent = new IntegerParam("vmm3d.surface.parametric.CostaHoffmanMeeks.exponent", 2);
    private RealParamAnimateable lrp = new RealParamAnimateable("vmm3d.surface.parametric.CostaHoffmanMeeks.lrp", 1.0, 1.2, 0.8);
    private int Ex;
    private int iP;
    private int um;
    private int vm;
    double amp;
    private double r1;
    private double LRP;
    private Complex qP;

    public CostaHoffmanMeeks() {
        this.addParameter(this.lrp);
        this.lrp.setMinimumValueForInput(0.1);
        this.addParameter(this.exponent);
        this.exponent.setMinimumValueForInput(2);
        this.setDefaultOrientation(0);
        this.setDefaultViewpoint(new Vector3D(25.0, 43.0, -10.0));
        this.setDefaultViewUp(new Vector3D(0.1, -0.3, -1.0));
        this.setDefaultWindow(-9.0, 9.0, -8.0, 8.0);
        this.uPatchCount.setValueAndDefault(24);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-1.9);
        this.umax.reset(2.4);
        this.vmin.reset(-0.99995);
        this.vmax.reset(0.99995);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.iFirstInHelper = false;
        this.needsPeriodClosed = true;
        this.wantsToSeeDomain = false;
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.canShowConjugateSurface = false;
    }

    @Override
    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView view = new WeierstrassMinimalSurface.WMSView(this);
        view.setGridSpacing(6);
        return view;
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        this.AFP = this.afp.getValue();
        if (param != this.afp) {
            this.needsValueArray = true;
        }
        if (param == this.exponent) {
            this.needsPeriodClosed = true;
            this.LRP = 1.0;
        }
    }

    @Override
    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] trList = new GridTransformMatrix[4 * this.Ex];
        trList[0] = new GridTransformMatrix();
        if (!this.inAssociateMorph && !this.wantsToSeeDomain && this.flag0) {
            int e;
            trList[1] = new GridTransformMatrix().scale(1.0, -1.0, 1.0);
            this.data.addGridTransform(trList[1]);
            for (e = 2; e < 2 * this.Ex; ++e) {
                trList[e] = new GridTransformMatrix(trList[e - 2]).rotateZ(360.0 / (double)this.Ex);
                this.data.addGridTransform(trList[e]);
            }
            for (e = 0; e < 2 * this.Ex; ++e) {
                trList[e + 2 * this.Ex] = new GridTransformMatrix(trList[e]).scale(1.0, -1.0, -1.0).rotateZ(180.0 / (double)this.Ex).reverse();
                this.data.addGridTransform(trList[e + 2 * this.Ex]);
            }
        }
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        double a;
        double r = Math.exp(CostaHoffmanMeeks.monotonPow(u, 2));
        Complex z = new Complex(r * Math.cos(a = Math.PI * Math.sin(v * Math.PI / 2.0)) + 1.0, r * Math.sin(a));
        Complex w = z.squareRootNearer(ONE_C);
        if (w.r() < this.amp) {
            w.re = Math.max(w.re, this.amp - (double)this.Ex * Math.abs(z.im));
        }
        return w;
    }

    protected void p_Index() {
        for (int i = 0; i < this.ucount; ++i) {
            Complex z = this.domainGrid(this.umin.getValue() + (double)i * this.du, this.vmin.getValue());
            if (!(Math.abs(z.im) < 1.0E-4)) continue;
            this.iP = i;
        }
    }

    @Override
    protected Complex gauss(Complex z) {
        double denom = z.re * z.re + z.im * z.im;
        Complex w = new Complex(z.re / denom - z.re, -z.im * (1.0 / denom + 1.0));
        Complex aux = z.im > 0.0 ? w.logNearer(ZERO_C).times(1.0 / (double)this.Ex) : w.logNearer(IP__C).times(1.0 / (double)this.Ex);
        w = aux.exponential();
        w.assignTimes(z);
        w.assignTimes(this.LRP);
        return w;
    }

    @Override
    protected Complex hPrime(Complex z) {
        Complex w = z.times(z);
        double denom = ((w.re - 1.0) * (w.re - 1.0) + w.im * w.im) / this.r1;
        return new Complex((w.re - 1.0) / denom, -w.im / denom);
    }

    protected double closingLopezRos() {
        double factRight;
        double constLeft;
        double as = this.helperArray[0][this.vm].y.re;
        double bs = -this.helperArray[0][this.vm].x.re;
        double cs = -this.helperArray[0][this.vm].y.im;
        double ds = -this.helperArray[0][this.vm].x.im;
        double ts = Math.cos(Math.PI / (1.0 * (double)this.Ex)) / Math.sin(Math.PI / (1.0 * (double)this.Ex));
        if (this.Ex != 3) {
            double al = this.helperArray[this.iP + 3][this.vcount - 1].y.re;
            double bl = -this.helperArray[this.iP + 3][this.vcount - 1].x.re;
            double cl = -this.helperArray[this.iP + 3][this.vcount - 1].y.im;
            double dl = -this.helperArray[this.iP + 3][this.vcount - 1].x.im;
            double tl = Math.cos(Math.PI / (2.0 * (double)this.Ex)) / Math.sin(Math.PI / (2.0 * (double)this.Ex));
            constLeft = -cs * ts - as + cl * tl + al;
            factRight = -dl * tl - bl + ds * ts + bs;
        } else {
            double al = this.helperArray[this.iP + 3][0].y.re;
            double bl = -this.helperArray[this.iP + 3][0].x.re;
            double cl = -this.helperArray[this.iP + 3][0].y.im;
            double dl = -this.helperArray[this.iP + 3][0].x.im;
            double tl = Math.cos(Math.PI * 3 / (2.0 * (double)this.Ex)) / Math.sin(Math.PI * 3 / (2.0 * (double)this.Ex));
            constLeft = -cs * ts - as + cl * tl - al;
            factRight = -dl * tl + bl + ds * ts + bs;
        }
        double ro = Math.sqrt(constLeft / factRight);
        this.LRP = ro * this.lrp.getValue();
        return ro;
    }

    @Override
    protected void doClosingJob() {
        this.LRPclosed = this.closingLopezRos();
        this.createHelperArray();
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.LRP = this.needsPeriodClosed ? 1.0 : this.LRPclosed * this.lrp.getValue();
        this.Ex = this.exponent.getValue();
        this.r1 = 1.0;
        this.amp = 4.8828125E-4 / (double)this.Ex / (double)this.Ex / (double)this.Ex;
        this.p_Index();
        this.um = (int)Math.floor((double)(this.ucount - 1) / 2.0);
        this.vm = (int)Math.floor((double)(this.vcount - 1) / 2.0);
    }

    @Override
    protected ComplexVector3D getCenter() {
        if (this.inAssociateMorph || this.wantsToSeeDomain) {
            return new ComplexVector3D(this.helperArray[this.um][this.vm]);
        }
        ComplexVector3D minMaxMin2 = this.helperToMinimal(this.helperArray[0][0]);
        ComplexVector3D minMaxMin1 = this.helperToMinimal(this.helperArray[8][0]);
        ComplexVector3D minMaxMid1 = this.helperToMinimal(this.helperArray[this.um][this.vm]);
        ComplexVector3D minMaxMid2 = this.helperToMinimal(this.helperArray[this.ucount - 1][this.vm]);
        ComplexVector3D zeroLevel = this.helperToMinimal(this.helperArray[this.ucount - 1][0]);
        Complex z1 = new Complex(minMaxMid1.x.re, minMaxMid1.y.re);
        Complex z2 = new Complex(minMaxMid2.x.re, minMaxMid2.y.re);
        Complex w1 = new Complex(minMaxMin1.x.re, minMaxMin1.y.re);
        Complex w2 = new Complex(minMaxMin2.x.re, minMaxMin2.y.re);
        Complex cs = this.intersectLines(z1, z2, w1, w2);
        return this.minimalToHelper(new ComplexVector3D(cs, cs.times(I__C), zeroLevel.z));
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        ComplexVector3D eW;
        int i = (int)Math.floor(0.25 + (u - this.umin.getValue()) / this.du);
        int j = (int)Math.floor(0.25 + (v - this.vmin.getValue()) / this.dv);
        if (!(this.lrp.getValue() != 1.0 || this.inAssociateMorph || this.wantsToSeeDomain || i != this.iP + 1 || j != this.vcount - 1 && j != 0)) {
            eW = new ComplexVector3D(ComplexVector3D.ORIGIN);
        } else {
            ComplexVector3D auxW = new ComplexVector3D(this.helperArray[i][j].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)i * this.du, this.vmin.getValue() + (double)j * this.dv), this.domainGrid(u, v))));
            eW = this.helperToMinimal(auxW);
        }
        if (this.wantsToSeeDomain) {
            return new Vector3D(eW.z.re, eW.z.im, 0.0);
        }
        if (this.AFP == 0.0) {
            return eW.re();
        }
        return eW.re().times(Math.cos(this.AFP)).plus(eW.im().times(Math.sin(this.AFP)));
    }
}

