/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.implicit;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.actions.ActionList;
import vmm3d.actions.ActionRadioGroup;
import vmm3d.core.Animateable;
import vmm3d.core.BasicAnimator;
import vmm3d.core.Decoration;
import vmm3d.core.Display;
import vmm3d.core.Exhibit;
import vmm3d.core.I18n;
import vmm3d.core.IntegerParam;
import vmm3d.core.Parameter;
import vmm3d.core.Prefs;
import vmm3d.core.RealParam;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.TaskManager;
import vmm3d.core.VMMSave;
import vmm3d.core.View;
import vmm3d.core3D.Exhibit3D;
import vmm3d.core3D.LightSettings;
import vmm3d.core3D.PhongLighting;
import vmm3d.core3D.Transform3D;
import vmm3d.core3D.Vector3D;
import vmm3d.core3D.View3D;
import vmm3d.core3D.View3DWithLightSettings;
import vmm3d.surface.implicit.Maps;

public abstract class SurfaceImplicit
extends Exhibit3D {
    equationType heightFunctionType = equationType.OTHER;
    protected RealParamAnimateable level = new RealParamAnimateable("vmm3d.surface.implicit.SurfaceImplicit.level", 0.0);
    protected IntegerParam pointCloudCount = new IntegerParam("vmm3d.surface.implicit.SurfaceImplicit.pointCloudCount", 2000);
    protected IntegerParam randomLineCount = new IntegerParam("vmm3d.surface.implicit.SurfaceImplicit.randomLineCount", 40000);
    protected RealParamAnimateable searchRadius = new RealParamAnimateable("vmm3d.surface.implicit.SurfaceImplicit.searchRadius", 3.0);
    protected RealParam rayTraceResolution = new RealParam("vmm3d.surface.implicit.SurfaceImplicit.rayTraceResolution", 0.05);
    protected Vector3D[] pointCloud;
    private int numberOfPointsInCloud = 0;
    private TaskManager taskManager;
    protected Line3D[] ListOfRandomLines;
    private double searchRadiusUsedForRandomLines;
    protected double resolution = this.rayTraceResolution.getValue();

    public abstract double heightFunction(double var1, double var3, double var5);

    public double heightFunction(Vector3D thePoint) {
        return this.heightFunction(thePoint.x, thePoint.y, thePoint.z);
    }

    public SurfaceImplicit() {
        this.addParameter(this.level);
        this.addParameter(this.rayTraceResolution);
        this.rayTraceResolution.setMinimumValueForInput(1.0E-5);
        this.addParameter(this.pointCloudCount);
        this.pointCloudCount.setMinimumValueForInput(200);
        this.pointCloudCount.setMaximumValueForInput(50000);
        this.addParameter(this.randomLineCount);
        this.randomLineCount.setMinimumValueForInput(1000);
        this.randomLineCount.setMaximumValueForInput(200000);
        this.addParameter(this.searchRadius);
        this.searchRadius.setMinimumValueForInput(Double.MIN_VALUE);
        this.setFramesForMorphing(12);
        this.setUseFilmstripForMorphing(true);
        this.setDefaultBackground(Color.BLACK);
    }

    public Vector3D normalToSurfaceAt(Vector3D P) {
        double delta = 1.0E-6;
        double TwoOverDelta = 2.0 / delta;
        Vector3D grad = new Vector3D();
        grad.x = this.heightFunction(P.x + delta, P.y, P.z) - this.heightFunction(P.x - delta, P.y, P.z);
        grad.y = this.heightFunction(P.x, P.y + delta, P.z) - this.heightFunction(P.x, P.y - delta, P.z);
        grad.z = this.heightFunction(P.x, P.y, P.z + delta) - this.heightFunction(P.x, P.y, P.z - delta);
        Vector3D gradient = new Vector3D(grad.times(TwoOverDelta));
        return gradient.normalized();
    }

    @Override
    public void removeView(View view) {
        super.removeView(view);
        if (this.taskManager != null && (this.getViews() == null || this.getViews().size() == 0)) {
            this.taskManager.shutDown();
            this.taskManager = null;
        }
    }

    public synchronized void MakeListOfRandomLines() {
        double desiredSearchRadius = this.searchRadius.getValue();
        int desiredNumberOfLines = this.randomLineCount.getValue();
        if (this.searchRadiusUsedForRandomLines == desiredSearchRadius && this.ListOfRandomLines != null && this.ListOfRandomLines.length == desiredNumberOfLines + 1) {
            return;
        }
        this.searchRadiusUsedForRandomLines = desiredSearchRadius;
        this.ListOfRandomLines = new Line3D[this.randomLineCount.getValue() + 1];
        ArrayList<MakeRandomLines> jobs = new ArrayList<MakeRandomLines>();
        for (int start = 1; start < this.ListOfRandomLines.length; start += 500) {
            int end = start + 500 - 1;
            if (end >= this.ListOfRandomLines.length) {
                end = this.ListOfRandomLines.length - 1;
            }
            jobs.add(new MakeRandomLines(start, end));
        }
        if (this.taskManager == null) {
            this.taskManager = new TaskManager();
        }
        this.taskManager.executeAndWait(jobs);
    }

    protected double heightAlongLine(double t, Line3D line) {
        Vector3D point = new Vector3D(line.parametricEquation(t));
        double theHeight = this.heightFunction(point.x, point.y, point.z);
        return theHeight;
    }

    public double theFunction(double t, Line3D theLine) {
        return this.heightAlongLine(t, theLine) - this.level.getValue();
    }

    public void quadraticSolve(Line3D theLine, double[] theRoots) {
        double numRoots;
        double c;
        double a;
        double f_1 = this.theFunction(-1.0, theLine);
        double f0 = this.theFunction(0.0, theLine);
        double f1 = this.theFunction(1.0, theLine);
        double b = 0.5 * (f1 - f_1);
        double Disc = b * b - 4.0 * (a = f1 - b - (c = f0)) * c;
        theRoots[0] = numRoots = Disc >= 0.0 ? 2.0 : 0.0;
        if (numRoots == 2.0) {
            theRoots[1] = 0.5 * (-b - Math.sqrt(Disc)) / a;
            theRoots[2] = 0.5 * (-b + Math.sqrt(Disc)) / a;
            if (theRoots[2] < theRoots[1]) {
                double t = theRoots[2];
                theRoots[2] = theRoots[1];
                theRoots[1] = t;
            }
        }
    }

    public void cubicSolve(Line3D theLine, double[] theRoots) {
        double d;
        double b;
        double EPS = 1.0E-9;
        double f_1 = this.theFunction(-1.0, theLine);
        double f0 = this.theFunction(0.0, theLine);
        double f1 = this.theFunction(1.0, theLine);
        double f2 = this.theFunction(2.0, theLine);
        double a = 0.16666666666666666 * (f2 - 4.0 * (b = 0.5 * (f1 + f_1) - (d = f0)) - (f1 - f_1) - d);
        if (Math.abs(a) < 1.0E-9) {
            this.quadraticSolve(theLine, theRoots);
        } else {
            double A = b / a;
            double c = 0.5 * (f1 - f_1) - a;
            double B = c / a;
            double C = d / a;
            double q = 0.037037037037037035 * A * A * A - 0.16666666666666666 * A * B + 0.5 * C;
            double p = 0.3333333333333333 * (-0.3333333333333333 * A * A + B);
            double cube_p = p * p * p;
            double disc = q * q + cube_p;
            if (Math.abs(disc) < 1.0E-9) {
                if (Math.abs(q) < 1.0E-9) {
                    theRoots[0] = 1.0;
                    theRoots[1] = 0.0;
                } else {
                    theRoots[0] = 2.0;
                    double u = Math.cbrt(-q);
                    theRoots[1] = 2.0 * u;
                    theRoots[2] = -u;
                }
            } else if (disc < 0.0) {
                double phi = 0.3333333333333333 * Math.acos(-q / Math.sqrt(-cube_p));
                double s = 2.0 * Math.sqrt(-p);
                theRoots[0] = 3.0;
                theRoots[1] = s * Math.cos(phi);
                theRoots[2] = -s * Math.cos(phi + 1.0471975511965976);
                theRoots[3] = -s * Math.cos(phi - 1.0471975511965976);
            } else {
                double sqrt_disc = Math.sqrt(disc);
                double u = Math.cbrt(sqrt_disc - q);
                double v = -Math.cbrt(sqrt_disc + q);
                theRoots[0] = 1.0;
                theRoots[1] = u + v;
            }
            int i = 1;
            while ((double)i <= theRoots[0]) {
                theRoots[i] = theRoots[i] - 0.3333333333333333 * A;
                ++i;
            }
        }
        int i = 2;
        while ((double)i <= theRoots[0]) {
            for (int j = i; j > 1 && theRoots[j - 1] > theRoots[j]; --j) {
                double t = theRoots[j];
                theRoots[j] = theRoots[j - 1];
                theRoots[j - 1] = t;
            }
            ++i;
        }
    }

    public void quarticSolve(Line3D theLine, double[] theRoots) {
        double d2;
        double q;
        double c4;
        double c3;
        double r;
        double c;
        double c2;
        double d;
        double e;
        double a;
        double inva;
        double f_2 = this.theFunction(-2.0, theLine);
        double f_1 = this.theFunction(-1.0, theLine);
        double f0 = this.theFunction(0.0, theLine);
        double f1 = this.theFunction(1.0, theLine);
        double f2 = this.theFunction(2.0, theLine);
        double b = 0.08333333333333333 * (f2 - f_2) - 0.16666666666666666 * (f1 - f_1);
        double c1 = b * (inva = 1.0 / (a = 0.08333333333333333 * (f2 - 8.0 * b - 2.0 * (f1 + f_1) + 3.0 * (e = f0) - 2.0 * (d = 0.5 * (f1 - f_1) - b))));
        double c12 = c1 * c1;
        double p = -0.375 * c12 + (c2 = (c = 0.5 * (f1 + f_1) - e - a) * inva);
        double z = SurfaceImplicit.solveCubicForQuartic(-0.5 * p, -(r = -0.01171875 * c12 * c12 + 0.0625 * c12 * c2 - 0.25 * c1 * (c3 = d * inva) + (c4 = e * inva)), 0.5 * r * p - 0.125 * (q = 0.125 * c12 * c1 - 0.5 * c1 * c2 + c3) * q);
        double d1 = 2.0 * z - p;
        if (d1 < 0.0) {
            if (d1 > 1.0E-10) {
                d1 = 0.0;
            }
            theRoots[0] = 0.0;
        }
        if (d1 < 1.0E-10) {
            d2 = z * z - r;
            if (d2 < 0.0) {
                theRoots[0] = 0.0;
            }
            d2 = Math.sqrt(d2);
        } else {
            d1 = Math.sqrt(d1);
            d2 = 0.5 * q / d1;
        }
        double q1 = d1 * d1;
        double q2 = -0.25 * c1;
        double pm = q1 - 4.0 * (z - d2);
        double pp = q1 - 4.0 * (z + d2);
        if (pm >= 0.0 && pp >= 0.0) {
            pm = Math.sqrt(pm);
            pp = Math.sqrt(pp);
            theRoots[0] = 4.0;
            theRoots[1] = -0.5 * (d1 + pm) + q2;
            theRoots[2] = -0.5 * (d1 - pm) + q2;
            theRoots[3] = 0.5 * (d1 + pp) + q2;
            theRoots[4] = 0.5 * (d1 - pp) + q2;
        } else if (pm >= 0.0) {
            pm = Math.sqrt(pm);
            theRoots[0] = 2.0;
            theRoots[1] = -0.5 * (d1 + pm) + q2;
            theRoots[2] = -0.5 * (d1 - pm) + q2;
        } else if (pp >= 0.0) {
            pp = Math.sqrt(pp);
            theRoots[0] = 2.0;
            theRoots[1] = 0.5 * (d1 - pp) + q2;
            theRoots[2] = 0.5 * (d1 + pp) + q2;
        }
        int i = 2;
        while ((double)i <= theRoots[0]) {
            for (int j = i; j > 1 && theRoots[j - 1] > theRoots[j]; --j) {
                double t = theRoots[j];
                theRoots[j] = theRoots[j - 1];
                theRoots[j - 1] = t;
            }
            ++i;
        }
    }

    private static final double solveCubicForQuartic(double p, double q, double r) {
        double A2 = p * p;
        double Q = (A2 - 3.0 * q) / 9.0;
        double R = (p * (A2 - 4.5 * q) + 13.5 * r) / 27.0;
        double Q3 = Q * Q * Q;
        double R2 = R * R;
        double d = Q3 - R2;
        double an = p / 3.0;
        if (d >= 0.0) {
            d = R / Math.sqrt(Q3);
            double theta = Math.acos(d) / 3.0;
            double sQ = -2.0 * Math.sqrt(Q);
            return sQ * Math.cos(theta) - an;
        }
        double sQ = Math.pow(Math.sqrt(R2 - Q3) + Math.abs(R), 0.3333333333333333);
        if (R < 0.0) {
            return sQ + Q / sQ - an;
        }
        return -(sQ + Q / sQ) - an;
    }

    public double FindNextRoot(Line3D theLine, double leftEnd, double rightEnd, double tolerance) {
        double[] args = new double[3];
        double[] values = new double[3];
        args[1] = leftEnd;
        args[2] = rightEnd;
        values[1] = this.theFunction(args[1], theLine);
        values[2] = this.theFunction(args[2], theLine);
        double u = (args[1] * values[2] - args[2] * values[1]) / (values[2] - values[1]);
        return u;
    }

    private void IntersectLineWithImplicitQuadraticSurface(Line3D theLine, double[] theRoots, ArrayList<Vector3D> points) {
        double searchRadiusSquared = Math.pow(this.searchRadius.getValue(), 2.0);
        double interceptNormSquared = Math.pow(theLine.intercept.norm(), 2.0);
        double currentIntervalBound = Math.sqrt(searchRadiusSquared - interceptNormSquared);
        this.quadraticSolve(theLine, theRoots);
        if (theRoots[0] == 2.0) {
            if (Math.abs(theRoots[1]) <= currentIntervalBound) {
                points.add(new Vector3D(theLine.parametricEquation(theRoots[1])));
            }
            if (Math.abs(theRoots[2]) <= currentIntervalBound) {
                points.add(new Vector3D(theLine.parametricEquation(theRoots[2])));
            }
        }
    }

    private void IntersectLineWithImplicitCubicSurface(Line3D theLine, double[] theRoots, ArrayList<Vector3D> points) {
        double searchRadiusSquared = Math.pow(this.searchRadius.getValue(), 2.0);
        double interceptNormSquared = Math.pow(theLine.intercept.norm(), 2.0);
        double currentIntervalBound = Math.sqrt(searchRadiusSquared - interceptNormSquared);
        this.cubicSolve(theLine, theRoots);
        if (theRoots[0] > 0.0 && Math.abs(theRoots[1]) <= currentIntervalBound) {
            points.add(new Vector3D(theLine.parametricEquation(theRoots[1])));
        }
        if (theRoots[0] > 1.0 && Math.abs(theRoots[2]) <= currentIntervalBound) {
            points.add(new Vector3D(theLine.parametricEquation(theRoots[2])));
        }
        if (theRoots[0] > 2.0 && Math.abs(theRoots[3]) <= currentIntervalBound) {
            points.add(new Vector3D(theLine.parametricEquation(theRoots[3])));
        }
    }

    private void IntersectLineWithImplicitQuarticSurface(Line3D theLine, double[] theRoots, ArrayList<Vector3D> points) {
        double searchRadiusSquared = Math.pow(this.searchRadius.getValue(), 2.0);
        double interceptNormSquared = Math.pow(theLine.intercept.norm(), 2.0);
        double currentIntervalBound = Math.sqrt(searchRadiusSquared - interceptNormSquared);
        this.quarticSolve(theLine, theRoots);
        if (theRoots[0] > 0.0 && Math.abs(theRoots[1]) <= currentIntervalBound) {
            points.add(new Vector3D(theLine.parametricEquation(theRoots[1])));
        }
        if (theRoots[0] > 1.0 && Math.abs(theRoots[2]) <= currentIntervalBound) {
            points.add(new Vector3D(theLine.parametricEquation(theRoots[2])));
        }
        if (theRoots[0] > 2.0 && Math.abs(theRoots[3]) <= currentIntervalBound) {
            points.add(new Vector3D(theLine.parametricEquation(theRoots[3])));
        }
        if (theRoots[0] > 3.0 && Math.abs(theRoots[4]) <= currentIntervalBound) {
            points.add(new Vector3D(theLine.parametricEquation(theRoots[4])));
        }
    }

    private void IntersectLineWithImplicitSurface(Line3D theLine, ArrayList<Vector3D> points) {
        int numSubIntervals;
        double interceptNormSquared;
        double searchRadiusSquared = Math.pow(this.searchRadius.getValue(), 2.0);
        double currentIntervalBound = Math.sqrt(Math.max(0.001, searchRadiusSquared - (interceptNormSquared = Math.pow(theLine.intercept.norm(), 2.0))));
        double searchIntervalLength = 2.0 * currentIntervalBound;
        double subintervalLength = searchIntervalLength / (double)(numSubIntervals = (int)Math.round(40.0 * currentIntervalBound));
        if (subintervalLength > this.resolution) {
            numSubIntervals = (int)Math.round(searchIntervalLength / this.resolution) + 1;
            subintervalLength = searchIntervalLength / (double)numSubIntervals;
        }
        Vector3D startVector = theLine.parametricEquation(-currentIntervalBound - subintervalLength);
        Vector3D dVec = theLine.parametricEquation(-currentIntervalBound).minus(startVector);
        double theLevel = this.level.getValue();
        double dx = dVec.x;
        double dy = dVec.y;
        double dz = dVec.z;
        double x1 = startVector.x;
        double y1 = startVector.y;
        double z1 = startVector.z;
        double leftValue = this.heightFunction(x1, y1, z1) - theLevel;
        double t1 = -currentIntervalBound - subintervalLength;
        double dt = subintervalLength;
        for (int i = 0; i <= numSubIntervals; ++i) {
            double t2 = t1 + dt;
            double x2 = x1 + dx;
            double y2 = y1 + dy;
            double z2 = z1 + dz;
            double rightValue = this.heightFunction(x2, y2, z2) - theLevel;
            if (Math.signum(leftValue) != Math.signum(rightValue)) {
                double u = (t1 * rightValue - t2 * leftValue) / (rightValue - leftValue);
                points.add(theLine.parametricEquation(u));
            }
            leftValue = rightValue;
            x1 = x2;
            y1 = y2;
            z1 = z2;
            t1 = t2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPointCloud() {
        this.pointCloud = new Vector3D[this.pointCloudCount.getValue()];
        TaskManager.Job job = this.taskManager.createJob();
        int startIndex = 1;
        ArrayList<FindPointsOnPointCloud> tasks = new ArrayList<FindPointsOnPointCloud>();
        CollectPointsForPointCloud taskOwner = new CollectPointsForPointCloud(tasks, job);
        while (startIndex < this.ListOfRandomLines.length) {
            int endIndex = startIndex + 499;
            if (endIndex > this.ListOfRandomLines.length) {
                endIndex = this.ListOfRandomLines.length;
            }
            FindPointsOnPointCloud task = new FindPointsOnPointCloud(taskOwner, startIndex, endIndex);
            tasks.add(task);
            startIndex = endIndex + 1;
        }
        CollectPointsForPointCloud collectPointsForPointCloud = taskOwner;
        synchronized (collectPointsForPointCloud) {
            for (Runnable runnable : tasks) {
                job.add(runnable);
            }
        }
        job.close();
        job.await(0);
    }

    @Override
    protected void computeDrawData3D(View3D view, boolean exhibitNeedsRedraw, Transform3D previousTransform3D, Transform3D newTransform3D) {
        if (!(!exhibitNeedsRedraw && this.pointCloud != null && this.ListOfRandomLines != null || view instanceof ImplicitSurfaceView && ((ImplicitSurfaceView)view).getUseRaytraceRendering())) {
            view.getDisplay().setCursor(Cursor.getPredefinedCursor(3));
            this.MakeListOfRandomLines();
            this.createPointCloud();
            view.getDisplay().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    protected void doDraw3D(VectorGraphics g, View3D view, Transform3D transform) {
        if (!(view instanceof ImplicitSurfaceView) || !((ImplicitSurfaceView)view).getUseRaytraceRendering()) {
            view.drawPixels(this.pointCloud);
        } else {
            ((ImplicitSurfaceView)view).killRayTraceJob();
            ((ImplicitSurfaceView)view).drawRayTracedSurface();
        }
    }

    @Override
    public View getDefaultView() {
        return new ImplicitSurfaceView();
    }

    @Override
    public BasicAnimator getMorphingAnimation(final View view, int looping) {
        if (!(view instanceof ImplicitSurfaceView)) {
            return super.getMorphingAnimation(view, looping);
        }
        Parameter[] parameters = view.getViewAndExhibitParameters();
        if (parameters == null) {
            return null;
        }
        boolean animated = false;
        for (int i = 0; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof Animateable) || !((Animateable)((Object)parameters[i])).reallyAnimated()) continue;
            animated = true;
            break;
        }
        if (!animated) {
            return null;
        }
        BasicAnimator anim = new BasicAnimator(this.getFramesForMorphing()){

            @Override
            public void animationStarting() {
                ((ImplicitSurfaceView)view).killRayTraceJob();
                SurfaceImplicit.this.morphingView = view;
                SurfaceImplicit.this.isMorphing = true;
            }

            @Override
            public void animationEnding() {
                SurfaceImplicit.this.morphingView = null;
                SurfaceImplicit.this.isMorphing = false;
            }

            @Override
            protected void nextFrame(ActionEvent evt) {
                if (((ImplicitSurfaceView)view).isBuildingImage()) {
                    return;
                }
                super.nextFrame(evt);
            }
        };
        if (this.getUseFilmstripForMorphing()) {
            anim.setUseFilmstrip(true);
            anim.setMillisecondsPerFrame(100);
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof Animateable)) continue;
            anim.addAnimatedItem((Animateable)((Object)parameters[i]));
        }
        anim.setLooping(looping);
        return anim;
    }

    public class ImplicitSurfaceView
    extends View3DWithLightSettings {
        @VMMSave
        boolean useRaytraceRendering = false;
        protected ActionRadioGroup renderSelect;
        private int rayTraceJobNum;
        private TaskManager.Job currentRayTraceJob;
        private RayTraceThread rayTraceThread;
        private Graphics leftAnaglyphGraphics;
        private Graphics rightAnaglyphGraphics;

        public ImplicitSurfaceView() {
            this.setViewStyle(1);
            this.renderSelect = new ActionRadioGroup(){

                @Override
                public void optionSelected(int selectedIndex) {
                    ImplicitSurfaceView.this.setUseRaytraceRendering(selectedIndex == 1);
                }
            };
            this.renderSelect.addItem(I18n.tr("vmm3d.surface.implicit.PointCloud"));
            this.renderSelect.addItem(I18n.tr("vmm3d.surface.implicit.RayTrace"));
            this.renderSelect.setSelectedIndex(0);
            LightSettings ls = new LightSettings();
            ls.setSpecularExponent(80);
            ls.setSpecularRatio(0.25f);
            this.setAnaglyphLightSettings(ls);
            this.setNonAnaglyphLightSettings(new LightSettings(3));
        }

        public boolean getUseRaytraceRendering() {
            return this.useRaytraceRendering;
        }

        public void setUseRaytraceRendering(boolean useRaytraceRendering) {
            if (this.useRaytraceRendering == useRaytraceRendering) {
                return;
            }
            if (this.getDisplay() != null) {
                this.getDisplay().stopAnimation();
            }
            this.killRayTraceJob();
            this.useRaytraceRendering = useRaytraceRendering;
            this.renderSelect.setSelectedIndex(useRaytraceRendering ? 1 : 0);
            String originalAnaglyph = Prefs.get("view3d.initialAnaglyphMode", "default");
            if (useRaytraceRendering) {
                if (this.getViewStyle() == 1 && !originalAnaglyph.equalsIgnoreCase("always")) {
                    this.setViewStyle(0);
                }
                this.setOrthographicProjection(false);
                this.projectionCommands.setEnabled(false);
            } else {
                if (this.getViewStyle() == 0 && !originalAnaglyph.equalsIgnoreCase("never")) {
                    this.setViewStyle(1);
                }
                this.projectionCommands.setEnabled(true);
            }
            this.forceRedraw();
        }

        @Override
        public void setExhibit(Exhibit exhibit) {
            this.killRayTraceJob();
            super.setExhibit(exhibit);
        }

        @Override
        public ActionList getActions() {
            ActionList actions = super.getActions();
            actions.add(this.renderSelect);
            return actions;
        }

        @Override
        public ActionList getSettingsCommands() {
            ActionList actions = super.getSettingsCommands();
            actions.remove(this.lightingEnabledToggle);
            return actions;
        }

        boolean isBuildingImage() {
            return this.buildingImageForFilmstrip;
        }

        protected void drawRayTracedSurface() {
            if (this.getViewStyle() == 0) {
                this.drawRayTracedDirect(7);
            } else {
                this.setUpForLeftEye();
                this.drawRayTracedDirect(7);
                this.setUpForRightEye();
                this.drawRayTracedDirect(7);
                this.finishStereoView();
            }
            if (!this.getFastDrawing()) {
                this.startRayTraceJob();
            }
        }

        protected Vector3D GetFirstIntersectionsOfLineWithQuadraticSurface(Line3D theLine, double[] theRoots) {
            if (theLine.intercept.norm() > SurfaceImplicit.this.searchRadius.getValue()) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            Vector3D theFirstIntersection = new Vector3D();
            theFirstIntersection = null;
            double searchRadiusSquared = Math.pow(SurfaceImplicit.this.searchRadius.getValue(), 2.0);
            double interceptNormSquared = Math.pow(theLine.intercept.norm(), 2.0);
            double currentIntervalBound = Math.sqrt(Math.max(1.0E-5, searchRadiusSquared - interceptNormSquared));
            SurfaceImplicit.this.quadraticSolve(theLine, theRoots);
            if (theRoots[0] == 0.0) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            if (Math.abs(theRoots[1]) > currentIntervalBound && Math.abs(theRoots[2]) > currentIntervalBound) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            theFirstIntersection = Math.abs(theRoots[1]) < currentIntervalBound ? theLine.parametricEquation(theRoots[1]) : theLine.parametricEquation(theRoots[2]);
            return theFirstIntersection;
        }

        protected Vector3D GetFirstIntersectionsOfLineWithCubicSurface(Line3D theLine, double[] theRoots) {
            if (theLine.intercept.norm() > SurfaceImplicit.this.searchRadius.getValue()) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            Vector3D theFirstIntersection = new Vector3D();
            theFirstIntersection = null;
            double searchRadiusSquared = Math.pow(SurfaceImplicit.this.searchRadius.getValue(), 2.0);
            double interceptNormSquared = Math.pow(theLine.intercept.norm(), 2.0);
            double currentIntervalBound = Math.sqrt(Math.max(1.0E-5, searchRadiusSquared - interceptNormSquared));
            SurfaceImplicit.this.cubicSolve(theLine, theRoots);
            if (theRoots[0] == 0.0) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            if (Math.abs(theRoots[1]) > currentIntervalBound && Math.abs(theRoots[2]) > currentIntervalBound && Math.abs(theRoots[3]) > currentIntervalBound) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            theFirstIntersection = Math.abs(theRoots[1]) < currentIntervalBound ? theLine.parametricEquation(theRoots[1]) : (Math.abs(theRoots[2]) < currentIntervalBound ? theLine.parametricEquation(theRoots[2]) : theLine.parametricEquation(theRoots[3]));
            return theFirstIntersection;
        }

        protected Vector3D GetFirstIntersectionsOfLineWithQuarticSurface(Line3D theLine, double[] theRoots) {
            if (theLine.intercept.norm() > SurfaceImplicit.this.searchRadius.getValue()) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            Vector3D theFirstIntersection = new Vector3D();
            theFirstIntersection = null;
            double searchRadiusSquared = Math.pow(SurfaceImplicit.this.searchRadius.getValue(), 2.0);
            double interceptNormSquared = Math.pow(theLine.intercept.norm(), 2.0);
            double currentIntervalBound = Math.sqrt(Math.max(1.0E-5, searchRadiusSquared - interceptNormSquared));
            SurfaceImplicit.this.quarticSolve(theLine, theRoots);
            if (theRoots[0] == 0.0) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            theFirstIntersection = Math.abs(theRoots[1]) < currentIntervalBound ? theLine.parametricEquation(theRoots[1]) : (Math.abs(theRoots[2]) < currentIntervalBound ? theLine.parametricEquation(theRoots[2]) : (Math.abs(theRoots[3]) < currentIntervalBound ? theLine.parametricEquation(theRoots[3]) : (Math.abs(theRoots[4]) < currentIntervalBound ? theLine.parametricEquation(theRoots[4]) : new Vector3D(-12345.0, 0.0, 0.0))));
            return theFirstIntersection;
        }

        protected Vector3D GetFirstIntersectionsOfLineWithSurface(Line3D theLine) {
            if (theLine.intercept.norm() > SurfaceImplicit.this.searchRadius.getValue()) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            double searchRadiusSquared = Math.pow(SurfaceImplicit.this.searchRadius.getValue(), 2.0);
            double interceptNormSquared = Math.pow(theLine.intercept.norm(), 2.0);
            double currentIntervalBound = Math.sqrt(Math.max(0.001, searchRadiusSquared - interceptNormSquared));
            double searchIntervalLength = 2.0 * currentIntervalBound;
            int numSubIntervals = (int)Math.round(40.0 * currentIntervalBound);
            double subintervalLength = searchIntervalLength / (double)numSubIntervals;
            SurfaceImplicit.this.resolution = SurfaceImplicit.this.rayTraceResolution.getValue();
            if (subintervalLength > SurfaceImplicit.this.resolution) {
                numSubIntervals = (int)Math.round(searchIntervalLength / SurfaceImplicit.this.resolution) + 1;
                subintervalLength = searchIntervalLength / (double)numSubIntervals;
            }
            Vector3D startVector = theLine.parametricEquation(-currentIntervalBound - subintervalLength);
            Vector3D dVec = theLine.parametricEquation(-currentIntervalBound).minus(startVector);
            double theLevel = SurfaceImplicit.this.level.getValue();
            double dx = dVec.x;
            double dy = dVec.y;
            double dz = dVec.z;
            double x1 = startVector.x;
            double y1 = startVector.y;
            double z1 = startVector.z;
            double leftValue = SurfaceImplicit.this.heightFunction(x1, y1, z1) - theLevel;
            double t1 = -currentIntervalBound - subintervalLength;
            double dt = subintervalLength;
            for (int i = 0; i <= numSubIntervals; ++i) {
                double t2 = t1 + dt;
                double x2 = x1 + dx;
                double y2 = y1 + dy;
                double z2 = z1 + dz;
                double rightValue = SurfaceImplicit.this.heightFunction(x2, y2, z2) - theLevel;
                if (Math.signum(leftValue) != Math.signum(rightValue)) {
                    double u = (t1 * rightValue - t2 * leftValue) / (rightValue - leftValue);
                    return theLine.parametricEquation(u);
                }
                leftValue = rightValue;
                x1 = x2;
                y1 = y2;
                z1 = z2;
                t1 = t2;
            }
            return new Vector3D(-12345.0, 0.0, 0.0);
        }

        private void drawRayTracedDirect(int theResolution) {
            int width = this.transform3D.getWidth();
            int height = this.transform3D.getHeight();
            double centerOffset = (double)theResolution * 0.5;
            Point2D.Double pt = new Point2D.Double();
            Vector3D viewPt = this.getViewPoint();
            Vector3D xDir = this.transform3D.getImagePlaneXDirection();
            Vector3D yDir = this.transform3D.getImagePlaneYDirection();
            Color bgColor = this.getBackground();
            if (this.getViewStyle() == 1) {
                bgColor = Color.BLACK;
            }
            double[] theRoots = new double[5];
            for (int y = 0; y < height; y += theResolution) {
                for (int x = 0; x < width; x += theResolution) {
                    theRoots[0] = 0.0;
                    theRoots[1] = 10000.0;
                    theRoots[2] = 10000.0;
                    theRoots[3] = 10000.0;
                    theRoots[4] = 10000.0;
                    ((Point2D)pt).setLocation((double)x + centerOffset, (double)y + centerOffset);
                    this.transform3D.viewportToWindow(pt);
                    Vector3D Xcomponent = xDir.times(((Point2D)pt).getX());
                    Vector3D Ycomponent = yDir.times(((Point2D)pt).getY());
                    Vector3D worldPoint = Xcomponent.plus(Ycomponent);
                    Vector3D directionToPixel = worldPoint.minus(viewPt).normalized();
                    double ProjOfViewPtOnDirection = viewPt.dot(directionToPixel);
                    Vector3D intercpt = viewPt.minus(directionToPixel.times(ProjOfViewPtOnDirection));
                    Line3D lineFromViewptToPixel = new Line3D(intercpt, directionToPixel);
                    Vector3D FirstIntersection = SurfaceImplicit.this.heightFunctionType == equationType.QUADRATIC ? this.GetFirstIntersectionsOfLineWithQuadraticSurface(lineFromViewptToPixel, theRoots) : (SurfaceImplicit.this.heightFunctionType == equationType.CUBIC ? this.GetFirstIntersectionsOfLineWithCubicSurface(lineFromViewptToPixel, theRoots) : (SurfaceImplicit.this.heightFunctionType == equationType.QUARTIC ? this.GetFirstIntersectionsOfLineWithQuarticSurface(lineFromViewptToPixel, theRoots) : this.GetFirstIntersectionsOfLineWithSurface(lineFromViewptToPixel)));
                    Color c = bgColor;
                    if (FirstIntersection.x != -12345.0) {
                        Vector3D theNormal = SurfaceImplicit.this.normalToSurfaceAt(FirstIntersection);
                        c = PhongLighting.phongLightingColor(theNormal, this, this.transform3D, FirstIntersection, Color.WHITE);
                    }
                    if (theResolution == 1) {
                        this.drawPixelDirect(c, x, y);
                        continue;
                    }
                    this.setColor(c);
                    this.fillRectDirect(x, y, theResolution, theResolution);
                }
            }
        }

        private synchronized void killRayTraceJob() {
            if (this.currentRayTraceJob == null) {
                return;
            }
            this.buildingImageForFilmstrip = false;
            if (!this.currentRayTraceJob.isFinished()) {
                this.currentRayTraceJob.cancel();
            }
            this.rayTraceThread = null;
            this.currentRayTraceJob = null;
            ++this.rayTraceJobNum;
            if (this.leftAnaglyphGraphics != null) {
                this.leftAnaglyphGraphics.dispose();
                this.rightAnaglyphGraphics.dispose();
                this.rightAnaglyphGraphics = null;
                this.leftAnaglyphGraphics = null;
            }
        }

        private synchronized void startRayTraceJob() {
            BufferedImage image2;
            BufferedImage image1;
            Transform3D transform2;
            Transform3D transform1;
            assert (this.currentRayTraceJob == null);
            System.out.println("DEBUG=1) startRayTraceJob()");
            if (this.getViewStyle() == 0) {
                transform1 = (Transform3D)this.getTransform3D().clone();
                transform2 = null;
                image1 = this.fullOSI;
                image2 = null;
            } else {
                this.setUpForLeftEye();
                transform1 = (Transform3D)this.getTransform3D().clone();
                this.setUpForRightEye();
                transform2 = (Transform3D)this.getTransform3D().clone();
                this.finishStereoView();
                if (this.getViewStyle() == 1) {
                    image1 = this.stereoComposite.getLeftEyeImage();
                    image2 = this.stereoComposite.getRightEyeImage();
                    this.leftAnaglyphGraphics = image1.getGraphics();
                    this.rightAnaglyphGraphics = image2.getGraphics();
                } else {
                    image1 = this.leftStereographOSI;
                    image2 = this.rightStereographOSI;
                }
            }
            if (SurfaceImplicit.this.taskManager == null) {
                SurfaceImplicit.this.taskManager = new TaskManager();
            }
            this.currentRayTraceJob = SurfaceImplicit.this.taskManager.createJob();
            int rows = transform1.getHeight();
            for (int y = 0; y < rows; ++y) {
                this.currentRayTraceJob.add(new RayTraceTask(this.rayTraceJobNum, transform1, transform2, image1, image2, y));
            }
            this.currentRayTraceJob.close();
            this.buildingImageForFilmstrip = true;
            this.rayTraceThread = new RayTraceThread(this.currentRayTraceJob, this.rayTraceJobNum);
            this.rayTraceThread.start();
        }

        private synchronized void finishRayTraceTask(RayTraceTask task) {
            if (task.jobID != this.rayTraceJobNum) {
                return;
            }
            if (this.leftAnaglyphGraphics != null) {
                int i;
                for (i = 0; i < task.width; ++i) {
                    this.leftAnaglyphGraphics.setColor(new Color(task.rgb1[i]));
                    this.leftAnaglyphGraphics.fillRect(i, task.y, 1, 1);
                }
                for (i = 0; i < task.width; ++i) {
                    this.rightAnaglyphGraphics.setColor(new Color(task.rgb2[i]));
                    this.rightAnaglyphGraphics.fillRect(i, task.y, 1, 1);
                }
            } else {
                task.image1.setRGB(0, task.y, task.width, 1, task.rgb1, 0, task.width);
                if (task.image2 != null) {
                    task.image2.setRGB(0, task.y, task.width, 1, task.rgb2, 0, task.width);
                }
            }
        }

        private class RayTraceTask
        implements Runnable {
            Transform3D transform1;
            Transform3D transform2;
            BufferedImage image1;
            BufferedImage image2;
            int y;
            int width;
            int jobID;
            int[] rgb1;
            int[] rgb2;

            RayTraceTask(int jobID, Transform3D transform1, Transform3D transform2, BufferedImage image1, BufferedImage image2, int y) {
                this.transform1 = transform1;
                this.transform2 = transform2;
                this.image1 = image1;
                this.image2 = image2;
                this.y = y;
                this.jobID = jobID;
            }

            void compute(int[] rgb, ImplicitSurfaceView view, Transform3D transform) {
                Point2D.Double pt = new Point2D.Double();
                Vector3D viewPt = transform.getViewPoint();
                Vector3D xDir = transform.getImagePlaneXDirection();
                Vector3D yDir = transform.getImagePlaneYDirection();
                Color bgColor = ImplicitSurfaceView.this.getBackground();
                if (ImplicitSurfaceView.this.getViewStyle() == 1) {
                    bgColor = Color.BLACK;
                }
                int bgColorRGB = bgColor.getRGB();
                double[] theRoots = new double[5];
                for (int x = 0; x < this.width; ++x) {
                    theRoots[0] = 0.0;
                    theRoots[1] = 10000.0;
                    theRoots[2] = 10000.0;
                    theRoots[3] = 10000.0;
                    theRoots[4] = 10000.0;
                    ((Point2D)pt).setLocation((double)x + 0.5, (double)this.y + 0.5);
                    transform.viewportToWindow(pt);
                    Vector3D Xcomponent = xDir.times(((Point2D)pt).getX());
                    Vector3D Ycomponent = yDir.times(((Point2D)pt).getY());
                    Vector3D worldPoint = Xcomponent.plus(Ycomponent);
                    Vector3D directionToPixel = worldPoint.minus(viewPt).normalized();
                    double ProjOfViewPtOnDirection = viewPt.dot(directionToPixel);
                    Vector3D intercpt = viewPt.minus(directionToPixel.times(ProjOfViewPtOnDirection));
                    Line3D lineFromViewptToPixel = new Line3D(intercpt, directionToPixel);
                    Vector3D FirstIntersection = SurfaceImplicit.this.heightFunctionType == equationType.QUADRATIC ? ImplicitSurfaceView.this.GetFirstIntersectionsOfLineWithQuadraticSurface(lineFromViewptToPixel, theRoots) : (SurfaceImplicit.this.heightFunctionType == equationType.CUBIC ? ImplicitSurfaceView.this.GetFirstIntersectionsOfLineWithCubicSurface(lineFromViewptToPixel, theRoots) : (SurfaceImplicit.this.heightFunctionType == equationType.QUARTIC ? ImplicitSurfaceView.this.GetFirstIntersectionsOfLineWithQuarticSurface(lineFromViewptToPixel, theRoots) : ImplicitSurfaceView.this.GetFirstIntersectionsOfLineWithSurface(lineFromViewptToPixel)));
                    int cRGB = bgColorRGB;
                    if (FirstIntersection.x != -12345.0) {
                        Vector3D theNormal = SurfaceImplicit.this.normalToSurfaceAt(FirstIntersection);
                        Color c = PhongLighting.phongLightingColor(theNormal, view, ImplicitSurfaceView.this.getTransform3D(), FirstIntersection, Color.WHITE);
                        cRGB = c.getRGB();
                    }
                    rgb[x] = cRGB;
                }
            }

            @Override
            public void run() {
                this.width = this.transform1.getWidth();
                this.rgb1 = new int[this.width];
                this.compute(this.rgb1, ImplicitSurfaceView.this, this.transform1);
                if (this.transform2 != null) {
                    this.rgb2 = new int[this.width];
                    this.compute(this.rgb2, ImplicitSurfaceView.this, this.transform2);
                }
                ImplicitSurfaceView.this.finishRayTraceTask(this);
            }
        }

        private class RayTraceThread
        extends Thread {
            TaskManager.Job job;
            int jobID;

            RayTraceThread(TaskManager.Job job, int jobID) {
                this.job = job;
                this.jobID = jobID;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                System.out.println("DEBUG=2) startRayTraceJob()");
                try {
                    boolean done;
                    do {
                        done = this.job.await(500);
                        ImplicitSurfaceView implicitSurfaceView = ImplicitSurfaceView.this;
                        synchronized (implicitSurfaceView) {
                            Display d;
                            if (this.jobID != ImplicitSurfaceView.this.rayTraceJobNum) {
                                break;
                            }
                            if (done) {
                                ImplicitSurfaceView.this.buildingImageForFilmstrip = false;
                            }
                            if ((d = ImplicitSurfaceView.this.getDisplay()) != null) {
                                VectorGraphics g;
                                Decoration[] decs2;
                                Decoration[] decs1 = ImplicitSurfaceView.this.getDecorations();
                                Exhibit exhibit = ImplicitSurfaceView.this.getExhibit();
                                Decoration[] decorationArray = decs2 = exhibit == null ? new Decoration[]{} : exhibit.getDecorations();
                                if ((decs1.length > 0 || decs2.length > 0) && (g = ImplicitSurfaceView.this.prepareOSIForDrawing()) != null) {
                                    for (Decoration dec : decs1) {
                                        dec.doDraw(g, ImplicitSurfaceView.this, ImplicitSurfaceView.this.getTransform());
                                    }
                                    if (decs2 != null) {
                                        for (Decoration dec : decs2) {
                                            dec.doDraw(g, ImplicitSurfaceView.this, ImplicitSurfaceView.this.getTransform());
                                        }
                                    }
                                    ImplicitSurfaceView.this.finishOSIDraw();
                                }
                                if (ImplicitSurfaceView.this.getViewStyle() == 1) {
                                    try {
                                        ImplicitSurfaceView.this.stereoComposite.compose();
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        // empty catch block
                                    }
                                }
                                d.repaint();
                            }
                        }
                    } while (!done);
                }
                finally {
                    ImplicitSurfaceView implicitSurfaceView = ImplicitSurfaceView.this;
                    synchronized (implicitSurfaceView) {
                        if (this.jobID == ImplicitSurfaceView.this.rayTraceJobNum) {
                            ImplicitSurfaceView.this.killRayTraceJob();
                        }
                    }
                }
            }
        }
    }

    private class CollectPointsForPointCloud {
        TaskManager.Job findPointsJob;
        ArrayList<FindPointsOnPointCloud> tasks;
        int tasksCompleted;

        CollectPointsForPointCloud(ArrayList<FindPointsOnPointCloud> tasks, TaskManager.Job job) {
            this.tasks = tasks;
            this.findPointsJob = job;
            SurfaceImplicit.this.numberOfPointsInCloud = 0;
        }

        synchronized void taskCompleted() {
            if (this.findPointsJob.isFinished()) {
                return;
            }
            while (this.tasks.get(this.tasksCompleted).isFinished()) {
                ArrayList<Vector3D> points = this.tasks.get((int)this.tasksCompleted).points;
                Iterator<Vector3D> iterator = points.iterator();
                while (iterator.hasNext()) {
                    Vector3D point;
                    SurfaceImplicit.this.pointCloud[((SurfaceImplicit)SurfaceImplicit.this).numberOfPointsInCloud++] = point = iterator.next();
                    if (SurfaceImplicit.this.numberOfPointsInCloud != SurfaceImplicit.this.pointCloud.length) continue;
                    this.findPointsJob.cancel();
                    break;
                }
                ++this.tasksCompleted;
                if (this.tasksCompleted < this.tasks.size()) continue;
                break;
            }
        }
    }

    private class FindPointsOnPointCloud
    implements Runnable {
        int startIndex;
        int endIndex;
        ArrayList<Vector3D> points = new ArrayList();
        boolean finished;
        CollectPointsForPointCloud owner;

        FindPointsOnPointCloud(CollectPointsForPointCloud owner, int startIndex, int endIndex) {
            this.owner = owner;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isFinished() {
            CollectPointsForPointCloud collectPointsForPointCloud = this.owner;
            synchronized (collectPointsForPointCloud) {
                return this.finished;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            double[] theRoots = new double[5];
            for (int i = this.startIndex; i <= this.endIndex; ++i) {
                theRoots[0] = 0.0;
                theRoots[1] = 10000.0;
                theRoots[2] = 10000.0;
                theRoots[3] = 10000.0;
                theRoots[4] = 10000.0;
                if (SurfaceImplicit.this.heightFunctionType == equationType.QUADRATIC) {
                    SurfaceImplicit.this.IntersectLineWithImplicitQuadraticSurface(SurfaceImplicit.this.ListOfRandomLines[i], theRoots, this.points);
                    continue;
                }
                if (SurfaceImplicit.this.heightFunctionType == equationType.CUBIC) {
                    SurfaceImplicit.this.IntersectLineWithImplicitCubicSurface(SurfaceImplicit.this.ListOfRandomLines[i], theRoots, this.points);
                    continue;
                }
                if (SurfaceImplicit.this.heightFunctionType == equationType.QUARTIC) {
                    SurfaceImplicit.this.IntersectLineWithImplicitQuarticSurface(SurfaceImplicit.this.ListOfRandomLines[i], theRoots, this.points);
                    continue;
                }
                SurfaceImplicit.this.IntersectLineWithImplicitSurface(SurfaceImplicit.this.ListOfRandomLines[i], this.points);
            }
            CollectPointsForPointCloud collectPointsForPointCloud = this.owner;
            synchronized (collectPointsForPointCloud) {
                this.finished = true;
                this.owner.taskCompleted();
            }
        }
    }

    private class MakeRandomLines
    implements Runnable {
        int start;
        int end;

        MakeRandomLines(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public void run() {
            Vector3D Z_Axis = Vector3D.UNIT_Z;
            Vector3D unrotatedIntercept = new Vector3D();
            Random random = new Random(this.start);
            for (int i = this.start; i <= this.end; ++i) {
                double longitude = Math.PI * 2 * random.nextDouble();
                double colatitude = Math.acos(random.nextDouble());
                Vector3D theDirection = new Vector3D();
                theDirection.x = Math.sin(colatitude) * Math.cos(longitude);
                theDirection.y = Math.sin(colatitude) * Math.sin(longitude);
                theDirection.z = Math.cos(colatitude);
                double theAngle = Math.PI * 2 * random.nextDouble();
                double theRadius = Math.sqrt(random.nextDouble());
                unrotatedIntercept.x = theRadius * Math.cos(theAngle);
                unrotatedIntercept.y = theRadius * Math.sin(theAngle);
                unrotatedIntercept.z = 0.0;
                unrotatedIntercept = unrotatedIntercept.times(SurfaceImplicit.this.searchRadius.getValue());
                Vector3D theIntercept = Maps.Transvection(Z_Axis, theDirection, unrotatedIntercept);
                SurfaceImplicit.this.ListOfRandomLines[i] = new Line3D(theIntercept, theDirection);
            }
        }
    }

    public class Line3D {
        Vector3D intercept;
        Vector3D direction;

        public Vector3D parametricEquation(double t) {
            Vector3D point = new Vector3D();
            point.assignLinComb(1.0, this.intercept, t, this.direction);
            return point;
        }

        public Line3D(Vector3D intrcpt, Vector3D drctn) {
            this.intercept = intrcpt;
            this.direction = drctn;
        }
    }

    static enum equationType {
        OTHER,
        LINEAR,
        QUADRATIC,
        CUBIC,
        QUARTIC;

    }
}

