/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.implicit;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.actions.ActionList;
import vmm3d.actions.ToggleAction;
import vmm3d.core.Decoration;
import vmm3d.core.I18n;
import vmm3d.core.Transform;
import vmm3d.core.VMMSave;
import vmm3d.core.View;
import vmm3d.core3D.Transform3D;
import vmm3d.core3D.Vector3D;
import vmm3d.core3D.View3D;
import vmm3d.surface.implicit.SurfaceImplicit;

public class ClebschCubic
extends SurfaceImplicit {
    double[][][] TwentySevenLineArray = new double[28][4][3];

    double sqr(double x) {
        return x * x;
    }

    static double sqrt(double x) {
        return Math.sqrt(x);
    }

    static double cube(double x) {
        return x * x * x;
    }

    @Override
    public double heightFunction(double x, double y, double z) {
        double xsqr = this.sqr(x);
        double ysqr = this.sqr(y);
        double zsqr = this.sqr(z);
        double xcube = x * xsqr;
        double ycube = y * ysqr;
        double zcube = z * zsqr;
        double height = -(81.0 * (xcube + ycube + zcube) - 189.0 * (xsqr * y + xsqr * z + ysqr * x + ysqr * z + zsqr * x + zsqr * y) + 54.0 * x * y * z + 126.0 * (x * y + x * z + y * z) - 9.0 * (xsqr + ysqr + zsqr) - 9.0 * (x + y + z) + 1.0);
        return height;
    }

    public ClebschCubic() {
        this.setDefaultWindow(-3.5, 3.5, -3.5, 3.5);
        this.setDefaultViewpoint(new Vector3D(26.5, -7.25, -7.25));
        this.setDefaultViewUp(new Vector3D(0.3608, 0.6595, 0.6595));
        this.searchRadius.reset(3.0);
        this.randomLineCount.reset(60000);
        this.pointCloudCount.reset(12000);
        this.level.reset(0.0);
        this.setFramesForMorphing(11);
        this.InitializeTwentySevenLineArray();
        this.heightFunctionType = SurfaceImplicit.equationType.CUBIC;
    }

    @Override
    public View getDefaultView() {
        return new ClebschView();
    }

    private double implicitFunctionOfSearchSphereAlongRay(int linenum, double t) {
        Vector3D thePoint = new Vector3D(this.ClebschLine(linenum, t));
        return this.sqr(thePoint.norm()) - this.sqr(this.searchRadius.getValue());
    }

    private Vector3D[] findVisibleSegmentOfClebschLine(int linenum, View3D view) {
        boolean lineIntersectsSearchSphere;
        double B = 0.5 * (this.implicitFunctionOfSearchSphereAlongRay(linenum, 1.0) - this.implicitFunctionOfSearchSphereAlongRay(linenum, -1.0));
        double C = this.implicitFunctionOfSearchSphereAlongRay(linenum, 0.0);
        double A = this.implicitFunctionOfSearchSphereAlongRay(linenum, 1.0) - B - C;
        double D = B * B - 4.0 * A * C;
        boolean bl = lineIntersectsSearchSphere = D > 0.0;
        if (lineIntersectsSearchSphere) {
            double leftEnd = (-B - ClebschCubic.sqrt(D)) / (2.0 * A);
            double rightEnd = (-B + ClebschCubic.sqrt(D)) / (2.0 * A);
            Vector3D initialPoint = new Vector3D(this.ClebschLine(linenum, leftEnd));
            Vector3D finalPoint = new Vector3D(this.ClebschLine(linenum, rightEnd));
            return new Vector3D[]{initialPoint, finalPoint};
        }
        return null;
    }

    private void findUnHiddenLineSegments(Vector3D pt1, Vector3D pt2, SurfaceImplicit.ImplicitSurfaceView view, Transform3D transform, ArrayList<Vector3D[]> linesToDraw) {
        Vector3D viewPoint = transform.getViewPoint();
        double[] theRoots = new double[5];
        double pixelSize = transform.getPixelWidth();
        Point2D xyPt1 = transform.objectToXYWindowCoords(pt1);
        Point2D xyPt2 = transform.objectToXYWindowCoords(pt2);
        double distanceOnScreen = ClebschCubic.sqrt(this.sqr(xyPt1.getX() - xyPt2.getX()) + this.sqr(xyPt1.getY() - xyPt2.getY()));
        int steps = (int)(distanceOnScreen / pixelSize);
        if (steps > 100) {
            steps = 100;
        }
        if (steps == 0) {
            if (!this.isHidden(pt1, viewPoint, view, transform, theRoots)) {
                linesToDraw.add(new Vector3D[]{pt1, pt1});
            }
            return;
        }
        double pixelsPerStep = distanceOnScreen / (double)steps / pixelSize;
        Vector3D dv = pt2.minus(pt1).times(1.0 / (double)steps);
        Vector3D A = pt1;
        boolean hiddenA = this.isHidden(A, viewPoint, view, transform, theRoots);
        Vector3D unHiddenSegmentStart = hiddenA ? null : A;
        for (int i = 1; i <= steps; ++i) {
            Vector3D B = pt1.plus(dv.times(i));
            boolean hiddenB = this.isHidden(B, viewPoint, view, transform, theRoots);
            if (hiddenA != hiddenB) {
                Vector3D A1 = A;
                Vector3D B1 = B;
                boolean hiddenA1 = hiddenA;
                Vector3D divisionPt = A1.plus(B1).times(0.5);
                for (double size = pixelsPerStep; size > 1.0; size /= 2.0) {
                    boolean hiddenMiddle = this.isHidden(divisionPt, viewPoint, view, transform, theRoots);
                    if (hiddenMiddle == hiddenA1) {
                        A1 = divisionPt;
                    } else {
                        B1 = divisionPt;
                    }
                    divisionPt = A1.plus(B1).times(0.5);
                }
                if (hiddenB) {
                    linesToDraw.add(new Vector3D[]{unHiddenSegmentStart, divisionPt});
                    unHiddenSegmentStart = null;
                } else {
                    unHiddenSegmentStart = divisionPt;
                }
            }
            if (i == steps && !hiddenB) {
                linesToDraw.add(new Vector3D[]{unHiddenSegmentStart, B});
            }
            A = B;
            hiddenA = hiddenB;
        }
    }

    private boolean isHidden(Vector3D point, Vector3D viewPoint, SurfaceImplicit.ImplicitSurfaceView view, Transform3D transform, double[] theRoots) {
        Vector3D directionToPixel = point.minus(viewPoint).normalized();
        double projOfViewPtOnDirection = viewPoint.dot(directionToPixel);
        Vector3D intercpt = viewPoint.minus(directionToPixel.times(projOfViewPtOnDirection));
        SurfaceImplicit.Line3D lineFromViewptToPixel = new SurfaceImplicit.Line3D(this, intercpt, directionToPixel);
        Vector3D firstIntersection = view.GetFirstIntersectionsOfLineWithCubicSurface(lineFromViewptToPixel, theRoots);
        if (firstIntersection.x == -12345.0) {
            return false;
        }
        Vector3D directionFromIntersectionToPoint = point.minus(firstIntersection);
        if (directionFromIntersectionToPoint.norm() < 0.05) {
            return false;
        }
        return !(directionFromIntersectionToPoint.dot(directionToPixel) < 0.0);
    }

    protected Vector3D ClebschLine(int linenum, double t) {
        Vector3D thePoint = new Vector3D();
        thePoint.x = this.TwentySevenLineArray[linenum][1][1] + this.TwentySevenLineArray[linenum][1][2] * t;
        thePoint.y = this.TwentySevenLineArray[linenum][2][1] + this.TwentySevenLineArray[linenum][2][2] * t;
        thePoint.z = this.TwentySevenLineArray[linenum][3][1] + this.TwentySevenLineArray[linenum][3][2] * t;
        return thePoint;
    }

    protected void InitializeTwentySevenLineArray() {
        this.TwentySevenLineArray[1][1][1] = -0.3333333333333333;
        this.TwentySevenLineArray[1][1][2] = 0.0;
        this.TwentySevenLineArray[1][2][1] = 0.0;
        this.TwentySevenLineArray[1][2][2] = -1.0;
        this.TwentySevenLineArray[1][3][1] = 0.0;
        this.TwentySevenLineArray[1][3][2] = 1.0;
        this.TwentySevenLineArray[2][1][1] = -0.3333333333333333;
        this.TwentySevenLineArray[2][1][2] = 3.0;
        this.TwentySevenLineArray[2][2][1] = 0.0;
        this.TwentySevenLineArray[2][2][2] = 0.0;
        this.TwentySevenLineArray[2][3][1] = 0.0;
        this.TwentySevenLineArray[2][3][2] = 1.0;
        this.TwentySevenLineArray[3][1][1] = 0.0;
        this.TwentySevenLineArray[3][1][2] = -1.0;
        this.TwentySevenLineArray[3][2][1] = -0.3333333333333333;
        this.TwentySevenLineArray[3][2][2] = 0.0;
        this.TwentySevenLineArray[3][3][1] = 0.0;
        this.TwentySevenLineArray[3][3][2] = 1.0;
        this.TwentySevenLineArray[4][1][1] = 0.0;
        this.TwentySevenLineArray[4][1][2] = 0.0;
        this.TwentySevenLineArray[4][2][1] = -0.3333333333333333;
        this.TwentySevenLineArray[4][2][2] = 3.0;
        this.TwentySevenLineArray[4][3][1] = 0.0;
        this.TwentySevenLineArray[4][3][2] = 1.0;
        this.TwentySevenLineArray[5][1][1] = 0.0;
        this.TwentySevenLineArray[5][1][2] = 0.0;
        this.TwentySevenLineArray[5][2][1] = 0.1111111111111111;
        this.TwentySevenLineArray[5][2][2] = 0.3333333333333333;
        this.TwentySevenLineArray[5][3][1] = 0.0;
        this.TwentySevenLineArray[5][3][2] = 1.0;
        this.TwentySevenLineArray[6][1][1] = 0.0;
        this.TwentySevenLineArray[6][1][2] = 0.0;
        this.TwentySevenLineArray[6][2][1] = 0.3333333333333333;
        this.TwentySevenLineArray[6][2][2] = -1.0;
        this.TwentySevenLineArray[6][3][1] = 0.0;
        this.TwentySevenLineArray[6][3][2] = 1.0;
        this.TwentySevenLineArray[7][1][1] = 0.1111111111111111;
        this.TwentySevenLineArray[7][1][2] = 0.3333333333333333;
        this.TwentySevenLineArray[7][2][1] = 0.0;
        this.TwentySevenLineArray[7][2][2] = 0.0;
        this.TwentySevenLineArray[7][3][1] = 0.0;
        this.TwentySevenLineArray[7][3][2] = 1.0;
        this.TwentySevenLineArray[8][1][1] = 0.3333333333333333;
        this.TwentySevenLineArray[8][1][2] = -1.0;
        this.TwentySevenLineArray[8][2][1] = 0.0;
        this.TwentySevenLineArray[8][2][2] = 0.0;
        this.TwentySevenLineArray[8][3][1] = 0.0;
        this.TwentySevenLineArray[8][3][2] = 1.0;
        this.TwentySevenLineArray[9][1][1] = 0.3333333333333333;
        this.TwentySevenLineArray[9][1][2] = 0.0;
        this.TwentySevenLineArray[9][2][1] = 0.6666666666666666;
        this.TwentySevenLineArray[9][2][2] = -1.0;
        this.TwentySevenLineArray[9][3][1] = 0.0;
        this.TwentySevenLineArray[9][3][2] = 1.0;
        this.TwentySevenLineArray[10][1][1] = 0.6666666666666666;
        this.TwentySevenLineArray[10][1][2] = -1.0;
        this.TwentySevenLineArray[10][2][1] = 0.3333333333333333;
        this.TwentySevenLineArray[10][2][2] = 0.0;
        this.TwentySevenLineArray[10][3][1] = 0.0;
        this.TwentySevenLineArray[10][3][2] = 1.0;
        this.TwentySevenLineArray[11][1][1] = 0.16666666666666666 - ClebschCubic.sqrt(5.0) / 10.0;
        this.TwentySevenLineArray[11][1][2] = ClebschCubic.sqrt(5.0) / 5.0;
        this.TwentySevenLineArray[11][2][1] = 0.16666666666666666 - 1.0 / (6.0 * ClebschCubic.sqrt(5.0));
        this.TwentySevenLineArray[11][2][2] = 1.0 - 3.0 / ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[11][3][1] = 0.0;
        this.TwentySevenLineArray[11][3][2] = 1.0;
        this.TwentySevenLineArray[12][1][1] = (7.0 - 3.0 * ClebschCubic.sqrt(5.0)) / 6.0;
        this.TwentySevenLineArray[12][1][2] = -3.0 + ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[12][2][1] = 0.5 - ClebschCubic.sqrt(5.0) / 6.0;
        this.TwentySevenLineArray[12][2][2] = ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[12][3][1] = 0.0;
        this.TwentySevenLineArray[12][3][2] = 1.0;
        this.TwentySevenLineArray[13][1][1] = (1.0 - ClebschCubic.sqrt(5.0)) / 12.0;
        this.TwentySevenLineArray[13][1][2] = (-5.0 + 3.0 * ClebschCubic.sqrt(5.0)) / 4.0;
        this.TwentySevenLineArray[13][2][1] = (3.0 + ClebschCubic.sqrt(5.0)) / 12.0;
        this.TwentySevenLineArray[13][2][2] = (-3.0 + ClebschCubic.sqrt(5.0)) / 4.0;
        this.TwentySevenLineArray[13][3][1] = 0.0;
        this.TwentySevenLineArray[13][3][2] = 1.0;
        this.TwentySevenLineArray[14][1][1] = (3.0 - ClebschCubic.sqrt(5.0)) / 12.0;
        this.TwentySevenLineArray[14][1][2] = -(3.0 + ClebschCubic.sqrt(5.0)) / 4.0;
        this.TwentySevenLineArray[14][2][1] = (1.0 + ClebschCubic.sqrt(5.0)) / 12.0;
        this.TwentySevenLineArray[14][2][2] = -(5.0 + 3.0 * ClebschCubic.sqrt(5.0)) / 4.0;
        this.TwentySevenLineArray[14][3][1] = 0.0;
        this.TwentySevenLineArray[14][3][2] = 1.0;
        this.TwentySevenLineArray[15][1][1] = 0.5 - ClebschCubic.sqrt(5.0) / 6.0;
        this.TwentySevenLineArray[15][1][2] = ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[15][2][1] = (7.0 - 3.0 * ClebschCubic.sqrt(5.0)) / 6.0;
        this.TwentySevenLineArray[15][2][2] = -3.0 + ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[15][3][1] = 0.0;
        this.TwentySevenLineArray[15][3][2] = 1.0;
        this.TwentySevenLineArray[16][1][1] = 0.16666666666666666 - 1.0 / (6.0 * ClebschCubic.sqrt(5.0));
        this.TwentySevenLineArray[16][1][2] = 1.0 - 3.0 / ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[16][2][1] = 0.16666666666666666 - ClebschCubic.sqrt(5.0) / 10.0;
        this.TwentySevenLineArray[16][2][2] = ClebschCubic.sqrt(5.0) / 5.0;
        this.TwentySevenLineArray[16][3][1] = 0.0;
        this.TwentySevenLineArray[16][3][2] = 1.0;
        this.TwentySevenLineArray[17][1][1] = (1.0 + ClebschCubic.sqrt(5.0)) / 12.0;
        this.TwentySevenLineArray[17][1][2] = -(5.0 + 3.0 * ClebschCubic.sqrt(5.0)) / 4.0;
        this.TwentySevenLineArray[17][2][1] = (3.0 - ClebschCubic.sqrt(5.0)) / 12.0;
        this.TwentySevenLineArray[17][2][2] = -(3.0 + ClebschCubic.sqrt(5.0)) / 4.0;
        this.TwentySevenLineArray[17][3][1] = 0.0;
        this.TwentySevenLineArray[17][3][2] = 1.0;
        this.TwentySevenLineArray[18][1][1] = (3.0 + ClebschCubic.sqrt(5.0)) / 12.0;
        this.TwentySevenLineArray[18][1][2] = (-3.0 + ClebschCubic.sqrt(5.0)) / 4.0;
        this.TwentySevenLineArray[18][2][1] = (1.0 - ClebschCubic.sqrt(5.0)) / 12.0;
        this.TwentySevenLineArray[18][2][2] = (-5.0 + 3.0 * ClebschCubic.sqrt(5.0)) / 4.0;
        this.TwentySevenLineArray[18][3][1] = 0.0;
        this.TwentySevenLineArray[18][3][2] = 1.0;
        this.TwentySevenLineArray[19][1][1] = (3.0 + ClebschCubic.sqrt(5.0)) / 6.0;
        this.TwentySevenLineArray[19][1][2] = -ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[19][2][1] = (7.0 + 3.0 * ClebschCubic.sqrt(5.0)) / 6.0;
        this.TwentySevenLineArray[19][2][2] = -(3.0 + ClebschCubic.sqrt(5.0));
        this.TwentySevenLineArray[19][3][1] = 0.0;
        this.TwentySevenLineArray[19][3][2] = 1.0;
        this.TwentySevenLineArray[20][1][1] = (5.0 + ClebschCubic.sqrt(5.0)) / 30.0;
        this.TwentySevenLineArray[20][1][2] = 1.0 + 3.0 / ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[20][2][1] = 5.0 + 3.0 * ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[20][2][2] = -ClebschCubic.sqrt(5.0) / 5.0;
        this.TwentySevenLineArray[20][3][1] = 0.0;
        this.TwentySevenLineArray[20][3][2] = 1.0;
        this.TwentySevenLineArray[21][1][1] = 0.16666666666666666 + ClebschCubic.sqrt(5.0) / 10.0;
        this.TwentySevenLineArray[21][1][2] = -ClebschCubic.sqrt(5.0) / 5.0;
        this.TwentySevenLineArray[21][2][1] = (5.0 + ClebschCubic.sqrt(5.0)) / 30.0;
        this.TwentySevenLineArray[21][2][2] = 1.0 + 3.0 / ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[21][3][1] = 0.0;
        this.TwentySevenLineArray[21][3][2] = 1.0;
        this.TwentySevenLineArray[22][1][1] = (7.0 + 3.0 * ClebschCubic.sqrt(5.0)) / 6.0;
        this.TwentySevenLineArray[22][1][2] = -(3.0 + ClebschCubic.sqrt(5.0));
        this.TwentySevenLineArray[22][2][1] = (3.0 + ClebschCubic.sqrt(5.0)) / 6.0;
        this.TwentySevenLineArray[22][2][2] = -ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[22][3][1] = 0.0;
        this.TwentySevenLineArray[22][3][2] = 1.0;
        this.TwentySevenLineArray[23][1][1] = -0.3333333333333333;
        this.TwentySevenLineArray[23][1][2] = 3.0;
        this.TwentySevenLineArray[23][2][1] = 0.0;
        this.TwentySevenLineArray[23][2][2] = 1.0;
        this.TwentySevenLineArray[23][3][1] = 0.0;
        this.TwentySevenLineArray[23][3][2] = 0.0;
        this.TwentySevenLineArray[24][1][1] = 0.0;
        this.TwentySevenLineArray[24][1][2] = -1.0;
        this.TwentySevenLineArray[24][2][1] = 0.0;
        this.TwentySevenLineArray[24][2][2] = 1.0;
        this.TwentySevenLineArray[24][3][1] = -0.3333333333333333;
        this.TwentySevenLineArray[24][3][2] = 0.0;
        this.TwentySevenLineArray[25][1][1] = 0.1111111111111111;
        this.TwentySevenLineArray[25][1][2] = 0.3333333333333333;
        this.TwentySevenLineArray[25][2][1] = 0.0;
        this.TwentySevenLineArray[25][2][2] = 1.0;
        this.TwentySevenLineArray[25][3][1] = 0.0;
        this.TwentySevenLineArray[25][3][2] = 0.0;
        this.TwentySevenLineArray[26][1][1] = 0.3333333333333333;
        this.TwentySevenLineArray[26][1][2] = -1.0;
        this.TwentySevenLineArray[26][2][1] = 0.0;
        this.TwentySevenLineArray[26][2][2] = 1.0;
        this.TwentySevenLineArray[26][3][1] = 0.0;
        this.TwentySevenLineArray[26][3][2] = 0.0;
        this.TwentySevenLineArray[27][1][1] = 0.6666666666666666;
        this.TwentySevenLineArray[27][1][2] = -1.0;
        this.TwentySevenLineArray[27][2][1] = 0.0;
        this.TwentySevenLineArray[27][2][2] = 1.0;
        this.TwentySevenLineArray[27][3][1] = 0.3333333333333333;
        this.TwentySevenLineArray[27][3][2] = 0.0;
    }

    public class ClebschView
    extends SurfaceImplicit.ImplicitSurfaceView {
        @VMMSave
        private boolean drawLines;
        private LinesOnCubic linesDecoration;
        ToggleAction drawLinesToggle;

        public ClebschView() {
            super(ClebschCubic.this);
            this.drawLines = true;
            this.drawLinesToggle = new ToggleAction(I18n.tr("vmm3d.surface.implicit.ClebschCubic.DrawLines"), true){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ClebschView.this.setDrawLines(this.getState());
                }
            };
            this.linesDecoration = new LinesOnCubic();
            this.addDecoration(this.linesDecoration);
        }

        public boolean getDrawLines() {
            return this.drawLines;
        }

        public void setDrawLines(boolean drawLines) {
            if (this.drawLines == drawLines) {
                return;
            }
            this.drawLines = drawLines;
            this.drawLinesToggle.setState(drawLines);
            if (drawLines) {
                this.linesDecoration = new LinesOnCubic();
                this.addDecoration(this.linesDecoration);
            } else {
                this.removeDecoration(this.linesDecoration);
                this.linesDecoration = null;
            }
        }

        @Override
        public ActionList getActions() {
            ActionList actions = super.getActions();
            actions.add(null);
            actions.add(this.drawLinesToggle);
            return actions;
        }

        Transform3D[] getStereoViewingTransforms() {
            this.setUpForLeftEye();
            Transform3D leftTransform = (Transform3D)this.getTransform3D().clone();
            this.setUpForRightEye();
            Transform3D rightTransform = (Transform3D)this.getTransform3D().clone();
            this.finishStereoView();
            return new Transform3D[]{leftTransform, rightTransform};
        }

        void drawLinesOnCubic(ArrayList<Vector3D[]> leftLines, ArrayList<Vector3D[]> rightLines) {
            Point2D.Double p1 = new Point2D.Double();
            Point2D.Double p2 = new Point2D.Double();
            this.setUpForLeftEye();
            for (Vector3D[] line : leftLines) {
                this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.transform3D.objectToDrawingCoords(line[0], p1);
                this.transform3D.objectToDrawingCoords(line[1], p2);
                this.currentGraphics.draw((Shape)new Line2D.Float(p1, p2));
            }
            this.setUpForRightEye();
            for (Vector3D[] line : rightLines) {
                this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.transform3D.objectToDrawingCoords(line[0], p1);
                this.transform3D.objectToDrawingCoords(line[1], p2);
                this.currentGraphics.draw((Shape)new Line2D.Float(p1, p2));
            }
            this.finishStereoView();
        }
    }

    private class LinesOnCubic
    extends Decoration {
        Vector3D[][] lines = new Vector3D[27][2];
        ArrayList<Vector3D[]> lineSegmentsToDraw = new ArrayList();
        ArrayList<Vector3D[]> lineSegmentsToDrawForRightStereo = new ArrayList();
        double computedForSearchRadius;
        boolean computedForRayTrace;
        boolean computedForMonocularRayTrace;

        private LinesOnCubic() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void computeDrawData(View view, boolean exhibitNeedsRedraw, Transform previousTransform, Transform newTransform) {
            View view2 = view;
            synchronized (view2) {
                boolean monocular;
                boolean rayTraced;
                boolean needCompute;
                ClebschView cv = (ClebschView)view;
                boolean bl = needCompute = this.lineSegmentsToDraw.size() == 0;
                if (this.computedForSearchRadius != ClebschCubic.this.searchRadius.getValue()) {
                    this.computedForSearchRadius = ClebschCubic.this.searchRadius.getValue();
                    needCompute = true;
                    for (int i = 0; i < 27; ++i) {
                        this.lines[i] = ClebschCubic.this.findVisibleSegmentOfClebschLine(i + 1, (View3D)view);
                    }
                }
                if (this.computedForRayTrace != (rayTraced = cv.getUseRaytraceRendering())) {
                    this.computedForRayTrace = rayTraced;
                    needCompute = true;
                }
                boolean bl2 = monocular = rayTraced && cv.getViewStyle() == 0;
                if (monocular != this.computedForMonocularRayTrace) {
                    this.computedForMonocularRayTrace = monocular;
                    needCompute = true;
                }
                if (rayTraced && !newTransform.equals(previousTransform)) {
                    needCompute = true;
                }
                if (!needCompute) {
                    return;
                }
                this.lineSegmentsToDraw.clear();
                this.lineSegmentsToDrawForRightStereo.clear();
                if (rayTraced) {
                    if (this.computedForMonocularRayTrace) {
                        for (Vector3D[] line : this.lines) {
                            if (line == null) continue;
                            ClebschCubic.this.findUnHiddenLineSegments(line[0], line[1], cv, (Transform3D)newTransform, this.lineSegmentsToDraw);
                        }
                    } else {
                        Transform3D[] stereoTransform3D = cv.getStereoViewingTransforms();
                        for (Vector3D[] line : this.lines) {
                            if (line == null) continue;
                            ClebschCubic.this.findUnHiddenLineSegments(line[0], line[1], cv, stereoTransform3D[0], this.lineSegmentsToDraw);
                            ClebschCubic.this.findUnHiddenLineSegments(line[0], line[1], cv, stereoTransform3D[1], this.lineSegmentsToDrawForRightStereo);
                        }
                    }
                } else {
                    for (Vector3D[] line : this.lines) {
                        if (line == null) continue;
                        this.lineSegmentsToDraw.add(line);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doDraw(VectorGraphics g, View view, Transform transform) {
            ClebschView cv;
            ClebschView clebschView = cv = (ClebschView)view;
            synchronized (clebschView) {
                boolean rayTraced = cv.getUseRaytraceRendering();
                if (rayTraced) {
                    cv.setColor(Color.BLACK);
                } else if (cv.getViewStyle() == 1) {
                    cv.setColor(null);
                } else {
                    cv.setColor(Color.RED);
                }
                if (rayTraced && !this.computedForMonocularRayTrace) {
                    cv.drawLinesOnCubic(this.lineSegmentsToDraw, this.lineSegmentsToDrawForRightStereo);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    for (Vector3D[] line : this.lineSegmentsToDraw) {
                        cv.drawLine(line[0], line[1]);
                    }
                }
            }
        }
    }
}

