/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.spacecurve.parametric;

import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.spacecurve.parametric.SpaceCurveParametric;

public class CinquefoilKnot
extends SpaceCurveParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 2.0, 2.0, 6.0);

    public CinquefoilKnot() {
        this.addParameter(this.aa);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("10 * pi");
        this.tResolution.setValueAndDefault(300);
        this.setDefaultViewpoint(new Vector3D(100.0, -100.0, 52.5));
        this.setDefaultWindow(-3.0, 3.0, -3.0, 3.0);
        this.tubeSize.setValueAndDefault(0.3);
    }

    @Override
    protected Vector3D value(double t) {
        double a = this.aa.getValue();
        double m = 2.0 / (2.0 * a + 1.0);
        return new Vector3D(Math.cos(t) * (2.0 - Math.cos(m * t)), Math.sin(t) * (2.0 - Math.cos(m * t)), -Math.sin(m * t));
    }
}

