/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.pseudospherical;

import vmm3d.core.Complex;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.VariableParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.pseudospherical.ComplexMatrix2D;
import vmm3d.pseudospherical.ComplexVector2D;
import vmm3d.surface.parametric.SurfaceParametric;

public class Solitons
extends SurfaceParametric {
    Complex lambda;
    double xVar;
    double tVar;
    private RealParamAnimateable s = new RealParamAnimateable("genericParam.s", 0.85, 0.2, 1.0);
    private VariableParamAnimateable solitonNum = new VariableParamAnimateable("genericParam.solitonNum", 1.0, 1.0, 4.0);
    private double epsilon = 1.0E-5;
    private ComplexVector2D initVec = new ComplexVector2D(new Complex(1.0, 0.0), new Complex(1.0, 0.0));
    public ComplexMatrix2D E0;
    public ComplexMatrix2D g1;
    public ComplexMatrix2D E1;
    public ComplexMatrix2D proj;
    public ComplexMatrix2D id;
    public ComplexMatrix2D g1Perp;

    public Solitons() {
        this.addParameter(this.s);
        this.umin.reset(-3.0);
        this.umax.reset(3.0);
        this.vmin.reset("-pi/2");
        this.vmax.reset("pi/2");
        this.setDefaultWindow(-2.25, 2.25, -1.75, 1.75);
        this.setDefaultViewpoint(new Vector3D(5.5, 4.25, 4.0));
        this.setDefaultViewUp(new Vector3D(-0.16, -0.55, 0.82));
        this.lambda = new Complex(0.0, 1.0);
        this.E0 = new ComplexMatrix2D();
        this.getE0(this.xVar, this.s.getValue(), this.lambda);
        this.proj = ComplexMatrix2D.getProj(this.initVec);
        this.id = new ComplexMatrix2D();
        this.id.setMatrixEntry(Complex.ONE_C, 1, 1);
        this.id.setMatrixEntry(Complex.ZERO_C, 1, 2);
        this.id.setMatrixEntry(Complex.ZERO_C, 2, 1);
        this.id.setMatrixEntry(Complex.ONE_C, 2, 2);
        this.g1 = new ComplexMatrix2D();
        this.getg1(this.lambda);
    }

    public ComplexMatrix2D getProj(ComplexVector2D v) {
        return ComplexMatrix2D.getProj(v);
    }

    public void getg1(Complex lbda) {
        ComplexMatrix2D projPerp = this.id.subtract(this.proj);
        Complex i = new Complex(0.0, 1.0);
        i = i.times(2.0 * this.s.getValue()).dividedBy(lbda.minus(i.times(this.s.getValue())));
        this.g1.entries[1][1] = new Complex(i.times(projPerp.entries[1][1]).plus(1.0));
        this.g1.entries[1][2] = new Complex(i.times(projPerp.entries[1][2]));
        this.g1.entries[2][1] = new Complex(i.times(projPerp.entries[2][1]));
        this.g1.entries[2][2] = new Complex(i.times(projPerp.entries[2][2]).plus(1.0));
    }

    public void getE0(double x, double t, Complex lmbda) {
        Complex i = new Complex(0.0, 1.0);
        Complex i1 = new Complex(i.times(lmbda).times(x / 2.0 + t / 2.0));
        Complex i2 = new Complex(i.times(x / 2.0 - t / 2.0).dividedBy(lmbda));
        this.E0.entries[1][1] = i2.minus(i1).exponential();
        this.E0.entries[1][2] = new Complex(0.0, 0.0);
        this.E0.entries[2][1] = new Complex(0.0, 0.0);
        this.E0.entries[2][2] = i1.minus(i2).exponential();
    }

    public ComplexMatrix2D getgPerp(ComplexMatrix2D E, double sVal, Complex lbda, ComplexVector2D v) {
        ComplexMatrix2D ret = new ComplexMatrix2D(E);
        ret = ret.conjugate().transpose();
        ret = ComplexMatrix2D.getProj(ret.vectMul(v));
        ret = this.id.subtract(ret);
        ComplexMatrix2D mat = new ComplexMatrix2D();
        Complex i = new Complex(0.0, 1.0);
        i = new Complex(i.times(2.0 * sVal).dividedBy(lbda.minus(i.times(sVal))));
        mat.entries[1][1] = i.times(new Complex(ret.entries[1][1])).plus(1.0);
        mat.entries[1][2] = i.times(new Complex(ret.entries[1][2]));
        mat.entries[2][1] = i.times(new Complex(ret.entries[2][1]));
        mat.entries[2][2] = i.times(new Complex(ret.entries[2][2])).plus(1.0);
        return mat;
    }

    @Override
    public synchronized Vector3D surfacePoint(double x, double t) {
        this.xVar = x;
        this.tVar = t;
        this.getE0(x, t, new Complex(0.0, -this.s.getValue()));
        ComplexMatrix2D temp = new ComplexMatrix2D(this.E0);
        this.lambda = new Complex(1.0 + this.epsilon, 0.0);
        ComplexMatrix2D mat = new ComplexMatrix2D(this.getgPerp(temp, this.s.getValue(), this.lambda, this.initVec));
        this.getg1(this.lambda);
        this.getE0(x, t, this.lambda);
        ComplexMatrix2D ret = new ComplexMatrix2D(this.g1.multiply(this.E0.multiply(mat.conjugate().transpose())));
        this.lambda = new Complex(1.0 - this.epsilon, 0.0);
        mat = new ComplexMatrix2D(this.getgPerp(temp, this.s.getValue(), this.lambda, this.initVec));
        this.getg1(this.lambda);
        this.getE0(x, t, this.lambda);
        ComplexMatrix2D ret1 = new ComplexMatrix2D(this.g1.multiply(this.E0.multiply(mat.conjugate().transpose())));
        ret = new ComplexMatrix2D(ret.subtract(ret1));
        ret = new ComplexMatrix2D(ret.scalarMul(new Complex(1.0 / (2.0 * this.epsilon), 0.0)));
        this.lambda = new Complex(1.0, 0.0);
        mat = new ComplexMatrix2D(this.getgPerp(temp, this.s.getValue(), this.lambda, this.initVec));
        this.getg1(this.lambda);
        this.getE0(x, t, this.lambda);
        ret = ret.multiply(mat.multiply(this.E0.inverse().multiply(this.g1.inverse())));
        double aa = ret.entries[1][1].im;
        double bb = ret.entries[1][2].re;
        double cc = ret.entries[1][2].im;
        if (Double.isNaN(aa) || Double.isNaN(aa) || Double.isNaN(aa)) {
            cc = 0.0;
            bb = 0.0;
            aa = 0.0;
        }
        return new Vector3D(aa, bb, cc);
    }
}

