/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.planecurve.parametric;

import vmm3d.core.Decorateable;
import vmm3d.core.ThreadedAnimation;
import vmm3d.planecurve.parametric.NormalBundleDecoration;
import vmm3d.planecurve.parametric.PlaneCurveParametric;

public class OsculatingCircleAnimation
extends ThreadedAnimation {
    private PlaneCurveParametric curve;
    private Decorateable owner;
    private boolean showNormals = true;
    private boolean showEvolute = false;

    public OsculatingCircleAnimation(PlaneCurveParametric curve) {
        this(curve, curve);
    }

    public OsculatingCircleAnimation(Decorateable owner, PlaneCurveParametric curve) {
        this.owner = owner != null ? owner : curve;
        this.curve = curve;
    }

    public OsculatingCircleAnimation(Decorateable owner, PlaneCurveParametric curve, boolean showNormals, boolean showEvolute) {
        this.owner = owner != null ? owner : curve;
        this.curve = curve;
        this.showNormals = showNormals;
        this.showEvolute = showEvolute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runAnimation() {
        NormalBundleDecoration dec = new NormalBundleDecoration(this.curve);
        this.owner.addDecoration(dec);
        try {
            int points = this.curve.getTResolution() + 1;
            if (this.showNormals) {
                for (int i = 1; i <= points; ++i) {
                    dec.setPointCount(i);
                    this.pause(20);
                }
            }
            for (int pass = 0; pass < 10; ++pass) {
                for (int i = 0; i <= points; ++i) {
                    dec.setOsculatingCircleIndex(i, this.showEvolute);
                    this.pause(50);
                }
                this.pause(450);
            }
        }
        finally {
            this.owner.removeDecoration(dec);
        }
    }
}

