/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.planecurve.parametric;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.Transform;
import vmm3d.core.View;
import vmm3d.planecurve.parametric.DecoratedCurve;

public class Epizykloide
extends DecoratedCurve {
    private RealParamAnimateable radius;
    private RealParamAnimateable frequ;
    private RealParamAnimateable stick;
    private int pointCount;
    private double r;
    private double fr;
    private double l;
    private double rr;
    private double rrabs;
    private double dt;
    double xa;
    double ya;
    double ftx;
    double fty;
    double fox;
    double foy;
    double tx;
    double ty;
    double nn;
    double ex;
    double ey;
    double aux;

    public Epizykloide() {
        this.tResolution.setValueAndDefault(300);
        this.radius = new RealParamAnimateable("vmm3d.planecurve.parametric.Epizykloide.radius", 3.0, 1.5, 4.0);
        this.frequ = new RealParamAnimateable("vmm3d.planecurve.parametric.Epizykloide.frequency", 4.0, 1.0, 8.0);
        this.stick = new RealParamAnimateable("vmm3d.planecurve.parametric.Epizykloide.stick", 2.0, 0.3, 2.0);
        this.addParameter(this.radius);
        this.addParameter(this.frequ);
        this.addParameter(this.stick);
        this.tmin.setValueAndDefaultFromString("0");
        this.tmax.setValueAndDefaultFromString("2*pi");
        this.tResolution.setValueAndDefaultFromString("500");
        this.setDefaultWindow(-5.0, 5.0, -5.0, 5.0);
        this.pointCount = 6600;
        this.randomSquare = this.fillRandomSquare(this.pointCount);
        this.movingSquare = this.initializeMovingSquare(this.pointCount);
    }

    private void setConstants() {
        this.r = this.radius.getValue();
        this.fr = this.frequ.getValue();
        this.l = this.stick.getValue();
        this.rr = this.r / this.fr;
        this.rrabs = Math.abs(this.rr);
        this.dt = (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
    }

    private static double sin(double t) {
        return Math.sin(t);
    }

    private static double cos(double t) {
        return Math.cos(t);
    }

    @Override
    public double xValue(double t) {
        this.setConstants();
        return this.l * this.rr * Epizykloide.cos(this.fr * t) + this.r * Epizykloide.cos(t);
    }

    @Override
    public double yValue(double t) {
        return this.l * this.rr * Epizykloide.sin(this.fr * t) + this.r * Epizykloide.sin(t);
    }

    @Override
    public View getDefaultView() {
        DecoratedCurve.MMOView view = (DecoratedCurve.MMOView)super.getDefaultView();
        view.simplifyActionMenu = false;
        view.setUseCloud(false);
        return view;
    }

    private void abbreviations(double t) {
        this.xa = this.xValue(t);
        this.ya = this.yValue(t);
        this.ftx = (this.r - this.rr) * Epizykloide.cos(t);
        this.fty = (this.r - this.rr) * Epizykloide.sin(t);
        this.tx = 2.0 * (this.ya - this.fty);
        this.ty = 2.0 * (-this.xa + this.ftx);
        this.ex = Epizykloide.cos(this.fr * t);
        this.ey = Epizykloide.sin(this.fr * t);
        this.aux = Math.abs(this.r - this.rr);
    }

    @Override
    protected void drawNeededStuff(VectorGraphics g, View view, Transform limits, double t) {
        DecoratedCurve.MMOView myView = (DecoratedCurve.MMOView)view;
        Color saveColor = g.getColor();
        this.abbreviations(t);
        this.fox = this.ftx;
        this.foy = this.fty;
        g.draw((Shape)new Ellipse2D.Double(-this.aux, -this.aux, 2.0 * this.aux, 2.0 * this.aux));
        g.setColor(Color.red);
        myView.setStrokeSizeMultiplier(3);
        g.draw((Shape)new Ellipse2D.Double(this.r * Epizykloide.cos(t) - this.rrabs, this.r * Epizykloide.sin(t) - this.rrabs, 2.0 * this.rrabs, 2.0 * this.rrabs));
        g.setColor(Color.green);
        g.draw((Shape)new Line2D.Double(this.r * Epizykloide.cos(t), this.r * Epizykloide.sin(t), this.xa, this.ya));
        g.setColor(new Color(0, 0, 0));
        g.draw((Shape)new Line2D.Double(this.r * Epizykloide.cos(t) + 0.9 * this.l * this.rr * Epizykloide.cos(this.fr * t), this.r * Epizykloide.sin(t) + 0.9 * this.l * this.rr * Epizykloide.sin(this.fr * t), this.xa, this.ya));
        myView.setStrokeSizeMultiplier(1);
        g.setColor(new Color(0, 150, 0));
        g.draw((Shape)new Line2D.Double(this.ftx, this.fty, this.xa, this.ya));
        g.draw((Shape)new Line2D.Double(this.xa - this.tx, this.ya - this.ty, this.xa + this.tx, this.ya + this.ty));
        if (myView.getUseCloud()) {
            g.setColor(Color.blue);
            this.abbreviations(t - this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, this.xa, this.ya, this.ex, this.ey, 2.0 * this.r);
            myView.drawPixels(this.movingSquare, 0, this.pointCount);
            this.abbreviations(t + this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, this.xa, this.ya, this.ex, this.ey, 2.0 * this.r);
            myView.drawPixels(this.movingSquare, 0, this.pointCount);
        }
        g.setColor(saveColor);
    }
}

