/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.ode.secondorder2D;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.core.BasicMouseTask2D;
import vmm3d.core.Display;
import vmm3d.core.I18n;
import vmm3d.core.MouseTask;
import vmm3d.core.Util;
import vmm3d.core.View;
import vmm3d.ode.ODE_2D;

public abstract class ODE2ndOrder2DNonAutonomous
extends ODE_2D {
    public ODE2ndOrder2DNonAutonomous() {
        super(false, false, "t", "x", "y", "x'", "y'");
        this.initialDataDefault = new double[]{0.0, 1.0, 0.0, 0.0, 1.0};
        this.timeSpanDefault = 30.0;
    }

    @Override
    protected void nextEulerPoint(double[] pointData, double dt) {
        double t = pointData[0];
        double x = pointData[1];
        double y = pointData[2];
        double xdot = pointData[3];
        double ydot = pointData[4];
        pointData[0] = t + dt;
        pointData[1] = x + dt * xdot;
        pointData[2] = y + dt * ydot;
        pointData[3] = xdot + dt * this.xdotdot(x, y, xdot, ydot, t);
        pointData[4] = ydot + dt * this.ydotdot(x, y, xdot, ydot, t);
    }

    @Override
    protected void nextRungeKuttaPoint(double[] pointData, double dt) {
        double t = pointData[0];
        double x = pointData[1];
        double y = pointData[2];
        double xdot = pointData[3];
        double ydot = pointData[4];
        double i1 = dt * xdot;
        double j1 = dt * ydot;
        double h1 = dt * this.xdotdot(x, y, xdot, ydot, t);
        double k1 = dt * this.ydotdot(x, y, xdot, ydot, t);
        double i2 = dt * (xdot + h1 / 2.0);
        double j2 = dt * (ydot + k1 / 2.0);
        double h2 = dt * this.xdotdot(x + i1 / 2.0, y + j1 / 2.0, xdot + h1 / 2.0, ydot + k1 / 2.0, t + dt / 2.0);
        double k2 = dt * this.ydotdot(x + i1 / 2.0, y + j1 / 2.0, xdot + h1 / 2.0, ydot + k1 / 2.0, t + dt / 2.0);
        double i3 = dt * (xdot + h2 / 2.0);
        double j3 = dt * (ydot + k2 / 2.0);
        double h3 = dt * this.xdotdot(x + i2 / 2.0, y + j2 / 2.0, xdot + h2 / 2.0, ydot + k2 / 2.0, t + dt / 2.0);
        double k3 = dt * this.ydotdot(x + i2 / 2.0, y + j2 / 2.0, xdot + h2 / 2.0, ydot + k2 / 2.0, t + dt / 2.0);
        double i4 = dt * (xdot + h3);
        double j4 = dt * (ydot + k3);
        double h4 = dt * this.xdotdot(x + i3, y + j3, xdot + h3, ydot + k3, t + dt);
        double k4 = dt * this.ydotdot(x + i3, y + j3, xdot + h3, ydot + k3, t + dt);
        double dx = i1 / 6.0 + i2 / 3.0 + i3 / 3.0 + i4 / 6.0;
        double dy = j1 / 6.0 + j2 / 3.0 + j3 / 3.0 + j4 / 6.0;
        double dxdot = h1 / 6.0 + h2 / 3.0 + h3 / 3.0 + h4 / 6.0;
        double dydot = k1 / 6.0 + k2 / 3.0 + k3 / 3.0 + k4 / 6.0;
        pointData[0] = t + dt;
        pointData[1] = x + dx;
        pointData[2] = y + dy;
        pointData[3] = xdot + dxdot;
        pointData[4] = ydot + dydot;
    }

    protected abstract double xdotdot(double var1, double var3, double var5, double var7, double var9);

    protected abstract double ydotdot(double var1, double var3, double var5, double var7, double var9);

    @Override
    protected MouseTask makeDefaultMouseTask(ODE_2D.ODEView view) {
        return new ThrowIt();
    }

    private class ThrowIt
    extends BasicMouseTask2D {
        int startX;
        int startY;
        int currentX;
        int currentY;
        boolean throwing;

        private ThrowIt() {
        }

        @Override
        public boolean doMouseDown(MouseEvent evt, Display display, View view, int width, int height) {
            if (evt.isAltDown()) {
                this.throwing = true;
                this.startX = this.currentX = evt.getX();
                this.startY = this.currentY = evt.getY();
                return true;
            }
            return super.doMouseDown(evt, display, view, width, height);
        }

        @Override
        public void doMouseDrag(MouseEvent evt, Display display, View view, int width, int height) {
            if (this.throwing) {
                this.currentX = evt.getX();
                this.currentY = evt.getY();
                view.forceRedraw();
            } else {
                super.doMouseDrag(evt, display, view, width, height);
            }
        }

        @Override
        public void doMouseUp(MouseEvent evt, Display display, View view, int width, int height) {
            if (this.throwing) {
                this.throwing = false;
                Point2D.Double pt1 = new Point2D.Double(this.startX, this.startY);
                Point2D.Double pt2 = new Point2D.Double(this.currentX, this.currentY);
                view.getTransform().viewportToWindow(pt1);
                view.getTransform().viewportToWindow(pt2);
                double time = ((ODE_2D.ODEView)view).getCurrentTimeFromControlPanel();
                double[] data = new double[]{time, ((Point2D)pt1).getX(), ((Point2D)pt1).getY(), ((Point2D)pt2).getX() - ((Point2D)pt1).getX(), ((Point2D)pt2).getY() - ((Point2D)pt1).getY()};
                ((ODE_2D.ODEView)view).startOrbitAtPoint(data);
            } else {
                super.doMouseUp(evt, display, view, width, height);
            }
        }

        @Override
        public void drawWhileDragging(VectorGraphics g, Display display, View view, int width, int height) {
            if (this.throwing) {
                g.setColor(view.getForeground());
                g.drawLine(this.startX, this.startY, this.currentX, this.currentY);
            } else {
                super.drawWhileDragging(g, display, view, width, height);
            }
        }

        @Override
        public String getStatusText() {
            if (Util.isMacOS()) {
                return I18n.tr("vmm.ode.secondorder2D.mouseTaskStatusText.mac");
            }
            return I18n.tr("vmm.ode.secondorder2D.mouseTaskStatusText");
        }
    }
}

