/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.ode.secondorder2D;

import vmm3d.core.RealParamAnimateable;
import vmm3d.ode.secondorder2D.CentralForce;

public class Higgs
extends CentralForce {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 2.0, 1.5, 2.5);
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", 2.0, -1.95, -2.05);

    public Higgs() {
        this.addParameter(this.cc);
        this.addParameter(this.aa);
        this.initialDataDefault = new double[]{1.0, 1.0, -0.2, 0.2};
        this.setDefaultWindow(-3.0, 3.0, -3.0, 3.0);
    }

    @Override
    protected double force(double r) {
        if (Math.abs(r) < 0.001) {
            return 0.0;
        }
        double denom = Math.pow(r / this.cc.getValue(), 2.0);
        return -this.aa.getValue() * r * (1.0 - 1.0 / denom);
    }
}

