/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.functions;

import java.util.HashMap;
import vmm3d.core.Complex;
import vmm3d.functions.StackOp;

public final class EvalStack {
    private double[] stack;
    private int top;
    private int addressBase;
    private static HashMap<Thread, EvalStack> perThreadStacks = new HashMap();

    public EvalStack() {
        this(30);
    }

    public EvalStack(int initialSize) {
        if (initialSize < 1) {
            initialSize = 1;
        }
        this.stack = new double[initialSize];
    }

    public static final EvalStack perThread() {
        return EvalStack.perThread(Thread.currentThread());
    }

    public static final EvalStack perThread(Thread thread) {
        EvalStack stack = perThreadStacks.get(thread);
        if (stack == null && thread != null) {
            stack = new EvalStack();
            perThreadStacks.put(thread, stack);
        }
        return stack;
    }

    public static void perThreadRelease(Thread thread) {
        perThreadStacks.remove(thread);
    }

    void reset() {
        this.addressBase = 0;
        this.top = 0;
    }

    boolean isEmpty() {
        return this.top == 0;
    }

    void startFunctionCall(int sizeOfArgBlock) {
        this.push(this.addressBase);
        this.addressBase = this.top - 1 - sizeOfArgBlock;
    }

    void endRealValuedFunction(int sizeOfArgBlock) {
        double x = this.pop();
        this.addressBase = (int)this.pop();
        this.top -= sizeOfArgBlock;
        this.push(x);
    }

    void endComplexValuedFunction(int sizeOfArgBlock) {
        double a = this.pop();
        double b = this.pop();
        this.addressBase = (int)this.pop();
        this.top -= sizeOfArgBlock;
        this.push(b);
        this.push(a);
    }

    void push(double x) {
        if (this.stack.length == this.top) {
            double[] newStack = new double[this.top * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.top);
            this.stack = newStack;
        }
        this.stack[this.top++] = x;
    }

    void push(double re, double im) {
        this.push(re);
        this.push(im);
    }

    void push(Complex c) {
        this.push(c.re);
        this.push(c.im);
    }

    double pop() {
        return this.stack[--this.top];
    }

    Complex popComplex() {
        double im = this.pop();
        double re = this.pop();
        return new Complex(re, im);
    }

    void popComplex(Complex c) {
        c.im = this.pop();
        c.re = this.pop();
    }

    void fetch(int address) {
        this.push(this.stack[address + this.addressBase]);
    }

    void fetchComplex(int address) {
        this.push(this.stack[address + this.addressBase]);
        this.push(this.stack[address + this.addressBase + 1]);
    }

    void apply(StackOp op) {
        switch (op) {
            case COMPLEX_TO_REAL: {
                this.pop();
                break;
            }
            case REAL_TO_COMPLEX: {
                this.push(0.0);
                break;
            }
            case FIRST_OP_TO_COMPLEX: {
                double x = this.pop();
                double y = this.pop();
                this.push(0.0);
                this.push(y);
                this.push(x);
                break;
            }
            case IMAGINARY_PART: {
                double xi = this.pop();
                this.pop();
                this.push(xi);
                break;
            }
            case PLUS: {
                this.push(this.pop() + this.pop());
                break;
            }
            case MINUS: {
                double y = this.pop();
                this.push(this.pop() - y);
                break;
            }
            case TIMES: {
                this.push(this.pop() * this.pop());
                break;
            }
            case DIVIDE: {
                double y = this.pop();
                this.push(this.pop() / y);
                break;
            }
            case POWER: {
                double y = this.pop();
                this.push(Math.pow(this.pop(), y));
                break;
            }
            case C_PLUS: {
                double yi = this.pop();
                double yr = this.pop();
                double xi = this.pop();
                double xr = this.pop();
                this.push(xr + yr, xi + yi);
                break;
            }
            case C_MINUS: {
                double yi = this.pop();
                double yr = this.pop();
                double xi = this.pop();
                double xr = this.pop();
                this.push(xr - yr, xi - yi);
                break;
            }
            case C_TIMES: {
                double yi = this.pop();
                double yr = this.pop();
                double xi = this.pop();
                double xr = this.pop();
                this.push(xr * yr - xi * yi, xr * yi + yr * xi);
                break;
            }
            case C_DIVIDE: {
                double yi = this.pop();
                double yr = this.pop();
                double xi = this.pop();
                double xr = this.pop();
                double denom = yr * yr + yi * yi;
                this.push((xr * yr + xi * yi) / denom, (xi * yr - xr * yi) / denom);
                break;
            }
            case C_POWER: {
                double yi = this.pop();
                double yr = this.pop();
                double xi = this.pop();
                double xr = this.pop();
                double modulus = Math.sqrt(xr * xr + xi * xi);
                double modulus_log = Math.log(modulus);
                double arg = Math.atan2(xi, xr);
                double modulus_ans = Math.exp(yr * modulus_log - yi * arg);
                double arg_ans = yi * modulus_log + yr * arg;
                this.push(modulus_ans * Math.cos(arg_ans), modulus_ans * Math.sin(arg_ans));
                break;
            }
            case C_REAL_POWER: {
                double x = this.pop();
                double xi = this.pop();
                double xr = this.pop();
                double modulus = Math.sqrt(xi * xi + xr * xr);
                double arg = Math.atan2(xi, xr);
                double log_re = Math.log(modulus);
                double log_im = arg;
                double x_log_re = x * log_re;
                double x_log_im = x * log_im;
                double modulus_ans = Math.exp(x_log_re);
                this.push(modulus_ans * Math.cos(x_log_im), modulus_ans * Math.sin(x_log_im));
                break;
            }
            case EQ: {
                this.push(this.pop() == this.pop() ? 1.0 : 0.0);
                break;
            }
            case NE: {
                this.push(this.pop() != this.pop() ? 1.0 : 0.0);
                break;
            }
            case GE: {
                this.push(this.pop() <= this.pop() ? 1.0 : 0.0);
                break;
            }
            case GT: {
                this.push(this.pop() < this.pop() ? 1.0 : 0.0);
                break;
            }
            case LE: {
                this.push(this.pop() >= this.pop() ? 1.0 : 0.0);
                break;
            }
            case LT: {
                this.push(this.pop() > this.pop() ? 1.0 : 0.0);
                break;
            }
            case C_EQ: {
                double yi = this.pop();
                double yr = this.pop();
                double xi = this.pop();
                double xr = this.pop();
                this.push(xr == yr && xi == yi ? 1.0 : 0.0);
                break;
            }
            case C_NE: {
                double yi = this.pop();
                double yr = this.pop();
                double xi = this.pop();
                double xr = this.pop();
                this.push(xr == yr && xi == yi ? 0.0 : 1.0);
                break;
            }
            case AND: {
                double y = this.pop();
                double x = this.pop();
                this.push(x != 0.0 && y != 0.0 ? 1.0 : 0.0);
                break;
            }
            case OR: {
                double y = this.pop();
                double x = this.pop();
                this.push(x != 0.0 || y != 0.0 ? 1.0 : 0.0);
                break;
            }
            case NOT: {
                this.push(this.pop() != 0.0 ? 0.0 : 1.0);
                break;
            }
            case UNARY_MINUS: {
                this.push(-this.pop());
                break;
            }
            case C_UNARY_MINUS: {
                double xi = this.pop();
                double xr = this.pop();
                this.push(-xr, -xi);
                break;
            }
            case ABS: {
                this.push(Math.abs(this.pop()));
                break;
            }
            case SQRT: {
                this.push(Math.sqrt(this.pop()));
                break;
            }
            case CUBERT: {
                this.push(Math.cbrt(this.pop()));
                break;
            }
            case EXP: {
                this.push(Math.exp(this.pop()));
                break;
            }
            case LOG: {
                this.push(Math.log(this.pop()));
                break;
            }
            case LOG2: {
                this.push(Math.log(this.pop()) / Math.log(2.0));
                break;
            }
            case LOG10: {
                this.push(Math.log10(this.pop()));
                break;
            }
            case C_ABS: {
                double xi = this.pop();
                double xr = this.pop();
                this.push(Math.sqrt(xr * xr + xi * xi));
                break;
            }
            case C_SQRT: {
                this.push(0.5);
                this.apply(StackOp.C_REAL_POWER);
                break;
            }
            case C_CUBERT: {
                this.push(0.3333333333333333);
                this.apply(StackOp.C_REAL_POWER);
                break;
            }
            case C_EXP: {
                double xi = this.pop();
                double xr = this.pop();
                double e = Math.exp(xr);
                this.push(e * Math.cos(xi), e * Math.sin(xi));
                break;
            }
            case C_LOG: {
                double xi = this.pop();
                double xr = this.pop();
                this.push(0.5 * Math.log(xr * xr + xi * xi), Math.atan2(xi, xr));
                break;
            }
            case C_LOG2: {
                this.apply(StackOp.C_LOG);
                this.push(Math.log(2.0), 0.0);
                this.apply(StackOp.C_DIVIDE);
                break;
            }
            case C_LOG10: {
                this.apply(StackOp.C_LOG);
                this.push(Math.log(10.0), 0.0);
                this.apply(StackOp.C_DIVIDE);
                break;
            }
            case ARG: {
                double xi = this.pop();
                double xr = this.pop();
                this.push(Math.atan2(xi, xr));
                break;
            }
            case TRUNC: {
                this.push((int)this.pop());
                break;
            }
            case ROUND: {
                this.push((int)Math.round(this.pop()));
                break;
            }
            case CEILING: {
                this.push(Math.ceil(this.pop()));
                break;
            }
            case FLOOR: {
                this.push(Math.floor(this.pop()));
                break;
            }
            case SIGNUM: {
                this.push(Math.signum(this.pop()));
                break;
            }
            case SIN: {
                this.push(Math.sin(this.pop()));
                break;
            }
            case COS: {
                this.push(Math.cos(this.pop()));
                break;
            }
            case TAN: {
                this.push(Math.tan(this.pop()));
                break;
            }
            case SEC: {
                this.push(1.0 / Math.cos(this.pop()));
                break;
            }
            case COT: {
                double x = this.pop();
                this.push(Math.cos(x) / Math.sin(x));
                break;
            }
            case CSC: {
                this.push(1.0 / Math.sin(this.pop()));
                break;
            }
            case SINH: {
                this.push(Math.sinh(this.pop()));
                break;
            }
            case COSH: {
                this.push(Math.cosh(this.pop()));
                break;
            }
            case TANH: {
                this.push(Math.tanh(this.pop()));
                break;
            }
            case SECH: {
                this.push(1.0 / Math.cosh(this.pop()));
                break;
            }
            case COTH: {
                double x = this.pop();
                this.push(Math.cosh(x) / Math.sinh(x));
                break;
            }
            case CSCH: {
                this.push(1.0 / Math.sinh(this.pop()));
                break;
            }
            case ARCSIN: {
                this.push(Math.asin(this.pop()));
                break;
            }
            case ARCCOS: {
                this.push(Math.acos(this.pop()));
                break;
            }
            case ARCTAN: {
                this.push(Math.atan(this.pop()));
                break;
            }
            case ARCSINH: {
                double x = this.pop();
                this.push(Math.log(Math.sqrt(x * x + 1.0) + x));
                break;
            }
            case ARCCOSH: {
                double x = this.pop();
                this.push(x < 1.0 ? Double.NaN : Math.log(Math.sqrt(x * x - 1.0) + x));
                break;
            }
            case ARCTANH: {
                double x = this.pop();
                this.push(Math.abs(x) >= 1.0 ? Double.NaN : Math.log((1.0 + x) / (1.0 - x)) / 2.0);
                break;
            }
            case C_SIN: {
                double xi = this.pop();
                double xr = this.pop();
                double e2 = Math.exp(xi);
                double e1 = 1.0 / e2;
                this.push((e1 + e2) * Math.sin(xr) / 2.0, (e2 - e1) * Math.cos(xr) / 2.0);
                break;
            }
            case C_COS: {
                double xi = this.pop();
                double xr = this.pop();
                double e2 = Math.exp(xi);
                double e1 = 1.0 / e2;
                this.push((e1 + e2) * Math.cos(xr) / 2.0, (e1 - e2) * Math.sin(xr) / 2.0);
                break;
            }
            case C_TAN: {
                double xi = this.pop();
                double xr = this.pop();
                double e2 = Math.exp(xi);
                double e1 = 1.0 / e2;
                double a = (e1 + e2) * Math.sin(xr) / 2.0;
                double b = (e2 - e1) * Math.cos(xr) / 2.0;
                double c = (e1 + e2) * Math.cos(xr) / 2.0;
                double d = (e1 - e2) * Math.sin(xr) / 2.0;
                double denom = c * c + d * d;
                this.push((a * c + b * d) / denom, (b * c - a * d) / denom);
                break;
            }
            case C_SEC: {
                double xi = this.pop();
                double xr = this.pop();
                double e2 = Math.exp(xi);
                double e1 = 1.0 / e2;
                double a = (e1 + e2) * Math.cos(xr) / 2.0;
                double b = (e1 - e2) * Math.sin(xr) / 2.0;
                double denom = a * a + b * b;
                this.push(a / denom, -b / denom);
                break;
            }
            case C_COT: {
                double xi = this.pop();
                double xr = this.pop();
                double e2 = Math.exp(xi);
                double e1 = 1.0 / e2;
                double a = (e1 + e2) * Math.cos(xr) / 2.0;
                double b = (e1 - e2) * Math.sin(xr) / 2.0;
                double c = (e1 + e2) * Math.sin(xr) / 2.0;
                double d = (e2 - e1) * Math.cos(xr) / 2.0;
                double denom = c * c + d * d;
                this.push((a * c + b * d) / denom, (b * c - a * d) / denom);
                break;
            }
            case C_CSC: {
                double xi = this.pop();
                double xr = this.pop();
                double e2 = Math.exp(xi);
                double e1 = 1.0 / e2;
                double a = (e1 + e2) * Math.sin(xr) / 2.0;
                double b = (e2 - e1) * Math.cos(xr) / 2.0;
                double denom = a * a + b * b;
                this.push(a / denom, -b / denom);
                break;
            }
            case C_SINH: {
                double xi = this.pop();
                double xr = this.pop();
                double e2 = Math.exp(xr);
                double e1 = 1.0 / e2;
                this.push((e2 - e1) * Math.cos(xi) / 2.0, (e1 + e2) * Math.sin(xi) / 2.0);
                break;
            }
            case C_COSH: {
                double xi = this.pop();
                double xr = this.pop();
                double e2 = Math.exp(xr);
                double e1 = 1.0 / e2;
                this.push((e1 + e2) * Math.cos(xi) / 2.0, (e2 - e1) * Math.sin(xi) / 2.0);
                break;
            }
            case C_TANH: {
                double xi = this.pop();
                double xr = this.pop();
                double e2 = Math.exp(xr);
                double e1 = 1.0 / e2;
                double a = (e2 - e1) * Math.cos(xi) / 2.0;
                double b = (e1 + e2) * Math.sin(xi) / 2.0;
                double c = (e1 + e2) * Math.cos(xi) / 2.0;
                double d = (e2 - e1) * Math.sin(xi) / 2.0;
                double denom = c * c + d * d;
                this.push((a * c + b * d) / denom, (b * c - a * d) / denom);
                break;
            }
            case C_SECH: {
                double xi = this.pop();
                double xr = this.pop();
                double e2 = Math.exp(xr);
                double e1 = 1.0 / e2;
                double a = (e1 + e2) * Math.cos(xi) / 2.0;
                double b = (e2 - e1) * Math.sin(xi) / 2.0;
                double denom = a * a + b * b;
                this.push(a / denom, -b / denom);
                break;
            }
            case C_COTH: {
                double xi = this.pop();
                double xr = this.pop();
                double e2 = Math.exp(xr);
                double e1 = 1.0 / e2;
                double a = (e1 + e2) * Math.cos(xi) / 2.0;
                double b = (e2 - e1) * Math.sin(xi) / 2.0;
                double c = (e2 - e1) * Math.cos(xi) / 2.0;
                double d = (e1 + e2) * Math.sin(xi) / 2.0;
                double denom = c * c + d * d;
                this.push((a * c + b * d) / denom, (b * c - a * d) / denom);
                break;
            }
            case C_CSCH: {
                double xi = this.pop();
                double xr = this.pop();
                double e2 = Math.exp(xr);
                double e1 = 1.0 / e2;
                double a = (e2 - e1) * Math.cos(xi) / 2.0;
                double b = (e1 + e2) * Math.sin(xi) / 2.0;
                double denom = a * a + b * b;
                this.push(a / denom, -b / denom);
                break;
            }
            case C_ARCSIN: {
                double xi = this.pop();
                double xr = this.pop();
                this.push(-xi, xr);
                this.push(1.0, 0.0);
                this.push(xr, xi);
                this.push(2.0);
                this.apply(StackOp.C_REAL_POWER);
                this.apply(StackOp.C_MINUS);
                this.push(0.5);
                this.apply(StackOp.C_REAL_POWER);
                this.apply(StackOp.C_PLUS);
                this.apply(StackOp.C_LOG);
                xi = this.pop();
                xr = this.pop();
                this.push(xi, -xr);
                break;
            }
            case C_ARCCOS: {
                double xi = this.pop();
                double xr = this.pop();
                this.push(xr, xi);
                this.push(1.0, 0.0);
                this.push(xr, xi);
                this.push(2.0);
                this.apply(StackOp.C_REAL_POWER);
                this.apply(StackOp.C_MINUS);
                this.push(0.5);
                this.apply(StackOp.C_REAL_POWER);
                xi = this.pop();
                xr = this.pop();
                this.push(-xi, xr);
                this.apply(StackOp.C_PLUS);
                this.apply(StackOp.C_LOG);
                xi = this.pop();
                xr = this.pop();
                this.push(xi, -xr);
                break;
            }
            case C_ARCTAN: {
                double xi = this.pop();
                double xr = this.pop();
                this.push(xr, xi + 1.0);
                this.push(-xr, 1.0 - xi);
                this.apply(StackOp.C_DIVIDE);
                this.apply(StackOp.C_LOG);
                xi = this.pop();
                xr = this.pop();
                this.push(-xi / 2.0, xr / 2.0);
                break;
            }
            case C_ARCSINH: {
                double xi = this.pop();
                double xr = this.pop();
                this.push(xr, xi);
                this.push(xr, xi);
                this.push(2.0);
                this.apply(StackOp.C_REAL_POWER);
                this.push(1.0, 0.0);
                this.apply(StackOp.C_PLUS);
                this.push(0.5);
                this.apply(StackOp.C_REAL_POWER);
                this.apply(StackOp.C_PLUS);
                this.apply(StackOp.C_LOG);
                break;
            }
            case C_ARCCOSH: {
                double xi = this.pop();
                double xr = this.pop();
                this.push(xr, xi);
                this.push(xr, xi);
                this.push(2.0);
                this.apply(StackOp.C_REAL_POWER);
                this.push(1.0, 0.0);
                this.apply(StackOp.C_MINUS);
                this.push(0.5);
                this.apply(StackOp.C_REAL_POWER);
                this.apply(StackOp.C_PLUS);
                this.apply(StackOp.C_LOG);
                break;
            }
            case C_ARCTANH: {
                double xi = this.pop();
                double xr = this.pop();
                this.push(xr + 1.0, xi);
                this.push(1.0 - xr, -xi);
                this.apply(StackOp.C_DIVIDE);
                this.apply(StackOp.C_LOG);
                xi = this.pop();
                xr = this.pop();
                this.push(xr / 2.0, xi / 2.0);
                break;
            }
            case CONJ: {
                double xi = this.pop();
                this.push(-xi);
            }
        }
    }
}

