/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.functions;

import vmm3d.core.Complex;
import vmm3d.functions.ComplexFunction;
import vmm3d.functions.EvalStack;
import vmm3d.functions.ProgFunction;
import vmm3d.functions.Type;

public class ComplexFunction3
extends ComplexFunction {
    ComplexFunction3(String name, ProgFunction func) {
        super(name, func);
        assert (func.getArgType() == Type.COMPLEX && func.getType() == Type.COMPLEX && func.getArgCount() == 3);
    }

    public synchronized Complex value(Complex z, Complex w, Complex v) {
        return this.value(z, w, v, EvalStack.perThread());
    }

    public synchronized Complex value(double z_re, double z_im, double w_re, double w_im, double v_re, double v_im) {
        return this.value(z_re, z_im, w_re, w_im, v_re, v_im, EvalStack.perThread());
    }

    public Complex value(Complex z, Complex w, Complex v, EvalStack stack) {
        Complex answer = new Complex();
        this.value(z, w, v, stack, answer);
        return answer;
    }

    public Complex value(double z_re, double z_im, double w_re, double w_im, double v_re, double v_im, EvalStack stack) {
        Complex answer = new Complex();
        this.value(z_re, z_im, w_re, w_im, v_re, v_im, stack, answer);
        return answer;
    }

    public void value(Complex z, Complex w, Complex v, EvalStack stack, Complex answer) {
        if (answer == null) {
            throw new IllegalArgumentException("internal error: answer object cannot be null");
        }
        stack.push(z);
        stack.push(w);
        stack.push(v);
        this.func.apply(stack);
        stack.popComplex(answer);
    }

    public void value(double z_re, double z_im, double w_re, double w_im, double v_re, double v_im, EvalStack stack, Complex answer) {
        if (answer == null) {
            throw new IllegalArgumentException("internal error: answer object cannot be null");
        }
        stack.push(z_re, z_im);
        stack.push(w_re, w_im);
        stack.push(v_re, v_im);
        this.func.apply(stack);
        stack.popComplex(answer);
    }
}

