/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.fractals;

import java.awt.event.ActionEvent;
import vmm3d.actions.ActionList;
import vmm3d.actions.ToggleAction;
import vmm3d.core.Complex;
import vmm3d.core.I18n;
import vmm3d.core.VMMSave;
import vmm3d.core.View;
import vmm3d.fractals.RepeatedSegmentFractal;

public class Sierpinski
extends RepeatedSegmentFractal {
    Complex[] helpSierpinskiCurve;
    @VMMSave
    private boolean useInjectiveCurves = true;
    private ToggleAction segmentChoiceToggle;

    public Sierpinski() {
        this.fractality.reset(0.5, 0.3333333333333333, 0.5);
        this.fractality.setMaximumValueForInput(0.5);
        this.fractality.setMinimumValueForInput(0.3333333333333333);
        this.recursionLevel.reset(9);
        this.recursionLevel.setMaximumValueForInput(11);
        this.recursionLevel.setMinimumValueForInput(1);
        this.setDefaultWindow(-1.0, 1.0, -0.75, 1.25);
        this.colorRepeatFactor = 2;
        this.fastDrawRecursionLevel = 6;
        this.segmentChoiceToggle = new ToggleAction(I18n.tr("vmm.fractals.Sierpinski.segmentchoice"), true){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sierpinski.this.setUseInjectiveCurves(this.getState());
            }
        };
    }

    public boolean getUseInjectiveCurve() {
        return this.useInjectiveCurves;
    }

    public void setUseInjectiveCurves(boolean useInjectiveCurves) {
        if (this.useInjectiveCurves == useInjectiveCurves) {
            return;
        }
        this.useInjectiveCurves = useInjectiveCurves;
        this.segmentChoiceToggle.setState(useInjectiveCurves);
        this.forceRedraw();
    }

    @Override
    public ActionList getActionsForView(View view) {
        ActionList actions = super.getActionsForView(view);
        actions.add(null);
        actions.add(this.segmentChoiceToggle);
        return actions;
    }

    private boolean turnsLeft(Complex u, Complex v, Complex w) {
        return -(v.im - u.im) * (w.re - v.re) + (v.re - u.re) * (w.im - v.im) > 0.0;
    }

    @Override
    protected Complex[] computeNextLevel(Complex[] sierpinskiCurve, int computedLevel) {
        Complex[] newSierpinskiCurve;
        double bb = this.fractality.getValue();
        double bi = Math.sqrt(0.5 * bb * (1.0 + 1.5 * bb) - 0.25);
        Complex c1 = new Complex((1.0 + bb) / 2.0, -bi);
        Complex c2 = new Complex((1.0 - bb) / 2.0, bi);
        if (computedLevel == 0) {
            double aa = 0.5;
            Complex u = new Complex(-1.0, -1.0 / Math.sqrt(3.0));
            Complex v = new Complex(1.0, -1.0 / Math.sqrt(3.0));
            Complex w = new Complex(0.0, 2.0 / Math.sqrt(3.0));
            this.helpSierpinskiCurve = new Complex[7];
            this.helpSierpinskiCurve[0] = new Complex(u.realLinComb(aa, aa, v));
            this.helpSierpinskiCurve[1] = new Complex(v);
            this.helpSierpinskiCurve[2] = new Complex(v.realLinComb(aa, aa, w));
            this.helpSierpinskiCurve[3] = new Complex(w);
            this.helpSierpinskiCurve[4] = new Complex(w.realLinComb(aa, aa, u));
            this.helpSierpinskiCurve[5] = new Complex(u);
            this.helpSierpinskiCurve[6] = new Complex(u.realLinComb(aa, aa, v));
            newSierpinskiCurve = new Complex[]{new Complex(this.helpSierpinskiCurve[0]), new Complex(this.helpSierpinskiCurve[2]), new Complex(this.helpSierpinskiCurve[4]), new Complex(this.helpSierpinskiCurve[6])};
        } else {
            int k;
            int ll = this.helpSierpinskiCurve.length;
            newSierpinskiCurve = new Complex[ll];
            for (k = 0; k < ll; ++k) {
                newSierpinskiCurve[k] = this.helpSierpinskiCurve[k];
            }
            this.helpSierpinskiCurve = new Complex[3 * this.helpSierpinskiCurve.length - 2];
            int j = 0;
            this.helpSierpinskiCurve[j] = newSierpinskiCurve[j];
            for (int i = 0; i < ll - 1; i += 2) {
                boolean sflag = this.turnsLeft(newSierpinskiCurve[i], newSierpinskiCurve[i + 1], newSierpinskiCurve[i + 2]);
                this.helpSierpinskiCurve[++j] = bb == 0.3333333333333333 ? new Complex(newSierpinskiCurve[i].realLinComb((1.0 + bb) / 2.0, (1.0 - bb) / 2.0, newSierpinskiCurve[i + 1])) : (sflag ? new Complex(newSierpinskiCurve[i].complexLinComb(c1, c2, newSierpinskiCurve[i + 1])) : new Complex(newSierpinskiCurve[i].complexLinComb(c1.conj(), c2.conj(), newSierpinskiCurve[i + 1])));
                this.helpSierpinskiCurve[++j] = new Complex(newSierpinskiCurve[i].realLinComb(bb, 1.0 - bb, newSierpinskiCurve[i + 1]));
                this.helpSierpinskiCurve[++j] = new Complex(newSierpinskiCurve[i + 1]);
                this.helpSierpinskiCurve[++j] = new Complex(newSierpinskiCurve[i + 1].realLinComb(1.0 - bb, bb, newSierpinskiCurve[i + 2]));
                this.helpSierpinskiCurve[++j] = bb == 0.3333333333333333 ? new Complex(newSierpinskiCurve[i + 1].realLinComb((1.0 - bb) / 2.0, (1.0 + bb) / 2.0, newSierpinskiCurve[i + 2])) : (sflag ? new Complex(newSierpinskiCurve[i + 1].complexLinComb(c2.conj(), c1.conj(), newSierpinskiCurve[i + 2])) : new Complex(newSierpinskiCurve[i + 1].complexLinComb(c2, c1, newSierpinskiCurve[i + 2])));
                this.helpSierpinskiCurve[++j] = new Complex(newSierpinskiCurve[i + 2]);
            }
            newSierpinskiCurve = new Complex[(this.helpSierpinskiCurve.length + 1) / 2];
            for (k = 0; k < newSierpinskiCurve.length; ++k) {
                newSierpinskiCurve[k] = this.helpSierpinskiCurve[2 * k];
            }
        }
        if (!this.getUseInjectiveCurve()) {
            return this.helpSierpinskiCurve;
        }
        return newSierpinskiCurve;
    }
}

