/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.fractals;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.event.ChangeEvent;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.actions.ActionRadioGroup;
import vmm3d.core.BasicMouseTask2D;
import vmm3d.core.Complex;
import vmm3d.core.Decoration;
import vmm3d.core.Display;
import vmm3d.core.Exhibit;
import vmm3d.core.I18n;
import vmm3d.core.IntegerParam;
import vmm3d.core.MouseTask;
import vmm3d.core.Parameter;
import vmm3d.core.RealParam;
import vmm3d.core.TaskManager;
import vmm3d.core.Transform;
import vmm3d.core.Util;
import vmm3d.core.VMMSave;
import vmm3d.core.View;

public class Mandelbrot
extends Exhibit {
    private JuliaSetAndOrbitDecoration juliaAndOrbitDecoration;
    private IntegerParam pointsOnOrbit = new IntegerParam("vmm.fractals.Mandelbrot.PointsOnOrbit", 100);
    private RealParam juliaPointX = new RealParam("vmm.fractals.Mandelbrot.juliaPointX", 0.25);
    private RealParam juliaPointY = new RealParam("vmm.fractals.Mandelbrot.juliaPointY", 0.45);
    private TaskManager taskManager;
    private double[][] exampleData = new double[][]{{-0.7241608526756182, -0.7241608526694334, 0.36158285101080495, 0.3615828510154436, 1000.0, 250.0}, {-1.9072326638218555, -1.9072326346322426, -1.0859414558092964E-8, 1.103279515362283E-8, 500.0, 100.0}, {0.35471345463684467, 0.35473822122425647, 0.095401040922098, 0.09541961586265685, 4000.0, 2500.0}, {0.2726031397857463, 0.2726031483804942, 0.0053565210436868176, 0.005356527489747753, 7500.0, 2500.0}, {0.28601560167064516, 0.2860156017191516, 0.011537485975923616, 0.011537486012303432, 3000.0, 250.0}, {-1.6744096756044493, -1.6744096717769306, 4.716419197284976E-5, 4.7167062611931696E-5, 7500.0, 1000.0}, {0.25989953593561266, 0.259899641345385, 0.001612579325834812, 0.0016126583831640785, 2000.0, 250.0}, {-1.674409674093473, -1.6744096740931858, 4.716540768697223E-5, 4.716540790246652E-5, 10000.0, 250.0}, {-1.4035289973308978, -1.4035289973294278, 0.02930868838864931, 0.029308688389751928, 2500.0, 500.0}, {-1.9072311984370052, -1.9072311928858665, 1.5197004423572747E-5, 1.5201167777464862E-5, 7500.0, 250.0}, {-0.753231765876289, -0.7532317565038811, 0.04633550302364065, 0.046335510285468194, 10000.0, 250.0}, {-1.9963806954442953, -1.996380695443582, 2.62870483517615E-7, 2.628710361171417E-7, 1500.0, 250.0}, {0.29768460024540017, 0.297684633418743, 0.020961285679467805, 0.020961312432163624, 5000.0, 1000.0}};

    public Mandelbrot() {
        this.addParameter(this.juliaPointY);
        this.addParameter(this.juliaPointX);
        this.addParameter(this.pointsOnOrbit);
        this.pointsOnOrbit.setMinimumValueForInput(1);
        this.pointsOnOrbit.setMaximumValueForInput(1000);
        this.juliaPointX.setMinimumValueForInput(-4.0);
        this.juliaPointX.setMaximumValueForInput(3.0);
        this.juliaPointY.setMinimumValueForInput(-3.0);
        this.juliaPointY.setMaximumValueForInput(3.0);
        this.juliaAndOrbitDecoration = new JuliaSetAndOrbitDecoration();
        this.juliaAndOrbitDecoration.setStartPoint(new Point2D.Double(this.juliaPointX.getValue(), this.juliaPointY.getValue()));
        this.addDecoration(this.juliaAndOrbitDecoration);
        this.setDefaultWindow(-2.25, 0.85, -1.25, 1.25);
    }

    @Override
    public void removeView(View view) {
        super.removeView(view);
        if (this.taskManager != null && (this.getViews() == null || this.getViews().size() == 0)) {
            this.taskManager.shutDown();
            this.taskManager = null;
        }
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        this.juliaAndOrbitDecoration.setStartPoint(new Point2D.Double(this.juliaPointX.getValue(), this.juliaPointY.getValue()));
    }

    private void drawMandelbrot(View view, Transform transform) {
        int height = transform.getHeight();
        MandelbrotView mView = (MandelbrotView)view;
        mView.cancelAsyncComputeJob();
        if (view.getFastDrawing()) {
            int max = mView.maxCount.getValue();
            int paletteLength = mView.paletteLength.getValue();
            int width = transform.getWidth();
            Point2D.Double pt = new Point2D.Double();
            int blockSize = 10;
            if (max <= 50) {
                blockSize = 3;
            } else if (max <= 500) {
                blockSize = 6;
            }
            for (int r = blockSize; r < height + blockSize; r += blockSize * 2) {
                for (int c = blockSize; c < width + blockSize; c += blockSize * 2) {
                    Color color;
                    ((Point2D)pt).setLocation(c, r);
                    transform.viewportToWindow(pt);
                    double x = ((Point2D)pt).getX();
                    double y = ((Point2D)pt).getY();
                    int ct = this.iterate(x, y, max);
                    if (ct == max) {
                        color = Color.BLACK;
                    } else {
                        float hue = paletteLength > 0 ? (float)(ct % paletteLength) / (float)paletteLength : (float)ct / (float)max;
                        color = Color.getHSBColor(hue, 1.0f, 1.0f);
                    }
                    mView.setColor(color);
                    mView.fillRectDirect(c - blockSize, r - blockSize, blockSize * 2, blockSize * 2);
                }
            }
        } else {
            view.getDisplay().setCursor(Cursor.getPredefinedCursor(3));
            if (this.taskManager == null) {
                this.taskManager = new TaskManager();
            }
            mView.fillCanvasWithGray();
            TaskManager.Job job = this.taskManager.createJob();
            int jobNumber = ++mView.asyncJobNum;
            for (int r = 0; r < height; ++r) {
                job.add(new ComputeRow(r, mView, jobNumber));
            }
            job.close();
            if (!job.await(500)) {
                mView.startAsyncComputeJob(job);
            } else {
                view.getDisplay().setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private int iterate(double cx, double cy, int max) {
        int ct;
        double zx = cx;
        double zy = cy;
        for (ct = 0; ct < max && zx * zx + zy * zy <= 4.0; ++ct) {
            double t = zx * zx - zy * zy + cx;
            zy = 2.0 * zx * zy + cy;
            zx = t;
        }
        return ct;
    }

    @Override
    public ActionList getActionsForView(final View view) {
        ActionList actions = super.getActionsForView(view);
        actions.add(new AbstractActionVMM(I18n.tr("vmm.fractals.Mandelbrot.DragToShowCoords")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                view.getDisplay().installOneShotMouseTask(new ShowCoordsMouseTask());
            }
        });
        actions.add(new AbstractActionVMM(I18n.tr("vmm.fractals.Mandelbrot.RecenterOnPointMenuItem") + "..."){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Mandelbrot.this.doCenterOnUserPoint(view);
            }
        });
        ActionList zoomIn = new ActionList(I18n.tr("vmm.fractals.Mandelbrot.ZoomIn"));
        for (int zoom = 2; zoom <= 32; zoom *= 2) {
            final double z = zoom;
            zoomIn.add(new AbstractActionVMM(I18n.tr("vmm.fractals.Mandelbrot.ZoomIn") + " " + zoom + "X"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ((MandelbrotView)view).doZoom(z);
                }
            });
        }
        actions.add(zoomIn);
        ActionList zoomOut = new ActionList(I18n.tr("vmm.fractals.Mandelbrot.ZoomOut"));
        for (int zoom = 2; zoom <= 32; zoom *= 2) {
            final double z = 1.0 / (double)zoom;
            zoomOut.add(new AbstractActionVMM(I18n.tr("vmm.fractals.Mandelbrot.ZoomOut") + " " + zoom + "X"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ((MandelbrotView)view).doZoom(z);
                }
            });
        }
        actions.add(zoomOut);
        actions.add(new AbstractActionVMM(I18n.tr("vmm.fractals.Mandelbrot.RestoreDefaults")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MandelbrotView mView = (MandelbrotView)view;
                mView.maxCount.setValue(mView.maxCount.getDefaultValue());
                mView.paletteLength.setValue(mView.paletteLength.getDefaultValue());
                mView.setWindow(Mandelbrot.this.getDefaultWindow());
                mView.setShowJuliaAndOrbit(3);
            }
        });
        ActionList examples = new ActionList(I18n.tr("vmm.fractals.Mandelbrot.Examples"));
        for (int i = 0; i < this.exampleData.length; ++i) {
            final int exampleNum = i;
            examples.add(new AbstractActionVMM("  " + (i + 1) + "  "){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    double[] data = Mandelbrot.this.exampleData[exampleNum];
                    MandelbrotView mView = (MandelbrotView)view;
                    mView.setWindow(data[0], data[1], data[2], data[3]);
                    mView.maxCount.setValue((int)data[4]);
                    mView.paletteLength.setValue((int)data[5]);
                    mView.setShowJuliaAndOrbit(3);
                }
            });
        }
        actions.add(examples);
        actions.add(null);
        actions.add(new AbstractActionVMM(I18n.tr("vmm.fractals.Mandelbrot.MoveJuliaPoint")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                view.getDisplay().installOneShotMouseTask(new MoveJuliaStartByMouseClick());
            }
        });
        return actions;
    }

    private void doCenterOnUserPoint(View view) {
        Point2D newCenter = Util.getPoint2DFromUser(view.getDisplay(), I18n.tr("vmm.fractals.Mandelbrot.RecenterOnPointPrompt"));
        if (newCenter == null) {
            return;
        }
        Transform tr = view.getTransform();
        double xCenter = (tr.getXmax() + tr.getXmin()) / 2.0;
        double yCenter = (tr.getYmax() + tr.getYmin()) / 2.0;
        double newX = newCenter.getX();
        double newY = newCenter.getY();
        double offsetX = newX - xCenter;
        double offsetY = newY - yCenter;
        if (offsetX == 0.0 && offsetY == 0.0) {
            return;
        }
        tr.setLimits(tr.getXmin() + offsetX, tr.getXmax() + offsetX, tr.getYmin() + offsetY, tr.getYmax() + offsetY);
    }

    @Override
    public View getDefaultView() {
        return new MandelbrotView();
    }

    private class JuliaSetAndOrbitDecoration
    extends Decoration {
        Complex[] juliaStart = new Complex[1024];
        Complex[] juliaAux = new Complex[1024];
        Complex firstFixedPoint;
        Complex secondFixedPoint;
        int currentJuliaLength = 0;
        double cx;
        double cy;

        private JuliaSetAndOrbitDecoration() {
        }

        public void setStartPoint(Point2D pt) {
            this.cx = pt.getX();
            this.cy = pt.getY();
            this.forceRedraw();
        }

        private void computeFixedPoints() {
            Complex z = new Complex(0.25 - this.cx, -this.cy);
            z = z.power(0.5);
            this.firstFixedPoint = z.plus(0.5);
            this.secondFixedPoint = z.times(-1.0).plus(0.5);
            if (this.firstFixedPoint.r() < this.secondFixedPoint.r()) {
                z = this.secondFixedPoint;
                this.secondFixedPoint = this.firstFixedPoint;
                this.firstFixedPoint = z;
            }
        }

        private void makeJuliaStart() {
            Complex c = new Complex(this.cx, this.cy);
            this.computeFixedPoints();
            this.juliaStart[0] = this.firstFixedPoint;
            this.juliaStart[2] = this.firstFixedPoint.times(-1.0);
            Complex z = this.juliaStart[2].minus(c).power(0.5);
            if (z.re * this.juliaStart[0].im - z.im * this.juliaStart[0].re < 0.0) {
                z = z.times(-1.0);
            }
            this.juliaStart[1] = z;
            this.juliaStart[3] = z.times(-1.0);
            this.currentJuliaLength = 4;
            for (int i = 1; i < 9; ++i) {
                int j;
                this.juliaAux[0] = this.juliaStart[0];
                this.juliaAux[0 + this.currentJuliaLength] = this.juliaStart[0].times(-1.0);
                for (j = 1; j < this.currentJuliaLength; ++j) {
                    this.juliaAux[j] = this.juliaStart[j].minus(c).squareRootNearer(this.juliaAux[j - 1]);
                    this.juliaAux[j + this.currentJuliaLength] = this.juliaAux[j].times(-1.0);
                }
                this.currentJuliaLength = 2 * this.currentJuliaLength;
                for (j = 1; j < this.currentJuliaLength; ++j) {
                    this.juliaStart[j] = this.juliaAux[j];
                }
            }
        }

        @Override
        public void doDraw(VectorGraphics g, View view, Transform transform) {
            MandelbrotView mbView = (MandelbrotView)view;
            if (mbView.getShowJuliaAndOrbit() == 3) {
                return;
            }
            Color saveColor = g.getColor();
            double zx = this.cx;
            double zy = this.cy;
            Point2D.Double pt = new Point2D.Double();
            ((Point2D)pt).setLocation(this.cx, this.cy);
            transform.windowToViewport(pt);
            int cxInt = (int)(((Point2D)pt).getX() + 0.499);
            int cyInt = (int)(((Point2D)pt).getY() + 0.499);
            g.setColor(Color.WHITE);
            if (mbView.getShowJuliaAndOrbit() == 0 || mbView.getShowJuliaAndOrbit() == 2) {
                this.makeJuliaStart();
                for (int i = 0; i < this.currentJuliaLength; ++i) {
                    zx = this.juliaStart[i].re;
                    zy = this.juliaStart[i].im;
                    ((Point2D)pt).setLocation(zx, zy);
                    transform.windowToViewport(pt);
                    int zxInt = (int)(((Point2D)pt).getX() + 0.499);
                    int zyInt = (int)(((Point2D)pt).getY() + 0.499);
                    mbView.drawLineDirect(zxInt - 1, zyInt, zxInt + 1, zyInt);
                    mbView.drawLineDirect(zxInt, zyInt - 1, zxInt, zyInt + 1);
                }
            }
            int x1 = cxInt - 7;
            int x2 = cxInt + 7;
            int y1 = cyInt - 7;
            int y2 = cyInt + 7;
            g.setColor(Color.BLACK);
            mbView.drawLineDirect(cxInt - 2, y1, cxInt - 2, y2);
            mbView.drawLineDirect(cxInt + 1, y1, cxInt + 1, y2);
            mbView.drawLineDirect(x1, cyInt - 2, x2, cyInt - 2);
            mbView.drawLineDirect(x1, cyInt + 1, x2, cyInt + 1);
            if (mbView.getShowJuliaAndOrbit() == 1 || mbView.getShowJuliaAndOrbit() == 2) {
                zx = this.cx;
                zy = this.cy;
                int ct = Mandelbrot.this.pointsOnOrbit.getValue();
                for (int i = 0; i < ct; ++i) {
                    ((Point2D)pt).setLocation(zx, zy);
                    transform.windowToViewport(pt);
                    int x = (int)((Point2D)pt).getX();
                    int y = (int)((Point2D)pt).getY();
                    mbView.fillOvalDirect(Color.getHSBColor((float)(0.75 * (double)(ct - i)) / (float)ct, 0.6f, 1.0f), x - 3, y - 3, 5, 5);
                    mbView.drawOvalDirect(Color.GRAY, x - 3, y - 3, 6, 6);
                    double t = zx * zx - zy * zy + this.cx;
                    zy = 2.0 * zx * zy + this.cy;
                    zx = t;
                }
            }
            g.setColor(Color.WHITE);
            mbView.drawLineDirect(cxInt - 1, y1, cxInt - 1, y2);
            mbView.drawLineDirect(cxInt, y1, cxInt, y2);
            mbView.drawLineDirect(x1, cyInt - 1, x2, cyInt - 1);
            mbView.drawLineDirect(x1, cyInt, x2, cyInt);
            g.setColor(saveColor);
        }
    }

    private class MoveJuliaStartByMouseClick
    extends MouseTask {
        private MoveJuliaStartByMouseClick() {
        }

        @Override
        public boolean doMouseDown(MouseEvent evt, Display display, View view, int width, int height) {
            Point2D.Double pt = new Point2D.Double(evt.getX(), evt.getY());
            view.getTransform().viewportToWindow(pt);
            Mandelbrot.this.juliaPointX.setValue(((Point2D)pt).getX());
            Mandelbrot.this.juliaPointY.setValue(((Point2D)pt).getY());
            if (((MandelbrotView)view).getShowJuliaAndOrbit() == 3) {
                ((MandelbrotView)view).setShowJuliaAndOrbit(2);
            }
            return false;
        }

        @Override
        public Cursor getCursor(Display display, View view) {
            return Cursor.getPredefinedCursor(1);
        }
    }

    private class DragJuliaStartMouseTask
    extends BasicMouseTask2D {
        boolean draggingStartPoint;
        int offsetX;
        int offsetY;

        private DragJuliaStartMouseTask() {
        }

        @Override
        public boolean doMouseDown(MouseEvent evt, Display display, View view, int width, int height) {
            this.draggingStartPoint = false;
            if (((MandelbrotView)view).getShowJuliaAndOrbit() == 3) {
                return super.doMouseDown(evt, display, view, width, height);
            }
            Point2D.Double pt = new Point2D.Double(Mandelbrot.this.juliaPointX.getValue(), Mandelbrot.this.juliaPointY.getValue());
            view.getTransform().windowToViewport(pt);
            this.offsetX = (int)((Point2D)pt).getX() - evt.getX();
            this.offsetY = (int)((Point2D)pt).getY() - evt.getY();
            if (Math.abs(this.offsetX) <= 7 && Math.abs(this.offsetY) <= 7) {
                this.draggingStartPoint = true;
                return true;
            }
            return super.doMouseDown(evt, display, view, width, height);
        }

        @Override
        public void doMouseDrag(MouseEvent evt, Display display, View view, int width, int height) {
            if (!this.draggingStartPoint) {
                super.doMouseDrag(evt, display, view, width, height);
                return;
            }
            Point2D.Double pt = new Point2D.Double(evt.getX() + this.offsetX, evt.getY() + this.offsetY);
            view.getTransform().viewportToWindow(pt);
            Mandelbrot.this.juliaPointX.setValue(((Point2D)pt).getX());
            Mandelbrot.this.juliaPointY.setValue(((Point2D)pt).getY());
            display.setStatusText("(cx,cy) = " + ((MandelbrotView)view).getCoordString(evt.getX(), evt.getY()));
        }

        @Override
        public void doMouseUp(MouseEvent evt, Display display, View view, int width, int height) {
            if (!this.draggingStartPoint) {
                super.doMouseUp(evt, display, view, width, height);
            } else {
                display.setStatusText(null);
            }
        }

        @Override
        public void drawWhileDragging(VectorGraphics g, Display display, View view, int width, int height) {
            if (!this.draggingStartPoint) {
                super.drawWhileDragging(g, display, view, width, height);
            }
        }

        @Override
        public Cursor getCursorForDragging(MouseEvent evt, Display display, View view) {
            if (this.draggingStartPoint) {
                return Cursor.getDefaultCursor();
            }
            return super.getCursorForDragging(evt, display, view);
        }
    }

    private class ShowCoordsMouseTask
    extends MouseTask {
        private ShowCoordsMouseTask() {
        }

        @Override
        public boolean doMouseDown(MouseEvent evt, Display display, View view, int width, int height) {
            display.setStatusText("(x,y) = " + ((MandelbrotView)view).getCoordString(evt.getX(), evt.getY()));
            return true;
        }

        @Override
        public void doMouseDrag(MouseEvent evt, Display display, View view, int width, int height) {
            display.setStatusText("(x,y) = " + ((MandelbrotView)view).getCoordString(evt.getX(), evt.getY()));
        }

        @Override
        public Cursor getCursor(Display display, View view) {
            return Cursor.getPredefinedCursor(1);
        }

        @Override
        public String getStatusText() {
            return I18n.tr("vmm.fractals.Mandelbrot.DragToShowCoordsStatusText");
        }
    }

    public class MandelbrotView
    extends View {
        public static final int SHOW_JULIA = 0;
        public static final int SHOW_ORBIT = 1;
        public static final int SHOW_BOTH = 2;
        public static final int SHOW_NONE = 3;
        @VMMSave
        private int showJuliaAndOrbit = 3;
        private ActionRadioGroup showJuliaAndOrbitSelect;
        private Transform previousTransform = null;
        private boolean bitmapNeedsRedraw = true;
        private volatile int asyncJobNum;
        private volatile Thread asyncComputeThread;
        private volatile TaskManager.Job asyncComputeJob;
        private IntegerParam maxCount = new IntegerParam("vmm.fractals.Mandelbrot.MaxIters", 50);
        private IntegerParam paletteLength = new IntegerParam("vmm.fractals.Mandelbrot.PaletteLength", 0);

        public MandelbrotView() {
            this.addParameter(this.paletteLength);
            this.addParameter(this.maxCount);
            this.maxCount.setMinimumValueForInput(10);
            this.maxCount.setMaximumValueForInput(100000);
            this.paletteLength.setMinimumValueForInput(0);
            this.paletteLength.setMaximumValueForInput(100000);
            this.showJuliaAndOrbitSelect = new ActionRadioGroup(){

                @Override
                public void optionSelected(int selectedIndex) {
                    MandelbrotView.this.setShowJuliaAndOrbit(selectedIndex);
                }
            };
            this.showJuliaAndOrbitSelect.addItem(I18n.tr("vmm.fractals.Mandelbrot.showJuliaAndOrbit.julia"));
            this.showJuliaAndOrbitSelect.addItem(I18n.tr("vmm.fractals.Mandelbrot.showJuliaAndOrbit.orbit"));
            this.showJuliaAndOrbitSelect.addItem(I18n.tr("vmm.fractals.Mandelbrot.showJuliaAndOrbit.both"));
            this.showJuliaAndOrbitSelect.addItem(I18n.tr("vmm.fractals.Mandelbrot.showJuliaAndOrbit.none"));
            this.showJuliaAndOrbitSelect.setSelectedIndex(this.showJuliaAndOrbit);
            this.backgroundCommands.setEnabled(false);
        }

        public void doZoom(double magnificationFactor) {
            double[] window = this.getRequestedWindow();
            double width = window[1] - window[0];
            double height = window[3] - window[2];
            double centerX = window[0] + width / 2.0;
            double centerY = window[2] + height / 2.0;
            double newWidth = width / magnificationFactor;
            double newHeight = height / magnificationFactor;
            this.setWindow(centerX - newWidth / 2.0, centerX + newWidth / 2.0, centerY - newHeight / 2.0, centerY + newHeight / 2.0);
        }

        String getCoordString(int x, int y) {
            double diff;
            double[] window = this.getWindow();
            double xmin = window[0];
            double xmax = window[1];
            double ymin = window[2];
            double ymax = window[3];
            double width = this.getTransform().getWidth();
            double height = this.getTransform().getHeight();
            double xCoord = xmin + (double)x / width * (xmax - xmin);
            double yCoord = ymax - (double)y / height * (ymax - ymin);
            int scale = 4;
            if (diff > 0.0) {
                for (diff = xmax - xmin; diff < 1.0; diff *= 10.0) {
                    ++scale;
                }
            }
            String xStr = String.format("%1." + scale + "f", xCoord);
            String yStr = String.format("%1." + scale + "f", yCoord);
            return "(" + xStr + ", " + yStr + ")";
        }

        public int getShowJuliaAndOrbit() {
            return this.showJuliaAndOrbit;
        }

        public void setShowJuliaAndOrbit(int showJuliaAndOrbit) {
            if (this.showJuliaAndOrbit == showJuliaAndOrbit) {
                return;
            }
            this.showJuliaAndOrbit = showJuliaAndOrbit;
            this.showJuliaAndOrbitSelect.setSelectedIndex(showJuliaAndOrbit);
            if (this.getDisplay() != null) {
                this.getDisplay().setStatusText();
            }
            this.forceRedraw();
        }

        @Override
        public ActionList getActions() {
            ActionList actions = super.getActions();
            actions.add(this.showJuliaAndOrbitSelect);
            return actions;
        }

        @Override
        public String getStatusText() {
            if (this.showJuliaAndOrbit == 3) {
                if (!Util.isMacOS()) {
                    return I18n.tr("vmm.fractals.Mandelbrot.statusText.DragToZoom");
                }
                return I18n.tr("vmm.fractals.Mandelbrot.statusText.DragToZoomMac");
            }
            return I18n.tr("vmm.fractals.Mandelbrot.statusText.dragCross");
        }

        @Override
        public void setFastDrawing(boolean fast, boolean redrawSynchronizedViews) {
            super.setFastDrawing(fast, redrawSynchronizedViews);
            this.bitmapNeedsRedraw = true;
            this.forceRedraw();
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            super.stateChanged(evt);
            if (evt.getSource() instanceof Transform) {
                this.bitmapNeedsRedraw = true;
            }
        }

        @Override
        public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
            super.parameterChanged(param, oldValue, newValue);
            if (param == this.maxCount || param == this.paletteLength) {
                this.bitmapNeedsRedraw = true;
            }
        }

        public void drawOvalDirect(Color c, int x, int y, int width, int height) {
            VectorGraphics g = this.getTransform().getUntransformedGraphics();
            g.setColor(c);
            g.drawOval(x, y, width, height);
        }

        public void fillOvalDirect(Color c, int x, int y, int width, int height) {
            VectorGraphics g = this.getTransform().getUntransformedGraphics();
            g.setColor(c);
            g.fillOval(x, y, width, height);
        }

        @Override
        public void render(VectorGraphics g, int width, int height) {
            int i;
            VectorGraphics saveGraphics = g;
            this.getTransform().setUpDrawInfo(g, 0, 0, width, height, this.getPreserveAspect(), this.getApplyGraphics2DTransform());
            if (this.fullOSI == null || this.getTransform().getWidth() != this.fullOSI.getWidth() || this.getTransform().getHeight() != this.fullOSI.getHeight()) {
                this.bitmapNeedsRedraw = true;
                try {
                    this.createOSI(width, height);
                }
                catch (OutOfMemoryError e) {
                    saveGraphics.setColor(Color.WHITE);
                    saveGraphics.fillRect(0, 0, width, height);
                    saveGraphics.setColor(Color.RED);
                    saveGraphics.drawString(I18n.tr("vmm3d.core.OutOfMemoryError"), 20, 35);
                    return;
                }
            }
            this.prepareOSIForDrawing();
            if (this.bitmapNeedsRedraw) {
                Mandelbrot.this.drawMandelbrot(this, this.getTransform());
            }
            this.bitmapNeedsRedraw = false;
            saveGraphics.drawImage((Image)this.fullOSI, 0, 0, null);
            g.setColor(this.getForeground());
            g.setBackground(this.getBackground());
            if (this.getAntialiased()) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.getTransform().setUpDrawInfo(saveGraphics, 0, 0, width, height, this.getPreserveAspect(), this.getApplyGraphics2DTransform());
            this.currentGraphics = saveGraphics;
            Decoration[] dec = this.getDecorations();
            for (i = 0; i < dec.length; ++i) {
                dec[i].computeDrawData(this, Mandelbrot.this.exhibitNeedsRedraw, this.previousTransform, this.getTransform());
                dec[i].doDraw(saveGraphics, this, this.getTransform());
            }
            dec = Mandelbrot.this.getDecorations();
            for (i = 0; i < dec.length; ++i) {
                dec[i].computeDrawData(this, Mandelbrot.this.exhibitNeedsRedraw, this.previousTransform, this.getTransform());
                dec[i].doDraw(saveGraphics, this, this.getTransform());
            }
            this.getTransform().finishDrawing();
            this.needsRedraw = false;
        }

        @Override
        public BufferedImage getImage(boolean alwaysCopy) {
            if (this.getDisplay() == null || this.getExhibit() == null || this.fullOSI == null) {
                return null;
            }
            BufferedImage image = new BufferedImage(this.fullOSI.getWidth(), this.fullOSI.getHeight(), this.offscreenImageType);
            VectorGraphics g = (VectorGraphics)image.getGraphics();
            this.render(g, this.fullOSI.getWidth(), this.fullOSI.getHeight());
            g.dispose();
            return image;
        }

        @Override
        public void takeExhibit(View view, boolean shareTransform) {
            super.takeExhibit(view, shareTransform);
            if (shareTransform && view instanceof MandelbrotView) {
                this.maxCount.setValue(((MandelbrotView)view).maxCount.getValue());
                this.paletteLength.setValue(((MandelbrotView)view).paletteLength.getValue());
            }
        }

        @Override
        public MouseTask getDefaultMouseTask() {
            return new DragJuliaStartMouseTask();
        }

        private void fillCanvasWithGray() {
            Graphics g = this.fullOSI.getGraphics();
            g.setColor(Color.LIGHT_GRAY);
            g.fillRect(0, 0, this.fullOSI.getWidth(), this.fullOSI.getHeight());
            g.dispose();
        }

        private synchronized void pixelRow(int[] rgb, int rowNum) {
            this.fullOSI.setRGB(0, rowNum, this.fullOSI.getWidth(), 1, rgb, 0, this.fullOSI.getWidth());
        }

        private synchronized void startAsyncComputeJob(TaskManager.Job job) {
            this.asyncComputeJob = job;
            this.asyncComputeThread = new Thread(){
                TaskManager.Job myJob;
                {
                    this.myJob = MandelbrotView.this.asyncComputeJob;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!this.myJob.await(1000)) {
                        this.doRepaint();
                    }
                    MandelbrotView mandelbrotView = MandelbrotView.this;
                    synchronized (mandelbrotView) {
                        if (this.myJob == MandelbrotView.this.asyncComputeJob && !this.myJob.isCanceled()) {
                            this.doRepaint();
                            if (MandelbrotView.this.getDisplay() != null) {
                                MandelbrotView.this.getDisplay().setCursor(Cursor.getDefaultCursor());
                            }
                        }
                        if (this.myJob == MandelbrotView.this.asyncComputeJob) {
                            MandelbrotView.this.asyncComputeJob = null;
                            MandelbrotView.this.asyncComputeThread = null;
                        }
                    }
                }

                synchronized void doRepaint() {
                    if (MandelbrotView.this.getDisplay() != null) {
                        MandelbrotView.this.getDisplay().repaint();
                        try {
                            this.wait(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            };
            this.asyncComputeThread.start();
        }

        private synchronized void cancelAsyncComputeJob() {
            if (this.asyncComputeJob != null) {
                this.asyncComputeJob.cancel();
                this.asyncComputeJob = null;
                this.asyncComputeThread = null;
                if (this.getDisplay() != null) {
                    this.getDisplay().setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class ComputeRow
    implements Runnable {
        int jobNum;
        int row;
        MandelbrotView view;
        Transform transform;
        int max;
        int paletteLength;

        ComputeRow(int row, MandelbrotView view, int jobNum) {
            this.row = row;
            this.view = view;
            this.jobNum = jobNum;
            this.transform = (Transform)view.getTransform().clone();
            this.max = view.maxCount.getValue();
            this.paletteLength = view.paletteLength.getValue();
        }

        @Override
        public void run() {
            Point2D.Double pt = new Point2D.Double();
            int width = this.transform.getWidth();
            int[] rgb = new int[width];
            for (int c = 0; c < width; ++c) {
                ((Point2D)pt).setLocation(c, this.row);
                this.transform.viewportToWindow(pt);
                double x = ((Point2D)pt).getX();
                double y = ((Point2D)pt).getY();
                int ct = Mandelbrot.this.iterate(x, y, this.max);
                if (ct == this.max) {
                    rgb[c] = 0;
                    continue;
                }
                float hue = this.paletteLength > 0 ? (float)(ct % this.paletteLength) / (float)this.paletteLength : (float)ct / (float)this.max;
                rgb[c] = Color.HSBtoRGB(hue, 1.0f, 1.0f);
            }
            if (this.jobNum == this.view.asyncJobNum) {
                this.view.pixelRow(rgb, this.row);
            }
        }
    }
}

