/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core3D;

import vmm3d.core3D.Vector3D;

public class GridTransformMatrix {
    private double[][] matrix;
    private boolean reverseSurfaceOrientation;

    public GridTransformMatrix() {
        this.matrix = new double[3][4];
        this.matrix[2][2] = 1.0;
        this.matrix[1][1] = 1.0;
        this.matrix[0][0] = 1.0;
        this.reverseSurfaceOrientation = false;
    }

    public GridTransformMatrix(GridTransformMatrix m) {
        if (m == null) {
            this.matrix = new double[3][4];
            this.matrix[2][2] = 1.0;
            this.matrix[1][1] = 1.0;
            this.matrix[0][0] = 1.0;
            this.reverseSurfaceOrientation = false;
        } else {
            this.matrix = new double[3][4];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.matrix[i][j] = m.matrix[i][j];
                }
            }
            this.reverseSurfaceOrientation = m.reverseSurfaceOrientation;
        }
    }

    public static GridTransformMatrix SetGridTransformMatrix(double a0, double a1, double a2, double a3, double b0, double b1, double b2, double b3, double c0, double c1, double c2, double c3, boolean or) {
        GridTransformMatrix m = new GridTransformMatrix();
        m.matrix[0][0] = a0;
        m.matrix[0][1] = a1;
        m.matrix[0][2] = a2;
        m.matrix[0][3] = a3;
        m.matrix[1][0] = b0;
        m.matrix[1][1] = b1;
        m.matrix[1][2] = b2;
        m.matrix[1][3] = b3;
        m.matrix[2][0] = c0;
        m.matrix[2][1] = c1;
        m.matrix[2][2] = c2;
        m.matrix[2][3] = c3;
        m.reverseSurfaceOrientation = or;
        return m;
    }

    public boolean equals(Object o) {
        try {
            double[][] m = ((GridTransformMatrix)o).matrix;
            for (int r = 0; r < 3; ++r) {
                for (int c = 0; c < 4; ++c) {
                    if (m[r][c] == this.matrix[r][c]) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Vector3D apply(Vector3D vec) {
        return new Vector3D(this.matrix[0][0] * vec.x + this.matrix[0][1] * vec.y + this.matrix[0][2] * vec.z + this.matrix[0][3], this.matrix[1][0] * vec.x + this.matrix[1][1] * vec.y + this.matrix[1][2] * vec.z + this.matrix[1][3], this.matrix[2][0] * vec.x + this.matrix[2][1] * vec.y + this.matrix[2][2] * vec.z + this.matrix[2][3]);
    }

    public Vector3D applyToNormal(Vector3D N) {
        Vector3D aux = new Vector3D(this.matrix[0][0] * N.x + this.matrix[0][1] * N.y + this.matrix[0][2] * N.z, this.matrix[1][0] * N.x + this.matrix[1][1] * N.y + this.matrix[1][2] * N.z, this.matrix[2][0] * N.x + this.matrix[2][1] * N.y + this.matrix[2][2] * N.z);
        N.assign(aux);
        if (this.reverseSurfaceOrientation) {
            N.negate();
        }
        return N;
    }

    public boolean getReverseSurfaceOrientation() {
        return this.reverseSurfaceOrientation;
    }

    public GridTransformMatrix setReverseSurfaceOrientation(boolean reverseSurfaceOrientation) {
        this.reverseSurfaceOrientation = reverseSurfaceOrientation;
        return this;
    }

    public GridTransformMatrix reverse() {
        this.reverseSurfaceOrientation = !this.reverseSurfaceOrientation;
        return this;
    }

    public GridTransformMatrix scale(double s) {
        return this.scale(s, s, s);
    }

    public GridTransformMatrix scale(double sx, double sy, double sz) {
        double[] dArray = this.matrix[0];
        dArray[0] = dArray[0] * sx;
        double[] dArray2 = this.matrix[0];
        dArray2[1] = dArray2[1] * sx;
        double[] dArray3 = this.matrix[0];
        dArray3[2] = dArray3[2] * sx;
        double[] dArray4 = this.matrix[0];
        dArray4[3] = dArray4[3] * sx;
        double[] dArray5 = this.matrix[1];
        dArray5[0] = dArray5[0] * sy;
        double[] dArray6 = this.matrix[1];
        dArray6[1] = dArray6[1] * sy;
        double[] dArray7 = this.matrix[1];
        dArray7[2] = dArray7[2] * sy;
        double[] dArray8 = this.matrix[1];
        dArray8[3] = dArray8[3] * sy;
        double[] dArray9 = this.matrix[2];
        dArray9[0] = dArray9[0] * sz;
        double[] dArray10 = this.matrix[2];
        dArray10[1] = dArray10[1] * sz;
        double[] dArray11 = this.matrix[2];
        dArray11[2] = dArray11[2] * sz;
        double[] dArray12 = this.matrix[2];
        dArray12[3] = dArray12[3] * sz;
        return this;
    }

    public GridTransformMatrix translate(double tx, double ty, double tz) {
        double[] dArray = this.matrix[0];
        dArray[3] = dArray[3] + tx;
        double[] dArray2 = this.matrix[1];
        dArray2[3] = dArray2[3] + ty;
        double[] dArray3 = this.matrix[2];
        dArray3[3] = dArray3[3] + tz;
        return this;
    }

    public GridTransformMatrix translate(Vector3D v) {
        if (v != null) {
            double[] dArray = this.matrix[0];
            dArray[3] = dArray[3] + v.x;
            double[] dArray2 = this.matrix[1];
            dArray2[3] = dArray2[3] + v.y;
            double[] dArray3 = this.matrix[2];
            dArray3[3] = dArray3[3] + v.z;
        }
        return this;
    }

    public GridTransformMatrix setTranslation(Vector3D vt) {
        if (vt == null) {
            this.matrix[2][3] = 0.0;
            this.matrix[1][3] = 0.0;
            this.matrix[0][3] = 0.0;
        } else {
            this.matrix[0][3] = vt.x;
            this.matrix[1][3] = vt.y;
            this.matrix[2][3] = vt.z;
        }
        return this;
    }

    public GridTransformMatrix setTranslation(double x, double y, double z) {
        this.matrix[0][3] = x;
        this.matrix[1][3] = y;
        this.matrix[2][3] = z;
        return this;
    }

    public GridTransformMatrix rotateZ(double degrees) {
        double radians = degrees * Math.PI / 180.0;
        double c = Math.cos(radians);
        double s = Math.sin(radians);
        double a = c * this.matrix[0][0] + s * this.matrix[1][0];
        this.matrix[1][0] = -s * this.matrix[0][0] + c * this.matrix[1][0];
        this.matrix[0][0] = a;
        a = c * this.matrix[0][1] + s * this.matrix[1][1];
        this.matrix[1][1] = -s * this.matrix[0][1] + c * this.matrix[1][1];
        this.matrix[0][1] = a;
        a = c * this.matrix[0][2] + s * this.matrix[1][2];
        this.matrix[1][2] = -s * this.matrix[0][2] + c * this.matrix[1][2];
        this.matrix[0][2] = a;
        a = c * this.matrix[0][3] + s * this.matrix[1][3];
        this.matrix[1][3] = -s * this.matrix[0][3] + c * this.matrix[1][3];
        this.matrix[0][3] = a;
        return this;
    }

    public GridTransformMatrix rotateX(double degrees) {
        double radians = degrees * Math.PI / 180.0;
        double c = Math.cos(radians);
        double s = Math.sin(radians);
        double a = c * this.matrix[1][0] + s * this.matrix[2][0];
        this.matrix[2][0] = -s * this.matrix[1][0] + c * this.matrix[2][0];
        this.matrix[1][0] = a;
        a = c * this.matrix[1][1] + s * this.matrix[2][1];
        this.matrix[2][1] = -s * this.matrix[1][1] + c * this.matrix[2][1];
        this.matrix[1][1] = a;
        a = c * this.matrix[1][2] + s * this.matrix[2][2];
        this.matrix[2][2] = -s * this.matrix[1][2] + c * this.matrix[2][2];
        this.matrix[1][2] = a;
        a = c * this.matrix[1][3] + s * this.matrix[2][3];
        this.matrix[2][3] = -s * this.matrix[1][3] + c * this.matrix[2][3];
        this.matrix[1][3] = a;
        return this;
    }

    public GridTransformMatrix rotateY(double degrees) {
        double radians = degrees * Math.PI / 180.0;
        double c = Math.cos(radians);
        double s = Math.sin(radians);
        double a = c * this.matrix[2][0] + s * this.matrix[0][0];
        this.matrix[0][0] = -s * this.matrix[2][0] + c * this.matrix[0][0];
        this.matrix[2][0] = a;
        a = c * this.matrix[2][1] + s * this.matrix[0][1];
        this.matrix[0][1] = -s * this.matrix[2][1] + c * this.matrix[0][1];
        this.matrix[2][1] = a;
        a = c * this.matrix[2][2] + s * this.matrix[0][2];
        this.matrix[0][2] = -s * this.matrix[2][2] + c * this.matrix[0][2];
        this.matrix[2][2] = a;
        a = c * this.matrix[2][3] + s * this.matrix[0][3];
        this.matrix[0][3] = -s * this.matrix[2][3] + c * this.matrix[0][3];
        this.matrix[2][3] = a;
        return this;
    }

    public GridTransformMatrix leftMultiplyBy(GridTransformMatrix m) {
        double[][] newMatrix = new double[3][4];
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 4; ++c) {
                double sum = 0.0;
                for (int i = 0; i < 3; ++i) {
                    sum += m.matrix[r][i] * this.matrix[i][c];
                }
                if (c == 3) {
                    sum += m.matrix[r][3];
                }
                newMatrix[r][c] = sum;
            }
        }
        this.matrix = newMatrix;
        this.reverseSurfaceOrientation = this.reverseSurfaceOrientation != m.reverseSurfaceOrientation;
        return this;
    }
}

