/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core3D;

import java.awt.Color;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.core3D.GridTransformMatrix;
import vmm3d.core3D.PhongLighting;
import vmm3d.core3D.Transform3D;
import vmm3d.core3D.Vector3D;
import vmm3d.core3D.View3D;
import vmm3d.core3D.View3DLit;

public class Grid3D {
    private int uPatchCount;
    private int vPatchCount;
    private final int subPatchesPerPatch;
    private int uCurveIncrement;
    private int vCurveIncrement;
    private Color defaultPatchColor = Color.white;
    private Color defaultBackColor;
    private int uCount;
    private int vCount;
    private Vector3D[][] pointsOnSurface;
    private Color[][] patchColor;
    private Vector3D[][] normal;
    private Vector3D[][][] transformedData;
    private Vector3D[][][] transformedVCurves;
    private boolean subPatchesValid;
    private ArrayList<Patch> subpatches;
    private boolean patchesValid;
    private ArrayList<Patch> patches;
    private ArrayList<GridTransformMatrix> transforms;
    private boolean useIdentityTransform = true;

    public Grid3D(int uPatchCount, int vPatchCount) {
        this.subPatchesPerPatch = 6;
        this.setPatchCount(uPatchCount, vPatchCount);
        this.vCurveIncrement = 6;
        this.uCurveIncrement = 6;
    }

    public Grid3D(int uPatchCount, int vPatchCount, int subPatchesPerPatch) {
        this.subPatchesPerPatch = subPatchesPerPatch;
        this.setPatchCount(uPatchCount, vPatchCount);
        this.uCurveIncrement = this.vCurveIncrement = subPatchesPerPatch;
    }

    public void setPatchCount(int uPatchCount, int vPatchCount) {
        this.uPatchCount = uPatchCount;
        this.vPatchCount = vPatchCount;
        this.uCount = 1 + uPatchCount * this.subPatchesPerPatch;
        this.vCount = 1 + vPatchCount * this.subPatchesPerPatch;
        this.pointsOnSurface = new Vector3D[this.uCount][this.vCount];
    }

    public void addGridTransform(GridTransformMatrix transform) {
        if (transform == null) {
            return;
        }
        if (this.transforms == null) {
            this.transforms = new ArrayList();
        }
        this.transforms.add(transform);
        this.transformedVCurves = null;
        this.transformedData = this.transformedVCurves;
        this.subpatches = null;
        this.patches = null;
        this.subPatchesValid = false;
        this.patchesValid = false;
    }

    public void discardGridTransforms() {
        if (this.transforms != null) {
            this.transforms = null;
            this.transformedVCurves = null;
            this.transformedData = this.transformedVCurves;
            this.subpatches = null;
            this.patches = null;
            this.subPatchesValid = false;
            this.patchesValid = false;
        }
    }

    public boolean getUseIdentityTransform() {
        return this.useIdentityTransform;
    }

    public void setUseIdentityTransform(boolean useIdentityTransform) {
        if (useIdentityTransform != this.useIdentityTransform) {
            this.useIdentityTransform = useIdentityTransform;
            this.subpatches = null;
            this.patches = null;
            this.subPatchesValid = false;
            this.patchesValid = false;
        }
    }

    public final void setVertex(int uIndex, int vIndex, Vector3D v) {
        this.pointsOnSurface[uIndex][vIndex] = v;
    }

    public final Vector3D getVertex(int uIndex, int vIndex) {
        return this.pointsOnSurface[uIndex][vIndex];
    }

    public int getUCount() {
        return this.uCount;
    }

    public int getUPatchCount() {
        return this.uPatchCount;
    }

    public int getVCount() {
        return this.vCount;
    }

    public int getVPatchCount() {
        return this.vPatchCount;
    }

    public int getSubPatchCountInGrid() {
        return (this.uCount - 1) * (this.vCount - 1);
    }

    public int getPatchCountInGrid() {
        return this.uPatchCount * this.vPatchCount;
    }

    public int getSubPatchCountInSurface() {
        int copies = 1;
        if (this.transforms != null) {
            copies = this.transforms.size();
            if (this.useIdentityTransform) {
                ++copies;
            }
        }
        return copies * (this.uCount - 1) * (this.vCount - 1);
    }

    public int getPatchCountInSurface() {
        int copies = 1;
        if (this.transforms != null) {
            copies = this.transforms.size();
            if (this.useIdentityTransform) {
                ++copies;
            }
        }
        return copies * this.uPatchCount * this.vPatchCount;
    }

    public int getSubpatchesPerPatch() {
        return this.subPatchesPerPatch;
    }

    public int getUCurveIncrement() {
        return this.uCurveIncrement;
    }

    public void setUCurveIncrement(int curveIncrement) {
        if (curveIncrement < 0) {
            curveIncrement = 0;
        }
        this.uCurveIncrement = curveIncrement;
    }

    public int getVCurveIncrement() {
        return this.vCurveIncrement;
    }

    public void setVCurveIncrement(int curveIncrement) {
        if (curveIncrement < 0) {
            curveIncrement = 0;
        }
        this.vCurveIncrement = curveIncrement;
    }

    public void setPatchColor(int uIndex, int vIndex, Color c) {
        if (this.patchColor == null) {
            if (c == null) {
                return;
            }
            this.patchColor = new Color[this.uCount][this.vCount];
        }
        this.patchColor[uIndex][vIndex] = c;
    }

    public Color getPatchColor(int uIndex, int vIndex, boolean frontFace) {
        if (this.patchColor == null) {
            if (frontFace || this.defaultBackColor == null) {
                return this.defaultPatchColor;
            }
            return this.defaultBackColor;
        }
        Color c = this.patchColor[uIndex][vIndex];
        return c == null ? this.defaultPatchColor : c;
    }

    public void clearPatchColors() {
        this.patchColor = null;
    }

    public void setNormal(int uIndex, int vIndex, Vector3D normalVector) {
        if (this.normal == null) {
            this.normal = new Vector3D[this.uCount + 1][this.vCount + 1];
        }
        this.normal[uIndex][vIndex] = normalVector;
    }

    public Vector3D getNormal(int uIndex, int vIndex) {
        Vector3D v4;
        Vector3D v2;
        if (this.normal != null && this.normal[uIndex][vIndex] != null) {
            return new Vector3D(this.normal[uIndex][vIndex]);
        }
        Vector3D v1 = this.pointsOnSurface[uIndex][vIndex];
        if (uIndex < this.uCount && vIndex < this.vCount) {
            v2 = this.pointsOnSurface[uIndex + 1][vIndex];
            v4 = this.pointsOnSurface[uIndex][vIndex + 1];
        } else if (uIndex == this.uCount && vIndex < this.vCount) {
            v2 = this.pointsOnSurface[uIndex][vIndex + 1];
            v4 = this.pointsOnSurface[uIndex - 1][vIndex];
        } else if (uIndex < this.uCount && vIndex == this.vCount) {
            v2 = this.pointsOnSurface[uIndex][vIndex - 1];
            v4 = this.pointsOnSurface[uIndex + 1][vIndex];
        } else {
            v2 = this.pointsOnSurface[uIndex - 1][vIndex];
            v4 = this.pointsOnSurface[uIndex][vIndex - 1];
        }
        Vector3D a = v2.minus(v1);
        Vector3D b = v4.minus(v1);
        Vector3D normal = a.cross(b);
        return normal;
    }

    public Vector3D getUnitNormal(int uIndex, int vIndex) {
        Vector3D N = this.getNormal(uIndex, vIndex);
        N.normalize();
        if (Double.isInfinite(N.x) || Double.isNaN(N.x) || Double.isInfinite(N.y) || Double.isNaN(N.y) || Double.isInfinite(N.z) || Double.isNaN(N.z)) {
            N = new Vector3D(1.0, 0.0, 0.0);
        }
        return N;
    }

    public void clearNormals() {
        this.normal = null;
    }

    public void setDefaultPatchColor(Color c) {
        this.defaultPatchColor = c == null ? Color.white : c;
    }

    public Color getDefaultPatchColor() {
        return this.defaultPatchColor;
    }

    public Color getDefaultBackColor() {
        return this.defaultBackColor;
    }

    public void setDefaultBackColor(Color defaultBackColor) {
        this.defaultBackColor = defaultBackColor;
    }

    public void applyTransform(Transform3D transform, View3D view3D) {
        int copies = 1;
        if (this.transforms != null) {
            copies = this.transforms.size();
            if (this.useIdentityTransform) {
                ++copies;
            }
        }
        if (this.transformedData == null || this.transformedData.length != copies) {
            this.transformedData = new Vector3D[copies][this.uCount][this.vCount];
            this.transformedVCurves = new Vector3D[copies][this.vCount][this.uCount];
        }
        int offset = 0;
        if (this.transforms == null || this.useIdentityTransform) {
            for (int i = 0; i < this.uCount; ++i) {
                for (int j = 0; j < this.vCount; ++j) {
                    if (this.pointsOnSurface[i][j] == null || view3D.clip(this.pointsOnSurface[i][j])) {
                        this.transformedData[0][i][j] = null;
                    } else {
                        if (this.transformedData[0][i][j] == null) {
                            this.transformedData[0][i][j] = new Vector3D();
                        }
                        transform.objectToViewCoords(this.pointsOnSurface[i][j], this.transformedData[0][i][j]);
                    }
                    this.transformedVCurves[0][j][i] = this.transformedData[0][i][j];
                }
                offset = 1;
            }
        }
        if (this.transforms != null) {
            for (int copyNum = offset; copyNum < copies; ++copyNum) {
                GridTransformMatrix gridTransform = this.transforms.get(copyNum - offset);
                for (int i = 0; i < this.uCount; ++i) {
                    for (int j = 0; j < this.vCount; ++j) {
                        if (this.pointsOnSurface[i][j] == null) {
                            this.transformedData[copyNum][i][j] = null;
                        } else {
                            Vector3D gridPt = gridTransform.apply(this.pointsOnSurface[i][j]);
                            if (view3D.clip(gridPt)) {
                                this.transformedData[copyNum][i][j] = null;
                            } else {
                                if (this.transformedData[copyNum][i][j] == null) {
                                    this.transformedData[copyNum][i][j] = new Vector3D();
                                }
                                transform.objectToViewCoords(gridPt, this.transformedData[copyNum][i][j]);
                            }
                        }
                        this.transformedVCurves[copyNum][j][i] = this.transformedData[copyNum][i][j];
                    }
                }
            }
        }
        this.subPatchesValid = false;
        this.patchesValid = false;
    }

    public void drawCurves(View3D view, VectorGraphics g) {
        int i;
        int copyNum;
        int uInc = this.uCurveIncrement;
        int vInc = this.vCurveIncrement;
        if (uInc == 0 && vInc == 0) {
            uInc = vInc = this.subPatchesPerPatch;
        }
        if (uInc > 0) {
            for (copyNum = 0; copyNum < this.transformedData.length; ++copyNum) {
                for (i = 0; i < this.uCount - 1; i += uInc) {
                    this.drawCurve(this.transformedData[copyNum][i], view, g);
                }
                this.drawCurve(this.transformedData[copyNum][this.uCount - 1], view, g);
            }
        }
        if (vInc > 0) {
            for (copyNum = 0; copyNum < this.transformedVCurves.length; ++copyNum) {
                for (i = 0; i < this.vCount - 1; i += vInc) {
                    this.drawCurve(this.transformedVCurves[copyNum][i], view, g);
                }
                this.drawCurve(this.transformedVCurves[copyNum][this.vCount - 1], view, g);
            }
        }
    }

    public void drawSubPatches(View3DLit view, VectorGraphics g, double startPercent, double endPercent) {
        if (view.getNeedRecalculate()) {
            this.computeSubPatches();
        }
        this.drawPatches(this.subpatches, 1, view, view.getPhongShading(), startPercent, endPercent);
    }

    public void drawMajorPatches(View3DLit view, VectorGraphics g) {
        if (view.getNeedRecalculate()) {
            this.computeMajorPatches();
        }
        this.drawPatches(this.patches, this.subPatchesPerPatch, view, false, 0.0, 1.0);
    }

    private void computeSubPatches() {
        if (this.subpatches == null || !this.subPatchesValid) {
            if (this.subpatches == null) {
                this.subpatches = new ArrayList((this.uCount - 1) * (this.vCount - 1));
                for (int copyNum = 0; copyNum < this.transformedData.length; ++copyNum) {
                    for (int i = 0; i < this.uCount - 1; ++i) {
                        for (int j = 0; j < this.vCount - 1; ++j) {
                            this.subpatches.add(new Patch(copyNum, i, j, 1));
                        }
                    }
                }
            }
            for (int i = 0; i < this.subpatches.size(); ++i) {
                this.subpatches.get(i).compute();
            }
            Collections.sort(this.subpatches);
            this.subPatchesValid = true;
            if (this.subPatchesPerPatch == 1) {
                this.patches = this.subpatches;
                this.patchesValid = true;
            }
        }
    }

    private void computeMajorPatches() {
        if (this.patches == null || !this.patchesValid) {
            if (this.patches == null) {
                this.patches = new ArrayList(this.transformedData.length * (this.uPatchCount - 1) * (this.vPatchCount - 1));
                for (int copyNum = 0; copyNum < this.transformedData.length; ++copyNum) {
                    for (int i = 0; i < this.uCount - 1; i += this.subPatchesPerPatch) {
                        for (int j = 0; j < this.vCount - 1; j += this.subPatchesPerPatch) {
                            this.patches.add(new Patch(copyNum, i, j, this.subPatchesPerPatch));
                        }
                    }
                }
            }
            for (int i = 0; i < this.patches.size(); ++i) {
                this.patches.get(i).compute();
            }
            Collections.sort(this.patches);
            this.patchesValid = true;
            if (this.subPatchesPerPatch == 1) {
                this.subpatches = this.patches;
                this.subPatchesValid = true;
            }
        }
    }

    private void drawCurve(Vector3D[] transformedCurve, View3D view, VectorGraphics g) {
        GeneralPath curve = new GeneralPath();
        boolean previousPoint = false;
        boolean broken = false;
        for (int i = 0; i < transformedCurve.length - 1; ++i) {
            if (transformedCurve[i] != null) {
                if (!previousPoint) {
                    curve.moveTo((float)transformedCurve[i].x, (float)transformedCurve[i].y);
                } else {
                    curve.lineTo((float)transformedCurve[i].x, (float)transformedCurve[i].y);
                }
            }
            boolean bl = previousPoint = transformedCurve[i] != null;
            if (previousPoint) continue;
            broken = true;
        }
        if (!broken && transformedCurve[transformedCurve.length - 1] != null && Math.abs(transformedCurve[0].x - transformedCurve[transformedCurve.length - 1].x) < 1.0E-5 && Math.abs(transformedCurve[0].y - transformedCurve[transformedCurve.length - 1].y) < 1.0E-5) {
            curve.closePath();
        } else if (previousPoint && transformedCurve[transformedCurve.length - 1] != null) {
            curve.lineTo((float)transformedCurve[transformedCurve.length - 1].x, (float)transformedCurve[transformedCurve.length - 1].y);
        }
        g.draw((Shape)curve);
    }

    private void drawPatches(ArrayList<Patch> patches, int spacing, View3DLit view, boolean usePhongShading, double startPercent, double endPercent) {
        int validPatchCount;
        Polygon quad = new Polygon();
        Point2D.Double pt = new Point2D.Double();
        Transform3D transform = view.getTransform3D();
        VectorGraphics g = transform.getUntransformedGraphics();
        if (g == null) {
            return;
        }
        Object saveAntialiased = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        boolean viewIsAntialiased = view.getAntialiased();
        int opaqueness = (int)(255.0 * (1.0 - view.getTransparency()));
        if (startPercent < 0.0) {
            startPercent = 0.0;
        }
        if (endPercent > 1.0) {
            endPercent = 1.0;
        }
        for (validPatchCount = patches.size(); validPatchCount > 0 && patches.get(validPatchCount - 1).getMidpointZ() == Double.POSITIVE_INFINITY; --validPatchCount) {
        }
        if (validPatchCount == 0) {
            return;
        }
        int startIndex = startPercent <= 0.0 ? 0 : (int)((double)validPatchCount * startPercent);
        int endIndex = endPercent >= 1.0 ? validPatchCount : (int)((double)validPatchCount * endPercent);
        for (int i = startIndex; i < endIndex; ++i) {
            Patch patch = patches.get(i);
            if (!Double.isInfinite(patch.z)) {
                Vector3D v1 = patch.getTransformedVertex(1);
                Vector3D v2 = patch.getTransformedVertex(2);
                Vector3D v3 = patch.getTransformedVertex(3);
                Vector3D v4 = patch.getTransformedVertex(4);
                ((Point2D)pt).setLocation(v1.x, v1.y);
                transform.windowToViewport(pt);
                int x1 = (int)(((Point2D)pt).getX() + 0.4999);
                int y1 = (int)(((Point2D)pt).getY() + 0.4999);
                ((Point2D)pt).setLocation(v2.x, v2.y);
                transform.windowToViewport(pt);
                int x2 = (int)(((Point2D)pt).getX() + 0.4999);
                int y2 = (int)(((Point2D)pt).getY() + 0.4999);
                ((Point2D)pt).setLocation(v3.x, v3.y);
                transform.windowToViewport(pt);
                int x3 = (int)(((Point2D)pt).getX() + 0.4999);
                int y3 = (int)(((Point2D)pt).getY() + 0.4999);
                ((Point2D)pt).setLocation(v4.x, v4.y);
                transform.windowToViewport(pt);
                int x4 = (int)(((Point2D)pt).getX() + 0.4999);
                int y4 = (int)(((Point2D)pt).getY() + 0.4999);
                Color saveColor = g.getColor();
                Color c = this.computeColorForPatch(patch, view);
                if (opaqueness < 255) {
                    c = new Color(c.getRed(), c.getGreen(), c.getBlue(), opaqueness);
                }
                g.setColor(c);
                quad.reset();
                quad.addPoint(x1, y1);
                quad.addPoint(x2, y2);
                quad.addPoint(x3, y3);
                quad.addPoint(x4, y4);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.fillPolygon(quad);
                if (viewIsAntialiased) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                g.setColor(view.getViewStyle() == 1 ? Color.white : Color.black);
                if (this.uCurveIncrement > 0) {
                    if (patch.uIndex % this.uCurveIncrement == 0) {
                        g.drawLine(x1, y1, x4, y4);
                    }
                    if ((patch.uIndex + spacing) % this.uCurveIncrement == 0 || patch.uIndex + spacing >= this.uCount - 1) {
                        g.drawLine(x2, y2, x3, y3);
                    }
                }
                if (this.vCurveIncrement > 0) {
                    if (patch.vIndex % this.vCurveIncrement == 0) {
                        g.drawLine(x1, y1, x2, y2);
                    }
                    if ((patch.vIndex + spacing) % this.vCurveIncrement == 0 || patch.vIndex + spacing >= this.vCount - 1) {
                        g.drawLine(x4, y4, x3, y3);
                    }
                }
                g.setColor(saveColor);
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, saveAntialiased);
        }
    }

    private Color computeColorForPatch(Patch patch, View3DLit view) {
        boolean frontFace;
        Vector3D viewDirection = view.getTransform3D().getViewDirection();
        Vector3D v1 = patch.getVertex(1);
        Vector3D v2 = patch.getVertex(2);
        Vector3D v3 = patch.getVertex(3);
        Vector3D v4 = patch.getVertex(4);
        Vector3D patchCG = v1.plus(v2.plus(v3.plus(v4))).times(0.25);
        Vector3D normal = patch.getUnitNormal();
        if (view.getOrientation() == 2) {
            frontFace = true;
        } else {
            if (view.getOrthographicProjection()) {
                frontFace = normal.dot(viewDirection) > 0.0;
            } else {
                boolean bl = frontFace = normal.dot(patchCG.minus(view.getTransform3D().getViewPoint())) > 0.0;
            }
            if (view.getOrientation() == 1) {
                frontFace = !frontFace;
            }
        }
        Color intrinsicColor = this.getPatchColor(patch.uIndex, patch.vIndex, frontFace);
        if (view.getLightingEnabled()) {
            return PhongLighting.phongLightingColor(normal, view, view.getTransform3D(), patchCG, intrinsicColor);
        }
        return intrinsicColor;
    }

    private class Patch
    implements Comparable<Patch> {
        private int copyNum;
        private GridTransformMatrix gridTransform;
        private int uIndex;
        private int vIndex;
        private int size;
        private double z;

        private Patch(int copyNum, int uIndex, int vIndex, int size) {
            this.copyNum = copyNum;
            this.uIndex = uIndex;
            this.vIndex = vIndex;
            this.size = size;
            if (Grid3D.this.transforms != null && (copyNum > 0 || copyNum == 0 && !Grid3D.this.useIdentityTransform)) {
                this.gridTransform = Grid3D.this.useIdentityTransform ? (GridTransformMatrix)Grid3D.this.transforms.get(copyNum - 1) : (GridTransformMatrix)Grid3D.this.transforms.get(copyNum);
            }
        }

        public Vector3D getVertex(int i) {
            Vector3D pt;
            switch (i) {
                case 1: {
                    pt = Grid3D.this.pointsOnSurface[this.uIndex][this.vIndex];
                    break;
                }
                case 2: {
                    pt = Grid3D.this.pointsOnSurface[this.uIndex + this.size][this.vIndex];
                    break;
                }
                case 3: {
                    pt = Grid3D.this.pointsOnSurface[this.uIndex + this.size][this.vIndex + this.size];
                    break;
                }
                case 4: {
                    pt = Grid3D.this.pointsOnSurface[this.uIndex][this.vIndex + this.size];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal vertex number \"" + i + "\" for patch; must be 1, 2, 3, or 4.");
                }
            }
            if (pt == null || this.gridTransform == null) {
                return pt;
            }
            return this.gridTransform.apply(pt);
        }

        public Vector3D getTransformedVertex(int i) {
            switch (i) {
                case 1: {
                    return Grid3D.this.transformedData[this.copyNum][this.uIndex][this.vIndex];
                }
                case 2: {
                    return Grid3D.this.transformedData[this.copyNum][this.uIndex + this.size][this.vIndex];
                }
                case 3: {
                    return Grid3D.this.transformedData[this.copyNum][this.uIndex + this.size][this.vIndex + this.size];
                }
                case 4: {
                    return Grid3D.this.transformedData[this.copyNum][this.uIndex][this.vIndex + this.size];
                }
            }
            throw new IllegalArgumentException("Illegal vertex number \"" + i + "\" for patch; must be 1, 2, 3, or 4.");
        }

        private void compute() {
            Vector3D v1 = this.getTransformedVertex(1);
            Vector3D v2 = this.getTransformedVertex(2);
            Vector3D v3 = this.getTransformedVertex(3);
            Vector3D v4 = this.getTransformedVertex(4);
            if (v1 == null || v2 == null || v3 == null || v4 == null) {
                this.z = Double.POSITIVE_INFINITY;
            } else {
                this.z = (v1.z + v2.z + v3.z + v4.z) / 4.0;
                if (Double.isInfinite(this.z)) {
                    this.z = Double.POSITIVE_INFINITY;
                }
            }
        }

        public double getMidpointZ() {
            return this.z;
        }

        public Vector3D getUnitNormal() {
            Vector3D N = Grid3D.this.getUnitNormal(this.uIndex, this.vIndex);
            if (this.gridTransform != null) {
                N = this.gridTransform.applyToNormal(N);
            }
            return N;
        }

        @Override
        public int compareTo(Patch p) {
            if (this.z > p.z) {
                return 1;
            }
            if (this.z == p.z) {
                return 0;
            }
            return -1;
        }
    }
}

