/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm3d.core.Animation;
import vmm3d.core.Display;
import vmm3d.core.Filmstrip;

public abstract class TimerAnimation
implements Animation {
    public static final int ONCE = 0;
    public static final int LOOP = 1;
    public static final int OSCILLATE = 2;
    private int looping = 0;
    private Timer timer;
    private int frames;
    private int millisecondsPerFrame;
    private int initialDelay;
    private boolean forward;
    private ArrayList<ChangeListener> changeListeners;
    private ChangeEvent changeEvent;
    private boolean fireFrameEvents;
    private boolean paused;
    private Filmstrip filmstrip;
    protected Display display;
    protected double timeDilation;
    protected int frameNumber;

    protected abstract void drawFrame();

    public TimerAnimation() {
        this(-1, 50, false);
    }

    public TimerAnimation(int frames, int millisecondsPerFrame) {
        this(frames, millisecondsPerFrame, false);
    }

    public TimerAnimation(int frames, int millisecondsPerFrame, boolean createFilmstrip) {
        if (frames <= 0) {
            frames = -1;
        }
        this.frames = frames;
        if (millisecondsPerFrame > 0) {
            this.millisecondsPerFrame = millisecondsPerFrame;
        }
        if (createFilmstrip) {
            this.filmstrip = new Filmstrip();
        }
    }

    public boolean getUseFilmstrip() {
        return this.filmstrip != null;
    }

    public void setUseFilmstrip(boolean useFilmstrip) {
        if (useFilmstrip != (this.filmstrip != null)) {
            this.filmstrip = useFilmstrip ? new Filmstrip() : null;
        }
    }

    public Filmstrip getFilmstrip() {
        return this.filmstrip;
    }

    public BufferedImage getFilmstripFrameImage() {
        if (this.filmstrip != null && this.filmstrip.getFrameCount() > this.frameNumber) {
            return this.filmstrip.getFrame(this.frameNumber);
        }
        return null;
    }

    void saveCurrentFrame(BufferedImage image) {
        if (this.frameNumber >= 0 && (this.frames <= 0 || this.frameNumber <= this.frames)) {
            this.filmstrip.setFrame(this.frameNumber, image);
        }
    }

    BufferedImage getCurrentFilmstripFrame() {
        if (this.filmstrip != null && this.frameNumber >= 0 && this.frameNumber < this.filmstrip.getFrameCount()) {
            return this.filmstrip.getFrame(this.frameNumber);
        }
        return null;
    }

    void setDisplay(Display d) {
        this.display = d;
    }

    void setFilmstrip(Filmstrip f) {
        this.filmstrip = f;
        if (f != null) {
            this.setFrames(f.getFrameCount() - 1);
        }
    }

    public void setLooping(int loopingMode) {
        if (loopingMode >= 0 && loopingMode <= 2) {
            this.looping = loopingMode;
            if (loopingMode != 2) {
                this.forward = true;
            }
        }
    }

    public int getLooping() {
        return this.looping;
    }

    public int getFrames() {
        return this.frames;
    }

    public void setFrames(int frames) {
        if (frames <= 0) {
            frames = -1;
        }
        this.frames = frames;
        if (frames <= 0) {
            this.setLooping(0);
        }
    }

    public boolean getFireFrameEvents() {
        return this.fireFrameEvents;
    }

    public void setFireFrameEvents(boolean fireFrameEvents) {
        this.fireFrameEvents = fireFrameEvents;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(int initialDelayInMilliseconds) {
        if (initialDelayInMilliseconds >= 0) {
            this.initialDelay = initialDelayInMilliseconds;
        }
    }

    public int getMillisecondsPerFrame() {
        return this.millisecondsPerFrame;
    }

    public void setMillisecondsPerFrame(int millisecondsPerFrame) {
        if (millisecondsPerFrame > 0) {
            this.millisecondsPerFrame = millisecondsPerFrame;
            if (this.timer != null) {
                this.timer.setDelay(this.applyDilation(millisecondsPerFrame));
            }
        }
    }

    @Override
    public void setPaused(boolean paused) {
        if (this.timer == null || this.paused == paused) {
            return;
        }
        this.paused = paused;
        if (paused) {
            this.timer.stop();
        } else {
            this.timer.setInitialDelay(0);
            this.timer.restart();
        }
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public synchronized void setTimeDilation(double dilationFactor) {
        if (dilationFactor < 0.0) {
            dilationFactor = 0.0;
        }
        if (dilationFactor != this.timeDilation) {
            this.timeDilation = dilationFactor;
            if (this.timer != null) {
                this.timer.setDelay(this.applyDilation(this.millisecondsPerFrame));
            }
        }
    }

    @Override
    public double getTimeDilation() {
        return this.timeDilation;
    }

    private int applyDilation(int milliseconds) {
        int x = (int)((double)milliseconds * this.timeDilation + 0.49);
        if (milliseconds > 0 && x == 0) {
            return 1;
        }
        return x;
    }

    @Override
    public synchronized void start() {
        if (this.timer != null) {
            return;
        }
        this.timer = new Timer(this.applyDilation(this.millisecondsPerFrame), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimerAnimation.this.nextFrame(evt);
            }
        });
        this.timer.setInitialDelay(this.applyDilation(this.initialDelay));
        this.frameNumber = -1;
        this.forward = true;
        this.paused = false;
        this.animationStarting();
        this.fireAnimationChangeEvent();
        this.timer.start();
    }

    protected synchronized void nextFrame(ActionEvent evt) {
        if (this.timer != evt.getSource()) {
            return;
        }
        this.frameNumber = this.forward ? ++this.frameNumber : --this.frameNumber;
        switch (this.looping) {
            case 0: {
                if (this.frames <= 0 || this.frameNumber <= this.frames) break;
                this.cancel();
                return;
            }
            case 1: {
                if (this.frameNumber <= this.frames) break;
                this.frameNumber = 1;
                break;
            }
            case 2: {
                if (this.frameNumber > this.frames) {
                    this.forward = false;
                    this.frameNumber = this.frames - 1;
                    break;
                }
                if (this.frameNumber >= 0) break;
                this.forward = true;
                this.frameNumber = 1;
            }
        }
        if (this.timer != null) {
            if (this.filmstrip != null && this.filmstrip.getFrameCount() > this.frameNumber && this.filmstrip.getFrame(this.frameNumber) != null && this.display != null) {
                this.display.repaint();
            } else {
                this.drawFrame();
            }
            if (this.fireFrameEvents) {
                this.fireAnimationChangeEvent();
            }
            Thread.yield();
        }
    }

    @Override
    public synchronized void cancel() {
        if (this.timer != null) {
            this.timer.stop();
            this.animationEnding();
            this.timer = null;
            this.paused = false;
            this.fireAnimationChangeEvent();
        }
    }

    protected void animationStarting() {
    }

    protected void animationEnding() {
    }

    @Override
    public synchronized boolean isRunning() {
        return this.timer != null;
    }

    @Override
    public synchronized void addChangeListener(ChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        this.changeListeners.add(listener);
    }

    @Override
    public synchronized void removeChangeListener(ChangeListener listener) {
        if (listener != null && this.changeListeners != null) {
            this.changeListeners.remove(listener);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    protected synchronized void fireAnimationChangeEvent() {
        if (this.changeListeners == null) {
            return;
        }
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            this.changeListeners.get(i).stateChanged(this.changeEvent);
        }
    }

    @Override
    public String getStatusText(boolean running) {
        return null;
    }
}

