/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.conformalmap;

import java.awt.Color;
import java.awt.geom.Point2D;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.conformalmap.ConformalMap;
import vmm3d.core.Complex;
import vmm3d.core.Decoration;
import vmm3d.core.Transform;
import vmm3d.core.VMMSave;
import vmm3d.core.View;
import vmm3d.core3D.Vector3D;
import vmm3d.core3D.View3D;

@VMMSave
public class ConformalMapFigure
extends Decoration {
    public static final int LINE_SEGMENT = 0;
    public static final int LINE = 1;
    public static final int CIRCLE = 2;
    public static final int DEFAULT_POINTS_ON_CIRCLE = 256;
    public static final int DEFAULT_POINTS_ON_SEGMENT = 250;
    public static final int DEFAULT_POINTS_ON_LINE = 500;
    @VMMSave
    private int shape = 0;
    @VMMSave
    private Color color;
    private Complex[] arguments;
    private Complex[] values;
    @VMMSave
    private Point2D p1;
    @VMMSave
    private Point2D p2;
    @VMMSave
    private int pointCount;

    public ConformalMapFigure() {
    }

    public ConformalMapFigure(Point2D p1, Point2D p2, int shape) {
        this(p1, p2, shape, 0);
    }

    public ConformalMapFigure(Point2D p1, Point2D p2, int shape, int pointCount) {
        this.setShape(shape);
        this.setPointCount(pointCount);
        this.p1 = p1;
        this.p2 = p2;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.fireDecorationChangeEvent();
    }

    public Point2D getP1() {
        return this.p1;
    }

    public void setP1(Point2D p1) {
        this.p1 = p1;
        this.fireDecorationChangeEvent();
    }

    public Point2D getP2() {
        return this.p2;
    }

    public void setP2(Point2D p2) {
        this.p2 = p2;
        this.fireDecorationChangeEvent();
    }

    public int getShape() {
        return this.shape;
    }

    public void setShape(int shape) {
        if (shape != 0 && shape != 1 && shape != 2) {
            return;
        }
        this.shape = shape;
        this.fireDecorationChangeEvent();
    }

    public int getPointCount() {
        return this.pointCount;
    }

    public void setPointCount(int pointCount) {
        if (pointCount < 2) {
            switch (this.shape) {
                case 2: {
                    pointCount = 256;
                    break;
                }
                case 1: {
                    pointCount = 500;
                    break;
                }
                default: {
                    pointCount = 250;
                }
            }
        }
        this.pointCount = pointCount;
    }

    @Override
    public void computeDrawData(View view, boolean exhibitNeedsRedraw, Transform previousTransform, Transform newTransform) {
        if (this.p1 == null || this.p2 == null) {
            return;
        }
        ConformalMap cm = (ConformalMap)view.getExhibit();
        if (this.values == null || exhibitNeedsRedraw) {
            switch (this.shape) {
                case 0: {
                    this.arguments = new Complex[2];
                    this.arguments[0] = new Complex(this.p1.getX(), this.p1.getY());
                    this.arguments[1] = new Complex(this.p2.getX(), this.p2.getY());
                    if (this.values == null) {
                        this.values = new Complex[this.pointCount];
                    }
                    Complex dz = this.arguments[1].minus(this.arguments[0]).dividedBy(this.pointCount - 1);
                    for (int i = 0; i < this.pointCount; ++i) {
                        Complex arg = this.arguments[0].plus(dz.times(i));
                        this.values[i] = cm.composedFunction(arg);
                    }
                    break;
                }
                case 1: {
                    double xmn = newTransform.getXmin();
                    double xmx = newTransform.getXmax();
                    double ymn = newTransform.getYmin();
                    double ymx = newTransform.getYmax();
                    double bigDim = Math.abs(xmx - xmn) + Math.abs(ymx - ymn);
                    double dx = this.p2.getX() - this.p1.getX();
                    double dy = this.p2.getY() - this.p1.getY();
                    double lngth = Math.sqrt(dx * dx + dy * dy);
                    this.arguments = new Complex[2];
                    this.arguments[0] = new Complex(this.p1.getX() - 2.0 * bigDim * (dx /= lngth), this.p1.getY() - 2.0 * bigDim * (dy /= lngth));
                    this.arguments[1] = new Complex(this.p2.getX() + 2.0 * bigDim * dx, this.p2.getY() + 2.0 * bigDim * dy);
                    if (this.values == null) {
                        this.values = new Complex[this.pointCount];
                    }
                    Complex dw = this.arguments[1].minus(this.arguments[0]).dividedBy(this.pointCount - 1);
                    for (int i = 0; i < this.values.length; ++i) {
                        Complex arg = this.arguments[0].plus(dw.times(i));
                        this.values[i] = cm.composedFunction(arg);
                    }
                    break;
                }
                case 2: {
                    int i;
                    double radius = Math.sqrt((this.p1.getX() - this.p2.getX()) * (this.p1.getX() - this.p2.getX()) + (this.p1.getY() - this.p2.getY()) * (this.p1.getY() - this.p2.getY()));
                    this.arguments = new Complex[this.pointCount];
                    double dtheta = Math.PI * 2 / (double)this.pointCount;
                    for (i = 0; i < this.pointCount; ++i) {
                        this.arguments[i] = new Complex(this.p1.getX() + radius * Math.cos((double)i * dtheta), this.p1.getY() + radius * Math.sin((double)i * dtheta));
                    }
                    if (this.values == null) {
                        this.values = new Complex[this.pointCount];
                    }
                    for (i = 0; i <= this.pointCount - 1; ++i) {
                        this.values[i] = cm.composedFunction(this.arguments[i]);
                    }
                    break;
                }
            }
        }
    }

    private void whereToDraw(ConformalMap.ConformalMapView cmView, Complex p1, Complex p2) {
        if (cmView.getUse3D()) {
            Vector3D V2;
            Vector3D V1;
            if (p1.abs2() > 100000.0) {
                V1 = new Vector3D(0.0, 0.0, 1.0);
            } else {
                double[] v1 = p1.stereographicProjection();
                V1 = new Vector3D(v1[0], v1[1], v1[2]);
            }
            if (p2.abs2() > 100000.0) {
                V2 = new Vector3D(0.0, 0.0, 1.0);
            } else {
                double[] v2 = p2.stereographicProjection();
                V2 = new Vector3D(v2[0], v2[1], v2[2]);
            }
            cmView.drawLine(V1, V2);
        } else if (p1.abs2() + p2.abs2() < 1000000.0) {
            cmView.drawLine(p1.re, p1.im, p2.re, p2.im);
        }
    }

    @Override
    public void doDraw(VectorGraphics g, View view, Transform transform) {
        if (this.p1 == null || this.p2 == null) {
            return;
        }
        ConformalMap.ConformalMapView cmView = (ConformalMap.ConformalMapView)view;
        Color saveColor = g.getColor();
        Color colorToUse = this.color;
        if (colorToUse == null) {
            colorToUse = view.getForeground();
        }
        g.setColor(((View3D)view).getViewStyle() == 1 ? Color.WHITE : this.color);
        switch (this.shape) {
            case 0: {
                if (cmView.getDrawValueGrid()) {
                    for (int i = 0; i < this.pointCount - 1; ++i) {
                        this.whereToDraw(cmView, this.values[i], this.values[i + 1]);
                    }
                    break;
                }
                view.drawLine(this.arguments[0].re, this.arguments[0].im, this.arguments[1].re, this.arguments[1].im);
                break;
            }
            case 1: {
                if (cmView.getDrawValueGrid()) {
                    for (int i = 0; i < this.values.length - 1; ++i) {
                        this.whereToDraw(cmView, this.values[i], this.values[i + 1]);
                    }
                    break;
                }
                view.drawLine(this.arguments[0].re, this.arguments[0].im, this.arguments[1].re, this.arguments[1].im);
                break;
            }
            case 2: {
                if (cmView.getDrawValueGrid()) {
                    for (int i = 0; i < this.pointCount - 1; ++i) {
                        this.whereToDraw(cmView, this.values[i], this.values[i + 1]);
                    }
                    this.whereToDraw(cmView, this.values[this.pointCount - 1], this.values[0]);
                    break;
                }
                for (int i = 0; i < this.pointCount - 1; ++i) {
                    view.drawLine(this.arguments[i].re, this.arguments[i].im, this.arguments[i + 1].re, this.arguments[i + 1].im);
                }
                view.drawLine(this.arguments[this.pointCount - 1].re, this.arguments[this.pointCount - 1].im, this.arguments[0].re, this.arguments[0].im);
            }
        }
        g.setColor(saveColor);
    }
}

