/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import vmm3d.actions.ActionItem;

public class ActionRadioGroup
implements ActionItem {
    private ArrayList<AbstractAction> actions;
    private int selectedIndex;
    private boolean enabled = true;

    public ActionRadioGroup() {
        this(null, -1);
    }

    public ActionRadioGroup(String[] actionNames) {
        this(actionNames, -1);
    }

    public ActionRadioGroup(String[] actionNames, int selectedIndex) {
        if (actionNames == null || selectedIndex < 0 || selectedIndex >= actionNames.length || actionNames[selectedIndex] == null) {
            selectedIndex = -1;
        }
        this.actions = new ArrayList();
        if (actionNames != null) {
            for (int i = 0; i < actionNames.length; ++i) {
                this.addItem(actionNames[i]);
            }
        }
        this.selectedIndex = -1;
        this.setSelectedIndex(selectedIndex);
    }

    public void optionSelected(int selectedIndex) {
    }

    public JRadioButtonMenuItem[] createRadioButtonMenuItems() {
        JRadioButtonMenuItem[] items = new JRadioButtonMenuItem[this.actions.size()];
        for (int i = 0; i < items.length; ++i) {
            if (this.actions.get(i) == null) continue;
            items[i] = new ActionRadioButtonMenuItem(i);
        }
        return items;
    }

    public JRadioButton[] createRadioButtons() {
        JRadioButton[] items = new JRadioButton[this.actions.size()];
        for (int i = 0; i < items.length; ++i) {
            if (this.actions.get(i) == null) continue;
            items[i] = new ActionRadioButton(i);
        }
        return items;
    }

    public int addItem(String itemName) {
        if (itemName == null) {
            this.actions.add(null);
        } else {
            final int index = this.actions.size();
            AbstractAction action = new AbstractAction(itemName){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ActionRadioGroup.this.setSelectedIndex(index);
                    ActionRadioGroup.this.optionSelected(index);
                }
            };
            action.putValue("RadioState", new Boolean(false));
            action.setEnabled(this.enabled);
            this.actions.add(action);
        }
        return this.actions.size() - 1;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int index) {
        if (index < 0 || index >= this.actions.size() || this.actions.get(index) == null) {
            index = -1;
        }
        if (this.selectedIndex >= 0) {
            this.actions.get(this.selectedIndex).putValue("RadioState", new Boolean(false));
        }
        if (index >= 0) {
            this.actions.get(index).putValue("RadioState", new Boolean(true));
        }
        this.selectedIndex = index;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            for (int i = 0; i < this.actions.size(); ++i) {
                this.actions.get(i).setEnabled(enabled);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public JMenuItem[] getMenuItems() {
        return this.createRadioButtonMenuItems();
    }

    public int getItemCount() {
        return this.actions.size();
    }

    private class ActionRadioButton
    extends JRadioButton
    implements PropertyChangeListener {
        ActionRadioButton(int index) {
            super((Action)ActionRadioGroup.this.actions.get(index));
            AbstractAction action = (AbstractAction)ActionRadioGroup.this.actions.get(index);
            this.setSelected((Boolean)action.getValue("RadioState"));
            action.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("RadioState")) {
                boolean newState = (Boolean)evt.getNewValue();
                if (this.isSelected() != newState) {
                    this.setSelected(newState);
                }
            }
        }
    }

    private class ActionRadioButtonMenuItem
    extends JRadioButtonMenuItem
    implements PropertyChangeListener {
        ActionRadioButtonMenuItem(int index) {
            super((Action)ActionRadioGroup.this.actions.get(index));
            AbstractAction action = (AbstractAction)ActionRadioGroup.this.actions.get(index);
            this.setSelected((Boolean)action.getValue("RadioState"));
            action.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("RadioState")) {
                boolean newState = (Boolean)evt.getNewValue();
                if (this.isSelected() != newState) {
                    this.setSelected(newState);
                }
            }
        }
    }
}

