/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.circulinear.CirculinearRing2D;
import math.geom2d.circulinear.GenericCirculinearDomain2D;
import math.geom2d.circulinear.GenericCirculinearRing2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.line.LineSegment2D;
import math.geom2d.polygon.LinearCurve2D;
import math.geom2d.polygon.Polygons2D;
import math.geom2d.polygon.Polyline2D;
import math.geom2d.polygon.Polylines2D;
import math.geom2d.transform.CircleInversion2D;

public class LinearRing2D
extends LinearCurve2D
implements CirculinearRing2D {
    public static LinearRing2D create(Collection<? extends Point2D> points) {
        return new LinearRing2D(points);
    }

    public static LinearRing2D create(Point2D ... vertices) {
        return new LinearRing2D(vertices);
    }

    public LinearRing2D() {
    }

    public LinearRing2D(int n) {
        super(n);
    }

    public LinearRing2D(Point2D ... vertices) {
        super(vertices);
    }

    public LinearRing2D(double[] xcoords, double[] ycoords) {
        super(xcoords, ycoords);
    }

    public LinearRing2D(Collection<? extends Point2D> points) {
        super(points);
    }

    public LinearRing2D(LinearCurve2D lineString) {
        super(lineString.vertices);
    }

    public double area() {
        Point2D prev = (Point2D)this.vertices.get(this.vertices.size() - 1);
        double area = 0.0;
        for (Point2D point : this.vertices) {
            area += prev.x() * point.y() - prev.y() * point.x();
            prev = point;
        }
        return area /= 2.0;
    }

    @Override
    public LinearRing2D simplify(double distMax) {
        return new LinearRing2D(Polylines2D.simplifyClosedPolyline(this.vertices, distMax));
    }

    @Override
    public Collection<LineSegment2D> edges() {
        int n = this.vertices.size();
        ArrayList<LineSegment2D> edges = new ArrayList<LineSegment2D>(n);
        if (n < 2) {
            return edges;
        }
        for (int i = 0; i < n - 1; ++i) {
            edges.add(new LineSegment2D((Point2D)this.vertices.get(i), (Point2D)this.vertices.get(i + 1)));
        }
        Point2D p0 = (Point2D)this.vertices.get(0);
        Point2D pn = (Point2D)this.vertices.get(n - 1);
        if (pn.distance(p0) > 1.0E-12) {
            edges.add(new LineSegment2D(pn, p0));
        }
        return edges;
    }

    @Override
    public int edgeNumber() {
        int n = this.vertices.size();
        if (n > 1) {
            return n;
        }
        return 0;
    }

    @Override
    public LineSegment2D edge(int index) {
        int i2 = (index + 1) % this.vertices.size();
        return new LineSegment2D((Point2D)this.vertices.get(index), (Point2D)this.vertices.get(i2));
    }

    @Override
    public LineSegment2D lastEdge() {
        int n = this.vertices.size();
        if (n < 2) {
            return null;
        }
        return new LineSegment2D((Point2D)this.vertices.get(n - 1), (Point2D)this.vertices.get(0));
    }

    @Override
    public CirculinearRing2D parallel(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return (CirculinearRing2D)((Object)GenericCirculinearRing2D.create(bc.createContinuousParallel(this, dist).smoothPieces()));
    }

    @Override
    public CirculinearRing2D transform(CircleInversion2D inv) {
        Collection<LineSegment2D> edges = this.edges();
        ArrayList<CirculinearElement2D> arcs = new ArrayList<CirculinearElement2D>(edges.size());
        for (LineSegment2D edge : edges) {
            arcs.add(edge.transform(inv));
        }
        return new GenericCirculinearRing2D((Collection<? extends CirculinearElement2D>)arcs);
    }

    @Override
    public CirculinearDomain2D domain() {
        return new GenericCirculinearDomain2D(this);
    }

    @Override
    public void fill(Graphics2D g2) {
        g2.fill(this.asGeneralPath());
    }

    @Override
    public double windingAngle(Point2D point) {
        int wn = Polygons2D.windingNumber(this.vertices, point);
        return (double)(wn * 2) * Math.PI;
    }

    public boolean isInside(double x, double y) {
        return this.isInside(new Point2D(x, y));
    }

    @Override
    public boolean isInside(Point2D point) {
        if (this.contains(point)) {
            return true;
        }
        double area = this.area();
        int winding = Polygons2D.windingNumber(this.vertices, point);
        if (area > 0.0) {
            return winding == 1;
        }
        return winding == 0;
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public Point2D point(double t) {
        double t0 = this.t0();
        double t1 = this.t1();
        t = Math.max(Math.min(t, t1), t0);
        int n = this.vertices.size();
        int ind0 = (int)Math.floor(t + 1.0E-12);
        double tl = t - (double)ind0;
        if (ind0 == n) {
            ind0 = 0;
        }
        Point2D p0 = (Point2D)this.vertices.get(ind0);
        if (Math.abs(t - (double)ind0) < 1.0E-12) {
            return p0;
        }
        int ind1 = ind0 + 1;
        if (ind1 == n) {
            ind1 = 0;
        }
        Point2D p1 = (Point2D)this.vertices.get(ind1);
        double x0 = p0.x();
        double y0 = p0.y();
        double dx = p1.x() - x0;
        double dy = p1.y() - y0;
        return new Point2D(x0 + tl * dx, y0 + tl * dy);
    }

    @Override
    public double t1() {
        return this.vertices.size();
    }

    @Override
    @Deprecated
    public double getT1() {
        return this.t1();
    }

    @Override
    public Point2D lastPoint() {
        if (this.vertices.size() == 0) {
            return null;
        }
        return (Point2D)this.vertices.get(0);
    }

    public Collection<? extends LinearRing2D> continuousCurves() {
        return LinearRing2D.wrapCurve(this);
    }

    @Override
    public LinearRing2D reverse() {
        Point2D[] points2 = new Point2D[this.vertices.size()];
        int n = this.vertices.size();
        if (n > 0) {
            points2[0] = (Point2D)this.vertices.get(0);
        }
        for (int i = 1; i < n; ++i) {
            points2[i] = (Point2D)this.vertices.get(n - i);
        }
        return new LinearRing2D(points2);
    }

    @Override
    public Polyline2D subCurve(double t0, double t1) {
        int ind1;
        Polyline2D res = new Polyline2D();
        int indMax = this.vertexNumber();
        t0 = Math.min(Math.max(t0, 0.0), (double)indMax);
        t1 = Math.min(Math.max(t1, 0.0), (double)indMax);
        int ind0 = (int)Math.floor(t0 + 1.0E-12);
        if (ind0 == (ind1 = (int)Math.floor(t1 + 1.0E-12)) && t0 < t1) {
            res.addVertex(this.point(t0));
            res.addVertex(this.point(t1));
            return res;
        }
        res.addVertex(this.point(t0));
        if (ind1 > ind0) {
            for (int n = ind0 + 1; n <= ind1; ++n) {
                res.addVertex((Point2D)this.vertices.get(n));
            }
        } else {
            int n;
            for (n = ind0 + 1; n < indMax; ++n) {
                res.addVertex((Point2D)this.vertices.get(n));
            }
            for (n = 0; n <= ind1; ++n) {
                res.addVertex((Point2D)this.vertices.get(n));
            }
        }
        res.addVertex(this.point(t1));
        return res;
    }

    @Override
    public LinearRing2D transform(AffineTransform2D trans) {
        Point2D[] pts = new Point2D[this.vertices.size()];
        for (int i = 0; i < this.vertices.size(); ++i) {
            pts[i] = trans.transform((Point2D)this.vertices.get(i));
        }
        return new LinearRing2D(pts);
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        if (this.vertices.size() < 2) {
            return path;
        }
        Point2D p0 = this.lastPoint();
        path.moveTo((float)p0.x(), (float)p0.y());
        for (Point2D point : this.vertices) {
            path.lineTo((float)point.x(), (float)point.y());
        }
        path.closePath();
        return path;
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LinearRing2D)) {
            return false;
        }
        LinearRing2D ring = (LinearRing2D)obj;
        if (this.vertices.size() != ring.vertices.size()) {
            return false;
        }
        for (int i = 0; i < this.vertices.size(); ++i) {
            if (((Point2D)this.vertices.get(i)).almostEquals((GeometricObject2D)ring.vertices.get(i), eps)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LinearRing2D)) {
            return false;
        }
        LinearRing2D ring = (LinearRing2D)object;
        if (this.vertices.size() != ring.vertices.size()) {
            return false;
        }
        for (int i = 0; i < this.vertices.size(); ++i) {
            if (((Point2D)this.vertices.get(i)).equals(ring.vertices.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public LinearRing2D clone() {
        ArrayList<Point2D> array = new ArrayList<Point2D>(this.vertices.size());
        for (Point2D point : this.vertices) {
            array.add(point);
        }
        return new LinearRing2D(array);
    }
}

