/*
 * Decompiled with CFR 0.152.
 */
package jhpro.upropog;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import jhplot.FNon;
import jhplot.H1D;
import jhplot.P0D;
import jhplot.stat.Statistics;

public class UPropogate {
    private double error;
    private double[] vec;

    public UPropogate(FNon f, double[] par, double[] par_err, double[] var, double[] var_err, int NTOT) {
        if (NTOT <= 0) {
            System.err.println("Number of Monte Carlo events cannot be zero or negative");
            return;
        }
        if (f.dimension() != var.length) {
            System.err.println("Dimension of the input function is different than the dimension of input values");
            return;
        }
        if (f.dimension() != var_err.length) {
            System.err.println("Dimension of the input function is different than the dimension of input errors on values");
            return;
        }
        if (f.dimension() != var.length) {
            System.err.println("Dimension of the input function is different than the dimension of input values");
            return;
        }
        if (f.numberOfParameters() != par.length) {
            System.err.println("Number of  parameters is different than the dimension of input parameters");
            return;
        }
        if (f.numberOfParameters() != par_err.length) {
            System.err.println("Number of  parameters is different than the dimension of input parameter errors");
            return;
        }
        Random rdm = new Random();
        this.vec = new double[NTOT];
        for (int i = 0; i < NTOT; ++i) {
            double[] xpar = new double[par.length];
            for (int j = 0; j < par.length; ++j) {
                xpar[j] = par_err[j] * rdm.nextGaussian() + par[j];
            }
            f.setParameters(xpar);
            double[] xval = new double[var.length];
            for (int j = 0; j < var.length; ++j) {
                xval[j] = var_err[j] * rdm.nextGaussian() + var[j];
            }
            this.vec[i] = f.value(xval);
        }
    }

    public UPropogate(FNon f, ArrayList par, ArrayList par_err, ArrayList var, ArrayList var_err, int NTOT) {
        this(f, UPropogate.listToArray(par), UPropogate.listToArray(par_err), UPropogate.listToArray(var), UPropogate.listToArray(var_err), NTOT);
    }

    private static double[] listToArray(List<Double> arr) {
        double[] result = new double[arr.size()];
        int i = 0;
        for (Double d : arr) {
            result[i++] = d;
        }
        return result;
    }

    public double getStd() {
        this.error = Statistics.stddeviation(this.vec);
        return this.error;
    }

    public H1D getHisto() {
        P0D p = new P0D(this.vec);
        H1D tmp = new H1D("uncertainty", 100, p.getMin(), p.getMax());
        tmp.fill(this.vec);
        return tmp;
    }
}

