/*
 * Decompiled with CFR 0.152.
 */
package jhpro.tseries;

import com.jstatcom.io.DataHandler;
import com.jstatcom.io.DataHandlerTypes;
import com.jstatcom.io.ImportTypes;
import com.jstatcom.io.TSASCIIHandler;
import com.jstatcom.io.TSExcelHandler;
import com.jstatcom.io.TSGaussDATHandler;
import com.jstatcom.io.TSGaussFMTHandler;
import com.jstatcom.io.TSImportTypes;
import com.jstatcom.io.TSMatlabHandler;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDate;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCString;
import com.jstatcom.model.Symbol;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSTable;
import com.jstatcom.ts.TSTableScrollPane;
import com.jstatcom.util.UMatrix;
import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import javax.swing.JFrame;
import jhplot.P0D;
import jhplot.P1D;
import jhplot.PND;
import jhplot.gui.HelpBrowser;
import jhplot.utils.Util;

public class HStatData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TSTable TSTable = null;
    private JSCDate startDate;
    private JSCNArray data;
    private JSCSArray varNames;
    private String description;
    private DataHandler handler;

    public HStatData(String description) {
        this.description = "undefined";
        this.description = description;
    }

    public HStatData() {
        this.description = "undefined";
        this.description = "undefined";
    }

    public HStatData(String description, String sfile) {
        description = this.description = "undefined";
        this.readData(sfile);
    }

    public void readData(String sfile) {
        sfile = sfile.trim();
        File file = null;
        if (sfile.startsWith("http:") || sfile.startsWith("ftp:")) {
            try {
                URL url = new URL(sfile);
                String fileName = sfile.substring(sfile.lastIndexOf(47) + 1, sfile.length());
                String tempDir = System.getProperty("java.io.tmpdir");
                file = new File(tempDir + File.separator + fileName);
                if (!file.exists()) {
                    Util.copyURLToFile(url, file);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            file = new File(sfile);
        }
        if (file == null) {
            Util.ErrorMessage("No such file is found!");
            return;
        }
        if (!file.canRead()) {
            Util.ErrorMessage("Cannot read from file \"" + file.getAbsolutePath() + "\".");
        }
        String fName = file.getName();
        DataHandlerTypes type = DataHandlerTypes.getTypeFromFileName((String)file.getAbsolutePath());
        DataHandler handler = type.getHandler();
        boolean a = handler.importData(file);
        if (!a) {
            Util.ErrorMessage("Error in reading the file!");
        }
        this.data = (JSCNArray)handler.getData((ImportTypes)TSImportTypes.DATA);
        this.startDate = (JSCDate)handler.getData((ImportTypes)TSImportTypes.STARTDATE);
        this.varNames = (JSCSArray)handler.getData((ImportTypes)TSImportTypes.VARNAMES);
        JSCString des = (JSCString)handler.getData((ImportTypes)TSImportTypes.DESCRIPTION);
        this.description = des.string();
    }

    public void toTable() {
        JFrame f = new JFrame(this.description);
        f.setDefaultCloseOperation(2);
        f.setSize(400, 500);
        f.setLocation(200, 200);
        TS[] tsArray = new TS[this.data.cols()];
        double[][] values = this.data.doubleArray();
        for (int i = 0; i < tsArray.length; ++i) {
            tsArray[i] = new TS(UMatrix.getDoubleCol((double[][])values, (int)i), this.varNames.stringAt(i, 0), this.startDate.getTSDate());
        }
        this.getTSTable().setTS(tsArray);
        TSTableScrollPane jScrollPane = new TSTableScrollPane();
        jScrollPane.setViewportView((Component)this.getTSTable());
        f.getContentPane().add("Center", (Component)jScrollPane);
        f.setVisible(true);
    }

    private TSTable getTSTable() {
        if (this.TSTable == null) {
            this.TSTable = new TSTable();
        }
        return this.TSTable;
    }

    public JSCNArray getData() {
        return this.data;
    }

    public void setData(JSCNArray d) {
        this.data = d;
    }

    public void setPND(PND d) {
        this.data.clear();
        for (int i = 0; i < d.size(); ++i) {
            double[] tt = d.get(i);
            JSCNArray r = new JSCNArray("");
            this.data.appendRows(r);
        }
    }

    public PND getPND() {
        PND d = new PND(this.data.name());
        double[][] values = this.data.doubleArray();
        d.setArray(values);
        return d;
    }

    public String toString() {
        String s = this.description + "\n varNames=" + this.varNames.display() + "\n";
        return s + this.data.display();
    }

    public JSCSArray getVarNames() {
        return this.varNames;
    }

    public void setVarNames(JSCSArray d) {
        this.varNames = d;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public P0D getP0D(int column) {
        P0D p = new P0D(this.description + " " + Integer.toString(column));
        p.fill(this.data.getCol(column));
        return p;
    }

    public double[] getColumn(int column) {
        return this.data.getCol(column);
    }

    public P1D getP1D(int column1, int column2) {
        P1D p = new P1D(this.description + " " + Integer.toString(column1) + ":" + Integer.toString(column2));
        p.setArrayX(this.data.getCol(column1));
        p.setArrayY(this.data.getCol(column2));
        return p;
    }

    public void saveData(String outfile, String type) {
        File fout = new File(outfile);
        Symbol symbol = new Symbol((JSCData)this.data);
        boolean t = true;
        String trans = t ? ", transposed" : "";
        String header = "name = " + symbol.NAME + ", type = NARRAY, rows = " + this.data.rows() + ", cols = " + this.data.cols() + trans;
        if (this.description != null && this.description.length() > 0) {
            header = header + "\r\ndescription " + this.description;
        }
        TS[] tsArray = this.getTS();
        if (type.equalsIgnoreCase("ASCII") || type.equalsIgnoreCase("TXT")) {
            this.handler = TSASCIIHandler.getInstance();
            this.handler.exportTS(fout, tsArray, header);
        } else if (type.equalsIgnoreCase("Excel")) {
            this.handler = TSExcelHandler.getInstance();
            this.handler.exportTS(fout, tsArray, header);
        } else if (type.equalsIgnoreCase("Matlab")) {
            this.handler = TSMatlabHandler.getInstance();
            this.handler.exportTS(fout, tsArray, header);
        } else if (type.equalsIgnoreCase("GaussDAT")) {
            this.handler = TSGaussDATHandler.getInstance();
            this.handler.exportTS(fout, tsArray, header);
        } else if (type.equalsIgnoreCase("GaussFMT")) {
            this.handler = TSGaussFMTHandler.getInstance();
            this.handler.exportTS(fout, tsArray, header);
        } else {
            Util.ErrorMessage("Unsupported formt!");
        }
    }

    public int getNumberColumns() {
        return this.data.cols();
    }

    public int getNumberRows() {
        return this.data.rows();
    }

    public TS[] getTS() {
        TS[] tsArray = new TS[this.data.cols()];
        double[][] values = this.data.doubleArray();
        for (int i = 0; i < tsArray.length; ++i) {
            tsArray[i] = new TS(UMatrix.getDoubleCol((double[][])values, (int)i), this.varNames.stringAt(i, 0), this.startDate.getTSDate());
        }
        return tsArray;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    public void replaceColumn(int column, double[] d) {
        if (this.data.rows() != d.length) {
            System.err.println("The length of array do not match the number of rows");
            return;
        }
        for (int j = 0; j < this.data.rows(); ++j) {
            this.data.setValAt(d[j], j, column);
        }
    }

    public void append(HStatData hs) {
        this.data.appendRows(hs.getData());
    }

    public double[] getRow(int index) {
        return this.data.getRow(index);
    }
}

