/*
 * Decompiled with CFR 0.152.
 */
package jhpro.test;

import java.awt.Color;
import java.util.Random;
import jhplot.H1D;
import jhplot.HPlot;
import jhpro.stat.CLimits;
import jhpro.stat.ConfidenceLevel;
import jhpro.stat.DataSource;

public class TestLimit {
    public static void main(String[] args) {
        int i;
        HPlot c1 = new HPlot("test");
        c1.visible();
        c1.setRange(-4.0, 4.0, 0.0, 100.0);
        c1.setNameX("Variable");
        c1.setNameY("Events");
        H1D background = new H1D("Background", 30, -4.0, 4.0);
        background.setColor(Color.green);
        background.setFill(true);
        background.setFillColor(Color.green);
        H1D signal = new H1D("Signal", 30, -4.0, 4.0);
        signal.setFill(true);
        signal.setFillColor(Color.red);
        signal.setColor(Color.red);
        H1D data = new H1D("Data", 30, -4.0, 4.0);
        data.setColor(Color.black);
        data.setStyle("p");
        Random r = new Random();
        for (i = 0; i < 25000; ++i) {
            background.fill(r.nextGaussian(), 0.02);
            signal.fill(1.0 + 0.2 * r.nextGaussian(), 0.001);
        }
        for (i = 0; i < 500; ++i) {
            data.fill(r.nextGaussian(), 1.0);
        }
        H1D sigback = background.oper(signal, "Signal+Background", "+");
        c1.draw(signal);
        c1.draw(sigback);
        c1.draw(data);
        System.out.println("Computing limits... ");
        DataSource mydatasource = new DataSource(signal, background, data);
        CLimits climit = new CLimits(mydatasource, 50000);
        ConfidenceLevel myconfidence = climit.getLimit();
        System.out.println("CLs    : " + Double.toString(myconfidence.getCLs()));
        System.out.println("CLsb    : " + Double.toString(myconfidence.getCLsb()));
        System.out.println("CLb    : " + Double.toString(myconfidence.getCLb()));
        System.out.println("<CLs>    : " + Double.toString(myconfidence.getExpectedCLs_b()));
        System.out.println("<CLsb>    : " + Double.toString(myconfidence.getExpectedCLsb_b()));
        System.out.println("<CLb>    : " + Double.toString(myconfidence.getExpectedCLb_b()));
    }
}

