/*
 * Decompiled with CFR 0.152.
 */
package jhpro.stat;

import jhplot.H1D;
import jhplot.P1D;

public class DataKeeper {
    private double[] values;
    private double[] errors;
    private int size;
    private String title;

    public DataKeeper(int size) {
        this.size = size;
        this.values = new double[size];
        this.errors = new double[size];
        this.title = "None";
    }

    public DataKeeper(P1D p1d) {
        int i;
        this.size = p1d.size();
        this.values = new double[this.size];
        this.errors = new double[this.size];
        for (i = 0; i < this.size; ++i) {
            this.values[i] = p1d.getY(i);
        }
        for (i = 0; i < this.size; ++i) {
            this.errors[i] = p1d.getYupper(i);
        }
        this.title = p1d.getTitle();
    }

    public DataKeeper(H1D h1d) {
        int i;
        this.size = h1d.getBins();
        this.values = new double[this.size];
        this.errors = new double[this.size];
        for (i = 0; i < h1d.getBins(); ++i) {
            this.values[i] = h1d.binHeight(i);
        }
        for (i = 0; i < h1d.getBins(); ++i) {
            this.errors[i] = h1d.binError(i);
        }
        this.title = h1d.getTitle();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setErrors(double[] errors) {
        this.errors = errors;
    }

    public void setValues(double[] values) {
        this.values = values;
    }

    public void scale(int index, double factor) {
        this.values[index] = factor * this.values[index];
        this.errors[index] = factor * this.errors[index];
    }

    public void scale(double factor) {
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = factor * this.values[i];
            this.errors[i] = factor * this.errors[i];
        }
    }

    public double[] getErrors() {
        return this.errors;
    }

    public DataKeeper copy() {
        DataKeeper dd = new DataKeeper(this.getSize());
        dd.setValues(this.getValues());
        dd.setErrors(this.getErrors());
        dd.setTitle(this.getTitle());
        return dd;
    }

    public double[] getValues() {
        return this.values;
    }

    public double getIntegral() {
        double sum = 0.0;
        for (int i = 0; i < this.size; ++i) {
            sum += this.values[i];
        }
        return sum;
    }

    public double getError(int index) {
        return this.errors[index];
    }

    public double getValue(int index) {
        return this.values[index];
    }

    public void setValue(int index, double value) {
        this.values[index] = value;
    }

    public void setError(int index, double value) {
        this.errors[index] = value;
    }

    public int getSize() {
        return this.size;
    }
}

