/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet.jknnl;

import jhpro.nnet.jknnl.LearningDataModel;
import jhpro.nnet.jknnl.LearningFactorFunctionalModel;
import jhpro.nnet.jknnl.MetricModel;
import jhpro.nnet.jknnl.NeighbourhoodFunctionModel;
import jhpro.nnet.jknnl.NetworkModel;
import jhpro.nnet.jknnl.TiredNeuronModel;
import jhpro.nnet.jknnl.WTMLearningFunction;

public class WTMLearningFunctionWithTired
extends WTMLearningFunction {
    public WTMLearningFunctionWithTired(NetworkModel networkModel, int maxIteration, MetricModel metrics, LearningDataModel learningData, LearningFactorFunctionalModel functionalModel, NeighbourhoodFunctionModel neighboorhoodFunction) {
        super(networkModel, maxIteration, metrics, learningData, functionalModel, neighboorhoodFunction);
    }

    @Override
    public int getBestNeuron(double[] vector) {
        int bestNeuron = super.getBestNeuron(vector);
        int networkSize = this.networkModel.getNumbersOfNeurons();
        for (int i = 0; i < networkSize; ++i) {
            TiredNeuronModel tempNeuron = (TiredNeuronModel)this.networkModel.getNeuron(i);
            int tiredness = tempNeuron.getTiredness();
            tempNeuron.setTiredness(++tiredness);
        }
        return bestNeuron;
    }

    @Override
    protected void changeNeuronWeight(int neuronNumber, double[] vector, int iteration, int distance) {
        super.changeNeuronWeight(neuronNumber, vector, iteration, distance);
        TiredNeuronModel tempNeuron = (TiredNeuronModel)this.networkModel.getNeuron(neuronNumber);
        int tiredness = tempNeuron.getTiredness();
        tempNeuron.setTiredness(tiredness - 2);
    }
}

