/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet.jknnl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import jhplot.PND;
import jhpro.nnet.jknnl.LearningDataModel;

public class LearningData
implements LearningDataModel {
    ArrayList<double[]> dataList = new ArrayList();

    public LearningData(String fileName) {
        File file = new File(fileName);
        int rows = 0;
        try {
            String line;
            FileReader fr = new FileReader(file);
            BufferedReader input = new BufferedReader(fr);
            System.out.println("Data from: \"" + fileName + "\" are importing...");
            while ((line = input.readLine()) != null) {
                ++rows;
                String[] tempTable = line.split("\t");
                int tableLenght = tempTable.length;
                double[] tempList = new double[tableLenght];
                for (int i = 0; i < tableLenght; ++i) {
                    tempList[i] = Double.valueOf(tempTable[i]);
                }
                this.dataList.add(tempList);
            }
            fr.close();
            System.out.println(rows + " rows was imported");
        }
        catch (IOException e) {
            System.out.println("File can not be read!. Error: " + e);
        }
    }

    public LearningData(PND array2D) {
        this.dataList = array2D.getArrayList();
    }

    public LearningData(ArrayList<double[]> dataList) {
        this.dataList = dataList;
    }

    @Override
    public double[] getData(int index) {
        return this.dataList.get(index);
    }

    @Override
    public String toString() {
        String text = "";
        int dataSize = this.dataList.size();
        for (int i = 0; i < dataSize; ++i) {
            text = text + "[";
            double[] vector = this.dataList.get(i);
            int vectorSize = vector.length;
            for (int j = 0; j < vectorSize; ++j) {
                text = text + vector[j];
                if (j >= vectorSize - 1) continue;
                text = text + ", ";
            }
            text = text + "]\n";
        }
        return text;
    }

    @Override
    public int getDataSize() {
        return this.dataList.size();
    }

    public int getVectorSize() {
        return this.dataList.get(0).length;
    }
}

