/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet.jknnl;

import java.util.ArrayList;
import java.util.TreeMap;
import jhpro.nnet.jknnl.Coords;
import jhpro.nnet.jknnl.TopologyModel;

public class HexagonalTopology
implements TopologyModel {
    private int colNumber;
    private int rowNumber;
    private int radius;

    public HexagonalTopology(int row, int col) {
        this.rowNumber = row;
        this.colNumber = col;
    }

    @Override
    public void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    @Override
    public void setColNumber(int colNumber) {
        this.colNumber = colNumber;
    }

    @Override
    public int getRowNumber() {
        return this.rowNumber;
    }

    @Override
    public int getColNumber() {
        return this.colNumber;
    }

    @Override
    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public ArrayList getConnectedNeurons(int neuronNumber) {
        ArrayList<Integer> connectedNeurons = new ArrayList<Integer>();
        int neuronRow = (neuronNumber - 1) / this.colNumber + 1;
        if (neuronRow % 2 == 1) {
            if (neuronNumber - (this.colNumber + 1) > 0 && neuronNumber % this.colNumber != 1) {
                connectedNeurons.add(neuronNumber - (this.colNumber + 1));
            }
            if (neuronNumber - this.colNumber > 0) {
                connectedNeurons.add(neuronNumber - this.colNumber);
            }
            if (neuronNumber - 1 > 0 && neuronNumber % this.colNumber != 1) {
                connectedNeurons.add(neuronNumber - 1);
            }
            if (neuronNumber + 1 <= this.colNumber * this.rowNumber && neuronNumber % this.colNumber != 0) {
                connectedNeurons.add(neuronNumber + 1);
            }
            if (neuronNumber + (this.colNumber - 1) < this.colNumber * this.rowNumber && neuronNumber % this.colNumber != 1) {
                connectedNeurons.add(neuronNumber + (this.colNumber - 1));
            }
            if (neuronNumber + this.colNumber <= this.colNumber * this.rowNumber) {
                connectedNeurons.add(neuronNumber + this.colNumber);
            }
        } else {
            if (neuronNumber - this.colNumber > 0) {
                connectedNeurons.add(neuronNumber - this.colNumber);
            }
            if (neuronNumber - (this.colNumber - 1) > 0 && neuronNumber % this.colNumber != 0) {
                connectedNeurons.add(neuronNumber - (this.colNumber - 1));
            }
            if (neuronNumber - 1 > 0 && neuronNumber % this.colNumber != 1) {
                connectedNeurons.add(neuronNumber - 1);
            }
            if (neuronNumber + 1 <= this.colNumber * this.rowNumber && neuronNumber % this.colNumber != 0) {
                connectedNeurons.add(neuronNumber + 1);
            }
            if (neuronNumber + this.colNumber <= this.colNumber * this.rowNumber) {
                connectedNeurons.add(neuronNumber + this.colNumber);
            }
            if (neuronNumber + (this.colNumber + 1) <= this.colNumber * this.rowNumber && neuronNumber % this.colNumber != 0) {
                connectedNeurons.add(neuronNumber + (this.colNumber + 1));
            }
        }
        return connectedNeurons;
    }

    @Override
    public int getNumbersOfNeurons() {
        return this.colNumber * this.rowNumber;
    }

    private ArrayList getN(ArrayList tempConnection) {
        ArrayList neighborgoodConn = new ArrayList();
        ArrayList tempConn = new ArrayList();
        for (int j = 0; j < tempConnection.size(); ++j) {
            tempConn = this.getConnectedNeurons((Integer)tempConnection.get(j));
            for (int i = 0; i < tempConn.size(); ++i) {
                if (neighborgoodConn.contains(tempConn.get(i))) continue;
                neighborgoodConn.add(tempConn.get(i));
            }
        }
        return neighborgoodConn;
    }

    @Override
    public TreeMap getNeighbourhood(int neuronNumber) {
        TreeMap<Integer, Integer> neighbornhood = new TreeMap<Integer, Integer>();
        ArrayList tempConnection = new ArrayList();
        ArrayList neighborgoodConn = new ArrayList();
        tempConnection.add(neuronNumber);
        Object temp = null;
        int key = 0;
        for (int i = 0; i < this.radius; ++i) {
            neighborgoodConn = this.getN(tempConnection);
            for (int k = 0; k < neighborgoodConn.size(); ++k) {
                key = (Integer)neighborgoodConn.get(k);
                if (neighbornhood.containsKey(key)) continue;
                neighbornhood.put(key, i + 1);
            }
            tempConnection = (ArrayList)neighborgoodConn.clone();
        }
        return neighbornhood;
    }

    @Override
    public int getNeuronNumber(Coords coords) {
        if (coords.x < this.rowNumber && coords.y < this.colNumber) {
            return (coords.x - 1) * this.colNumber + coords.y;
        }
        return -1;
    }

    @Override
    public Coords getNeuronCoordinate(int neuronNumber) {
        int x = (neuronNumber - 1) / this.colNumber + 1;
        int y = neuronNumber - (x - 1) * this.colNumber;
        return new Coords(x, y);
    }

    @Override
    public String toString() {
        ArrayList tempList = new ArrayList();
        String conn = "";
        for (int i = 1; i < this.colNumber * this.rowNumber + 1; ++i) {
            tempList = this.getConnectedNeurons(i);
            conn = conn + i + "\t" + tempList + "\n";
        }
        return conn;
    }
}

