/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;

class ParametersFrame
extends Frame {
    final int n = 12;
    final Font parametersFont = new Font("Helvetica", 0, 12);
    final Font statusFont = new Font("Helvetica", 1, 12);
    final int def_inputValues = 10;
    final int def_mapSizeX = 9;
    final int def_mapSizeY = 9;
    final int def_dim = 3;
    final double def_initRate = 0.6;
    final double def_initArea = 3.0;
    final double def_stopArea = 0.5;
    final int def_stopCycle = -1;
    final int def_rangeX = 120;
    final int def_rangeY = 120;
    final int def_rangeZ = 120;
    final int def_speedX = 1;
    final int def_speedY = 2;
    final int def_speedZ = -4;
    final int def_displayStep = 1;
    int p_inputValues;
    int p_mapSizeX;
    int p_mapSizeY;
    int p_dim;
    double p_initRate;
    double p_initArea;
    double p_stopArea;
    int p_stopCycle;
    int p_rangeX;
    int p_rangeY;
    int p_rangeZ;
    int p_speedX;
    int p_speedY;
    int p_speedZ;
    int p_displayStep;
    GridBagLayout gb;
    GridBagConstraints gbc;
    Panel values;
    Panel buttons;
    Panel status;
    Label[] label;
    Label statusText;
    CheckboxGroup cbg;
    TextField inputValues;
    TextField mapSizeX;
    TextField mapSizeY;
    Checkbox dim2;
    Checkbox dim3;
    TextField initRate;
    TextField initArea;
    TextField stopArea;
    TextField stopCycle;
    TextField rangeX;
    TextField rangeY;
    TextField rangeZ;
    TextField displayStep;
    Label[] speed;
    Scrollbar speedX;
    Scrollbar speedY;
    Scrollbar speedZ;
    Button applyButton;
    Button defaultsButton;
    Button hideButton;

    public ParametersFrame(int i, int j) {
        this.setTitle("Parameters");
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.setFont(this.parametersFont);
        this.setResizable(false);
        this.gb = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.values = new Panel();
        this.values.setLayout(this.gb);
        this.buttons = new Panel();
        this.buttons.setLayout(new FlowLayout(0, 4, 2));
        this.status = new Panel();
        this.status.setLayout(new BorderLayout(4, 0));
        this.applyButton = new Button("Apply");
        this.defaultsButton = new Button("Set defaults");
        this.hideButton = new Button("Hide");
        this.speed = new Label[3];
        this.speed[0] = new Label();
        this.speed[1] = new Label();
        this.speed[2] = new Label();
        this.statusText = new Label();
        this.statusText.setFont(this.statusFont);
        this.statusText.setText("Ready.");
        this.label = new Label[12];
        for (int k = 0; k < 12; ++k) {
            this.label[k] = new Label("", 0);
        }
        this.label[0].setText(" input values: ");
        this.label[1].setText(" map size ( x / y ): ");
        this.label[2].setText(" input neurons: ");
        this.label[3].setText(" initial learning rate: ");
        this.label[4].setText(" initial activation area: ");
        this.label[5].setText(" stop, if area is smaller than: ");
        this.label[6].setText(" stop at learning cycle: ");
        this.label[7].setText(" input range ( x / y / z ): ");
        this.label[8].setText(" x-axis rotation speed: ");
        this.label[9].setText(" y-axis rotation speed: ");
        this.label[10].setText(" z-axis rotation speed: ");
        this.label[11].setText(" display step: ");
        this.inputValues = new TextField(4);
        this.mapSizeX = new TextField(4);
        this.mapSizeY = new TextField(4);
        this.initRate = new TextField(4);
        this.initArea = new TextField(4);
        this.stopArea = new TextField(4);
        this.stopCycle = new TextField(4);
        this.rangeX = new TextField(4);
        this.rangeY = new TextField(4);
        this.rangeZ = new TextField(4);
        this.displayStep = new TextField(4);
        this.speedX = new Scrollbar(0, 0, 5, -10, 10);
        this.speedY = new Scrollbar(0, 0, 5, -10, 10);
        this.speedZ = new Scrollbar(0, 0, 5, -10, 10);
        this.cbg = new CheckboxGroup();
        this.dim2 = new Checkbox("2", this.cbg, false);
        this.dim3 = new Checkbox("3", this.cbg, true);
        this.gbc.anchor = 18;
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(1, 2, 1, 2);
        this.gbc.ipadx = 2;
        this.gbc.ipady = 2;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.gridwidth = 2;
        this.gb.setConstraints(this.label[0], this.gbc);
        this.values.add(this.label[0]);
        this.gbc.gridwidth = 0;
        this.gb.setConstraints(this.inputValues, this.gbc);
        this.values.add(this.inputValues);
        this.gbc.gridwidth = 3;
        this.gb.setConstraints(this.label[1], this.gbc);
        this.values.add(this.label[1]);
        this.gb.setConstraints(this.mapSizeX, this.gbc);
        this.values.add(this.mapSizeX);
        this.gbc.gridwidth = 0;
        this.gb.setConstraints(this.mapSizeY, this.gbc);
        this.values.add(this.mapSizeY);
        this.gbc.gridwidth = 3;
        this.gb.setConstraints(this.label[2], this.gbc);
        this.values.add(this.label[2]);
        this.gb.setConstraints(this.dim2, this.gbc);
        this.values.add(this.dim2);
        this.gbc.gridwidth = 0;
        this.gb.setConstraints(this.dim3, this.gbc);
        this.values.add(this.dim3);
        this.gbc.gridwidth = 2;
        this.gb.setConstraints(this.label[3], this.gbc);
        this.values.add(this.label[3]);
        this.gbc.gridwidth = 0;
        this.gb.setConstraints(this.initRate, this.gbc);
        this.values.add(this.initRate);
        this.gbc.gridwidth = 2;
        this.gb.setConstraints(this.label[4], this.gbc);
        this.values.add(this.label[4]);
        this.gbc.gridwidth = 0;
        this.gb.setConstraints(this.initArea, this.gbc);
        this.values.add(this.initArea);
        this.gbc.gridwidth = 2;
        this.gb.setConstraints(this.label[5], this.gbc);
        this.values.add(this.label[5]);
        this.gbc.gridwidth = 0;
        this.gb.setConstraints(this.stopArea, this.gbc);
        this.values.add(this.stopArea);
        this.gbc.gridwidth = 3;
        this.gb.setConstraints(this.label[6], this.gbc);
        this.values.add(this.label[6]);
        this.gb.setConstraints(this.stopCycle, this.gbc);
        this.values.add(this.stopCycle);
        this.gbc.gridwidth = 0;
        Label label1 = new Label("( -1 = infinite )");
        this.gb.setConstraints(label1, this.gbc);
        this.values.add(label1);
        this.gbc.gridwidth = 4;
        this.gb.setConstraints(this.label[7], this.gbc);
        this.values.add(this.label[7]);
        this.gb.setConstraints(this.rangeX, this.gbc);
        this.values.add(this.rangeX);
        this.gb.setConstraints(this.rangeY, this.gbc);
        this.values.add(this.rangeY);
        this.gbc.gridwidth = 0;
        this.gb.setConstraints(this.rangeZ, this.gbc);
        this.values.add(this.rangeZ);
        this.gbc.fill = 2;
        this.gbc.gridwidth = 3;
        this.gb.setConstraints(this.label[8], this.gbc);
        this.values.add(this.label[8]);
        this.gbc.gridwidth = -1;
        this.gb.setConstraints(this.speedX, this.gbc);
        this.values.add(this.speedX);
        this.gbc.gridwidth = 0;
        this.gb.setConstraints(this.speed[0], this.gbc);
        this.values.add(this.speed[0]);
        this.gbc.gridwidth = 3;
        this.gb.setConstraints(this.label[9], this.gbc);
        this.values.add(this.label[9]);
        this.gbc.gridwidth = -1;
        this.gb.setConstraints(this.speedY, this.gbc);
        this.values.add(this.speedY);
        this.gbc.gridwidth = 0;
        this.gb.setConstraints(this.speed[1], this.gbc);
        this.values.add(this.speed[1]);
        this.gbc.gridwidth = 3;
        this.gb.setConstraints(this.label[10], this.gbc);
        this.values.add(this.label[10]);
        this.gbc.gridwidth = -1;
        this.gb.setConstraints(this.speedZ, this.gbc);
        this.values.add(this.speedZ);
        this.gbc.gridwidth = 0;
        this.gb.setConstraints(this.speed[2], this.gbc);
        this.values.add(this.speed[2]);
        this.gbc.fill = 0;
        this.gbc.gridwidth = 2;
        this.gb.setConstraints(this.label[11], this.gbc);
        this.values.add(this.label[11]);
        this.gbc.gridwidth = 0;
        this.gb.setConstraints(this.displayStep, this.gbc);
        this.values.add(this.displayStep);
        this.buttons.add(this.applyButton);
        this.buttons.add(this.defaultsButton);
        this.buttons.add(this.hideButton);
        this.status.add("Center", this.statusText);
        this.add("Center", this.values);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(2, 2));
        panel.add("North", this.buttons);
        panel.add("South", this.status);
        this.add("South", panel);
        this.pack();
        this.hide();
        this.move(i, j);
        this.setDefaults();
        this.statusText.setText("Ready.");
    }

    public void setDefaults() {
        this.statusText.setText("Ready.");
        this.p_inputValues = 10;
        this.p_mapSizeX = 9;
        this.p_mapSizeY = 9;
        this.p_dim = 3;
        this.p_initRate = 0.6;
        this.p_initArea = 3.0;
        this.p_stopArea = 0.5;
        this.p_stopCycle = -1;
        this.p_rangeX = 120;
        this.p_rangeY = 120;
        this.p_rangeZ = 120;
        this.rangeZ.setEditable(true);
        this.p_speedX = 1;
        this.p_speedY = 2;
        this.p_speedZ = -4;
        this.p_displayStep = 1;
        this.updateParameters();
        this.statusText.setText("Default parameters set.");
    }

    public void updateParameters() {
        this.inputValues.setText(String.valueOf(this.p_inputValues));
        this.mapSizeX.setText(String.valueOf(this.p_mapSizeX));
        this.mapSizeY.setText(String.valueOf(this.p_mapSizeY));
        if (this.p_dim == 2) {
            this.dim2.setState(true);
        } else {
            this.dim3.setState(true);
        }
        this.initRate.setText(String.valueOf(this.p_initRate));
        this.initArea.setText(String.valueOf(this.p_initArea));
        this.stopArea.setText(String.valueOf(this.p_stopArea));
        this.stopCycle.setText(String.valueOf(this.p_stopCycle));
        this.rangeX.setText(String.valueOf(this.p_rangeX));
        this.rangeY.setText(String.valueOf(this.p_rangeY));
        this.rangeZ.setText(String.valueOf(this.p_rangeZ));
        this.speed[0].setText(String.valueOf(this.p_speedX));
        this.speedX.setValue(this.p_speedX);
        this.speed[1].setText(String.valueOf(this.p_speedY));
        this.speedY.setValue(this.p_speedY);
        this.speed[2].setText(String.valueOf(this.p_speedZ));
        this.speedZ.setValue(this.p_speedZ);
        this.displayStep.setText(String.valueOf(this.p_displayStep));
    }

    public void applyValues() {
        this.statusText.setText("Ready.");
        try {
            this.p_inputValues = Integer.valueOf(this.inputValues.getText());
            this.p_mapSizeX = Integer.valueOf(this.mapSizeX.getText());
            this.p_mapSizeY = Integer.valueOf(this.mapSizeY.getText());
            this.p_dim = !this.dim2.getState() ? 3 : 2;
            this.p_initRate = Double.valueOf(this.initRate.getText());
            this.p_initArea = Double.valueOf(this.initArea.getText());
            this.p_stopArea = Double.valueOf(this.stopArea.getText());
            this.p_stopCycle = Integer.valueOf(this.stopCycle.getText());
            this.p_rangeX = Integer.valueOf(this.rangeX.getText());
            this.p_rangeY = Integer.valueOf(this.rangeY.getText());
            this.p_rangeZ = Integer.valueOf(this.rangeZ.getText());
            this.p_speedX = this.speedX.getValue();
            this.p_speedY = this.speedY.getValue();
            this.p_speedZ = this.speedZ.getValue();
            this.p_displayStep = Integer.valueOf(this.displayStep.getText());
            this.statusText.setText("Parameters changed.  Hit 'Reset' button.");
            return;
        }
        catch (Exception _ex) {
            this.statusText.setText("Wrong input!  Parameters not changed.");
            return;
        }
    }

    public int getInputValues() {
        if (this.p_inputValues > 0) {
            return this.p_inputValues;
        }
        return 10;
    }

    public int getMapSizeX() {
        if (this.p_mapSizeX > 0) {
            return this.p_mapSizeX;
        }
        return 9;
    }

    public int getMapSizeY() {
        if (this.p_mapSizeY > 0) {
            return this.p_mapSizeY;
        }
        return 9;
    }

    public int getDim() {
        return this.p_dim;
    }

    public double getInitRate() {
        if (this.p_initRate > 0.0) {
            return this.p_initRate;
        }
        return 0.6;
    }

    public double getInitArea() {
        if (this.p_initArea > 0.0 && this.p_initArea > this.p_stopArea) {
            return this.p_initArea;
        }
        return 3.0;
    }

    public double getStopArea() {
        if (this.p_stopArea > 0.0 && this.p_stopArea < this.p_initArea) {
            return this.p_stopArea;
        }
        return 0.5;
    }

    public int getStopCycle() {
        if (this.p_stopCycle == -1 || this.p_stopCycle > 0) {
            return this.p_stopCycle;
        }
        return -1;
    }

    public int getRangeX() {
        if (this.p_rangeX > 0) {
            return this.p_rangeX;
        }
        return 120;
    }

    public int getRangeY() {
        if (this.p_rangeY > 0) {
            return this.p_rangeY;
        }
        return 120;
    }

    public int getRangeZ() {
        if (this.p_rangeZ > 0) {
            return this.p_rangeZ;
        }
        return 120;
    }

    public int getSpeedX() {
        return this.p_speedX;
    }

    public int getSpeedY() {
        return this.p_speedY;
    }

    public int getSpeedZ() {
        return this.p_speedZ;
    }

    public int getDisplayStep() {
        if (this.p_displayStep > 0) {
            return this.p_displayStep;
        }
        return 1;
    }

    @Override
    public boolean handleEvent(Event event) {
        if (event.target == this.speedX) {
            this.p_speedX = this.speedX.getValue();
            this.speed[0].setText(String.valueOf(this.p_speedX));
            return true;
        }
        if (event.target == this.speedY) {
            this.p_speedY = this.speedY.getValue();
            this.speed[1].setText(String.valueOf(this.p_speedY));
            return true;
        }
        if (event.target == this.speedZ) {
            this.p_speedZ = this.speedZ.getValue();
            this.speed[2].setText(String.valueOf(this.p_speedZ));
            return true;
        }
        switch (event.id) {
            case 201: {
                this.hide();
                return true;
            }
            case 1004: {
                this.statusText.setText("Ready.");
                return true;
            }
            case 1005: {
                this.statusText.setText("Ready.");
                return true;
            }
        }
        return super.handleEvent(event);
    }

    @Override
    public boolean action(Event event, Object obj) {
        if (event.target == this.dim2) {
            this.p_dim = 2;
            this.p_speedX = 0;
            this.p_speedY = 0;
            this.p_speedZ = 0;
            this.p_rangeX = 190;
            this.p_rangeY = 190;
            this.p_rangeZ = 1;
            this.rangeX.setText(String.valueOf(this.p_rangeX));
            this.rangeY.setText(String.valueOf(this.p_rangeY));
            this.rangeZ.setText(String.valueOf(this.p_rangeZ));
            this.speed[0].setText(String.valueOf(this.p_speedX));
            this.speedX.setValue(this.p_speedX);
            this.speed[1].setText(String.valueOf(this.p_speedY));
            this.speedY.setValue(this.p_speedY);
            this.speed[2].setText(String.valueOf(this.p_speedZ));
            this.speedZ.setValue(this.p_speedZ);
            this.rangeZ.setEditable(false);
            return true;
        }
        if (event.target == this.dim3) {
            this.p_dim = 3;
            this.p_speedX = 1;
            this.p_speedY = 2;
            this.p_speedZ = -4;
            this.p_rangeX = 120;
            this.p_rangeY = 120;
            this.p_rangeZ = 120;
            this.rangeX.setText(String.valueOf(this.p_rangeX));
            this.rangeY.setText(String.valueOf(this.p_rangeY));
            this.rangeZ.setText(String.valueOf(this.p_rangeZ));
            this.speed[0].setText(String.valueOf(this.p_speedX));
            this.speedX.setValue(this.p_speedX);
            this.speed[1].setText(String.valueOf(this.p_speedY));
            this.speedY.setValue(this.p_speedY);
            this.speed[2].setText(String.valueOf(this.p_speedZ));
            this.speedZ.setValue(this.p_speedZ);
            this.rangeZ.setEditable(true);
            return true;
        }
        if (event.target == this.applyButton) {
            this.applyValues();
            return true;
        }
        if (event.target == this.defaultsButton) {
            this.setDefaults();
            return true;
        }
        if (event.target == this.hideButton) {
            this.statusText.setText("Ready.");
            this.hide();
            return true;
        }
        return super.action(event, obj);
    }
}

