/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.sample;

import edu.uci.jforests.dataset.Dataset;
import edu.uci.jforests.eval.EvaluationMetric;
import edu.uci.jforests.util.ArraysUtil;
import edu.uci.jforests.util.Constants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;

public class Sample {
    public Dataset dataset;
    public int[] indicesInDataset;
    public double[] weights;
    public double[] targets;
    public int size;
    public int[] indicesInParentSample;

    public Sample(Dataset dataset) {
        this.dataset = dataset;
        this.size = dataset.numInstances;
        Constants.init(this.size);
        this.indicesInDataset = Constants.ONE_TWO_THREE_ETC;
        this.weights = Constants.DOUBLE_ONE_ONE_ONE_ETC;
        this.targets = dataset.targets;
    }

    public Sample(Dataset dataset, int[] indicesInDataset, double[] weights, double[] targets, int[] indicesInParentSample, int size) {
        this.dataset = dataset;
        this.indicesInDataset = indicesInDataset;
        this.weights = weights;
        this.targets = targets;
        this.size = size;
        this.indicesInParentSample = indicesInParentSample;
    }

    public Sample getClone() {
        return new Sample(this.dataset, this.indicesInDataset, this.weights, this.targets, this.indicesInParentSample, this.size);
    }

    public Sample getRandomSubSample(double rate, Random rnd) {
        if (rate < 1.0) {
            int sampleSize = (int)((double)this.size * rate);
            int[] tempIndices = new int[this.size];
            for (int i = 0; i < this.size; ++i) {
                tempIndices[i] = i;
            }
            ArraysUtil.shuffle(tempIndices, rnd);
            Arrays.sort(tempIndices, 0, sampleSize);
            int[] sampleIndicesInDataset = new int[sampleSize];
            double[] sampleWeights = new double[sampleSize];
            double[] sampleTargets = new double[sampleSize];
            int[] sampleIndicesInParentSample = new int[sampleSize];
            int curSampleSize = 0;
            for (int idx = 0; idx < sampleSize; ++idx) {
                int f = tempIndices[idx];
                sampleIndicesInDataset[curSampleSize] = this.indicesInDataset[f];
                sampleWeights[curSampleSize] = this.weights[f];
                sampleTargets[curSampleSize] = this.targets[f];
                sampleIndicesInParentSample[curSampleSize] = f;
                ++curSampleSize;
            }
            return new Sample(this.dataset, sampleIndicesInDataset, sampleWeights, sampleTargets, sampleIndicesInParentSample, sampleSize);
        }
        Sample result = this.getClone();
        result.indicesInParentSample = Constants.ONE_TWO_THREE_ETC;
        return result;
    }

    public Sample getRandomTargetBiasedSubSample(double rate, Random rnd) {
        if (rate < 1.0) {
            int i;
            int sampleSize;
            double minTarget = Double.POSITIVE_INFINITY;
            double maxTarget = Double.NEGATIVE_INFINITY;
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (this.targets[i2] < minTarget) {
                    minTarget = this.targets[i2];
                }
                if (!(this.targets[i2] > maxTarget)) continue;
                maxTarget = this.targets[i2];
            }
            int binCount = 20;
            double range = maxTarget - minTarget + 1.0;
            double binWidth = range / (double)binCount;
            int[] bins = new int[this.size];
            int[] binHist = new int[binCount];
            for (int i3 = 0; i3 < this.size; ++i3) {
                bins[i3] = (int)((this.targets[i3] - minTarget) / binWidth);
                int n = bins[i3];
                binHist[n] = binHist[n] + 1;
            }
            ArrayList<BinFreq> binFreqs = new ArrayList<BinFreq>();
            for (int i4 = 0; i4 < binCount; ++i4) {
                binFreqs.add(new BinFreq(i4, binHist[i4]));
            }
            Collections.sort(binFreqs);
            int remainedSize = sampleSize = (int)((double)this.size * rate);
            double[] perBinSampleRate = new double[binCount];
            for (int i5 = 0; i5 < binCount; ++i5) {
                BinFreq binFreq = (BinFreq)binFreqs.get(i5);
                int currentMax = remainedSize / (binCount - i5);
                int selectedSize = Math.min(binFreq.freq, currentMax);
                if (binFreq.freq > 0) {
                    perBinSampleRate[binFreq.bin] = (double)selectedSize / (double)binFreq.freq;
                }
                remainedSize -= selectedSize;
            }
            int[] sampleIndicesInDataset = new int[sampleSize];
            double[] sampleWeights = new double[sampleSize];
            double[] sampleTargets = new double[sampleSize];
            int[] sampleIndicesInParentSample = new int[sampleSize];
            int curSampleSize = 0;
            int[] tempIndices = new int[this.size];
            for (i = 0; i < binCount; ++i) {
                BinFreq binFreq = (BinFreq)binFreqs.get(i);
                if (binFreq.freq == 0) continue;
                int selectedSize = (int)(perBinSampleRate[binFreq.bin] * (double)binHist[binFreq.bin]);
                int idx = 0;
                for (int j = 0; j < this.size; ++j) {
                    if (bins[j] != binFreq.bin) continue;
                    tempIndices[idx] = j;
                    ++idx;
                }
                ArraysUtil.shuffle(tempIndices, binHist[binFreq.bin], rnd);
                Arrays.sort(tempIndices, 0, selectedSize);
                for (idx = 0; idx < selectedSize; ++idx) {
                    int f = tempIndices[idx];
                    sampleIndicesInDataset[curSampleSize] = this.indicesInDataset[f];
                    sampleWeights[curSampleSize] = this.weights[f];
                    sampleTargets[curSampleSize] = this.targets[f];
                    sampleIndicesInParentSample[curSampleSize] = f;
                    ++curSampleSize;
                }
            }
            for (i = 0; i < sampleSize; ++i) {
                int minIdx = i;
                for (int j = i + 1; j < sampleSize; ++j) {
                    if (sampleIndicesInDataset[j] >= sampleIndicesInDataset[minIdx]) continue;
                    minIdx = j;
                }
                ArraysUtil.swap(sampleIndicesInDataset, i, minIdx);
                ArraysUtil.swap(sampleWeights, i, minIdx);
                ArraysUtil.swap(sampleTargets, i, minIdx);
                ArraysUtil.swap(sampleIndicesInParentSample, i, minIdx);
            }
            return new Sample(this.dataset, sampleIndicesInDataset, sampleWeights, sampleTargets, sampleIndicesInParentSample, curSampleSize);
        }
        Sample result = this.getClone();
        result.indicesInParentSample = Constants.ONE_TWO_THREE_ETC;
        return result;
    }

    public double evaluate(double[] predictions, EvaluationMetric evaluationMetric) throws Exception {
        return evaluationMetric.measure(predictions, this);
    }

    public double evaluate(double[] predictions, EvaluationMetric evaluationMetric, double factor) throws Exception {
        double[] newPredictions = new double[predictions.length];
        for (int i = 0; i < predictions.length; ++i) {
            newPredictions[i] = predictions[i] * factor;
        }
        return evaluationMetric.measure(newPredictions, this);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Sample getOutOfSample(Sample subSample) {
        int oosSize = this.size - subSample.size;
        int[] oosIndicesInDataset = new int[oosSize];
        double[] oosWeights = new double[oosSize];
        double[] oosTargets = new double[oosSize];
        int samplePtr = 0;
        int oosCurSize = 0;
        for (int i = 0; i < this.size; ++i) {
            if (subSample.indicesInDataset[samplePtr] > this.indicesInDataset[i]) {
                oosIndicesInDataset[oosCurSize] = this.indicesInDataset[i];
                oosWeights[oosCurSize] = this.weights[i];
                oosTargets[oosCurSize] = this.targets[i];
                ++oosCurSize;
                continue;
            }
            if (subSample.indicesInDataset[samplePtr] == this.indicesInDataset[i] && ++samplePtr >= subSample.size) break;
        }
        return new Sample(this.dataset, oosIndicesInDataset, oosWeights, oosTargets, null, oosSize);
    }

    public class BinFreq
    implements Comparable<BinFreq> {
        public int bin;
        public int freq;

        public BinFreq(int bin, int freq) {
            this.bin = bin;
            this.freq = freq;
        }

        @Override
        public int compareTo(BinFreq o) {
            return this.freq - o.freq;
        }
    }
}

