/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning.trees;

import edu.uci.jforests.dataset.Dataset;
import edu.uci.jforests.learning.trees.LeafInstances;
import java.util.Arrays;

public class TreeLeafInstances {
    private int[] leafBegin;
    private int[] leafEnd;
    private int[] indices;
    private int[] tempIndices;

    public TreeLeafInstances(int numInstances, int maxLeaves) {
        this.leafBegin = new int[maxLeaves];
        this.leafEnd = new int[maxLeaves];
        this.indices = new int[numInstances];
    }

    public void init(int size) {
        Arrays.fill(this.leafBegin, 0);
        Arrays.fill(this.leafEnd, 0);
        this.leafBegin[0] = 0;
        this.leafEnd[0] = size;
        for (int i = 0; i < size; ++i) {
            this.indices[i] = i;
        }
    }

    public void split(int leaf, Dataset dataset, int featureIndex, int threshold, int rightChild, int[] instances) {
        if (this.tempIndices == null) {
            this.tempIndices = new int[this.indices.length];
        }
        int begin = this.leafBegin[leaf];
        int end = this.leafEnd[leaf];
        int newEnd = begin;
        int tempEnd = begin;
        for (int idx = begin; idx < end; ++idx) {
            int index = this.indices[idx];
            if (dataset.getFeatureValue(instances[index], featureIndex) > threshold) {
                this.tempIndices[tempEnd++] = index;
                continue;
            }
            this.indices[newEnd++] = index;
        }
        int rightCount = tempEnd - begin;
        System.arraycopy(this.tempIndices, begin, this.indices, newEnd, rightCount);
        this.leafEnd[leaf] = newEnd;
        this.leafBegin[rightChild] = newEnd;
        this.leafEnd[rightChild] = newEnd + rightCount;
    }

    public LeafInstances getLeafInstances(int leaf) {
        LeafInstances leafInstances = new LeafInstances();
        this.loadLeafInstances(leaf, leafInstances);
        return leafInstances;
    }

    public void loadLeafInstances(int leaf, LeafInstances leafInstances) {
        leafInstances.indices = this.indices;
        leafInstances.begin = this.leafBegin[leaf];
        leafInstances.end = this.leafEnd[leaf];
    }

    public int getNumberOfInstancesInLeaf(int leaf) {
        return this.leafEnd[leaf] - this.leafBegin[leaf];
    }
}

