/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.input;

import edu.uci.jforests.input.BinaryFileGenerator;
import edu.uci.jforests.input.DiscreteSparseTextFileGenerator;
import edu.uci.jforests.input.FeatureAnalyzer;
import edu.uci.jforests.util.Util;
import java.io.File;
import java.io.PrintStream;

public class Raw2BinConvertor {
    protected String inputFile;
    protected String featureStatsFile;
    protected String discreteFile;
    protected String binFile;

    protected BinaryFileGenerator getBinFileGenerator() {
        return new BinaryFileGenerator(this.discreteFile, this.featureStatsFile, this.binFile);
    }

    public void convert(String folder, String[] inputFileNames) throws Exception {
        if (!folder.endsWith("/")) {
            folder = folder + "/";
        }
        this.featureStatsFile = folder + "jforests-feature-stats.txt";
        File featuresFile = new File(this.featureStatsFile);
        if (featuresFile.exists()) {
            System.out.println("File: " + featuresFile + " already exists. Skipping it.");
        } else {
            FeatureAnalyzer analyzer = new FeatureAnalyzer();
            String[] stringArray = inputFileNames;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String inputFileName = stringArray[i];
                analyzer.processFile(folder + inputFileName);
            }
            analyzer.dumpStatistics(new PrintStream(featuresFile));
        }
        for (String inputFileName : inputFileNames) {
            this.inputFile = folder + inputFileName;
            this.discreteFile = folder + "jforests-discrete-" + inputFileName;
            this.binFile = folder + Util.getFileNameWithoutExtension(inputFileName) + ".bin";
            DiscreteSparseTextFileGenerator.convert(this.inputFile, this.featureStatsFile, this.discreteFile);
            BinaryFileGenerator binFileGenerator = this.getBinFileGenerator();
            binFileGenerator.convert();
        }
    }
}

