/*
 * Decompiled with CFR 0.152.
 */
package georegression.transform.se;

import java.util.List;
import org.ejml.alg.fixed.FixedOps3;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.FixedMatrix3x3_64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.ConvertMatrixType;

public class AverageRotationMatrix_F32 {
    DenseMatrix64F M = new DenseMatrix64F(3, 3);
    FixedMatrix3x3_64F F = new FixedMatrix3x3_64F();
    SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd(3, 3, true, true, true);

    public boolean process(List<DenseMatrix64F> list, DenseMatrix64F average) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Input list is empty");
        }
        if (average == null) {
            throw new IllegalArgumentException("average is null");
        }
        this.M.zero();
        for (int i = 0; i < list.size(); ++i) {
            DenseMatrix64F m = list.get(i);
            this.M.data[0] = this.M.data[0] + m.data[0];
            this.M.data[1] = this.M.data[1] + m.data[1];
            this.M.data[2] = this.M.data[2] + m.data[2];
            this.M.data[3] = this.M.data[3] + m.data[3];
            this.M.data[4] = this.M.data[4] + m.data[4];
            this.M.data[5] = this.M.data[5] + m.data[5];
            this.M.data[6] = this.M.data[6] + m.data[6];
            this.M.data[7] = this.M.data[7] + m.data[7];
            this.M.data[8] = this.M.data[8] + m.data[8];
        }
        CommonOps.divide(this.M, list.size());
        if (!this.svd.decompose(this.M)) {
            return false;
        }
        CommonOps.multTransB(this.svd.getU(null, false), this.svd.getV(null, false), average);
        double det = CommonOps.det(average);
        if (det < 0.0) {
            CommonOps.scale(-1.0, average);
        }
        return true;
    }

    public boolean process(List<FixedMatrix3x3_64F> list, FixedMatrix3x3_64F average) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Input list is empty");
        }
        if (average == null) {
            throw new IllegalArgumentException("average is null");
        }
        FixedOps3.fill(this.F, 0.0);
        for (int i = 0; i < list.size(); ++i) {
            FixedMatrix3x3_64F m = list.get(i);
            this.F.a11 += m.a11;
            this.F.a12 += m.a12;
            this.F.a13 += m.a13;
            this.F.a21 += m.a21;
            this.F.a22 += m.a22;
            this.F.a23 += m.a23;
            this.F.a31 += m.a31;
            this.F.a32 += m.a32;
            this.F.a33 += m.a33;
        }
        FixedOps3.divide(this.F, list.size());
        ConvertMatrixType.convert(this.F, this.M);
        if (!this.svd.decompose(this.M)) {
            return false;
        }
        CommonOps.multTransB(this.svd.getU(null, false), this.svd.getV(null, false), this.M);
        double det = CommonOps.det(this.M);
        if (det < 0.0) {
            CommonOps.scale(-1.0, this.M);
        }
        ConvertMatrixType.convert(this.M, average);
        return true;
    }
}

