/*
 * Decompiled with CFR 0.152.
 */
package georegression.transform.se;

import georegression.struct.so.Quaternion_F64;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.EigenDecomposition;

public class AverageQuaternion_F64 {
    DenseMatrix64F M = new DenseMatrix64F(4, 4);
    EigenDecomposition<DenseMatrix64F> eig = DecompositionFactory.eig(4, true, true);

    public boolean process(List<Quaternion_F64> list, Quaternion_F64 average) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Input list is empty");
        }
        if (average == null) {
            throw new IllegalArgumentException("average is null");
        }
        this.M.zero();
        for (int i = 0; i < list.size(); ++i) {
            Quaternion_F64 q = list.get(i);
            this.M.data[0] = this.M.data[0] + q.w * q.w;
            this.M.data[1] = this.M.data[1] + q.w * q.x;
            this.M.data[2] = this.M.data[2] + q.w * q.y;
            this.M.data[3] = this.M.data[3] + q.w * q.z;
            this.M.data[4] = this.M.data[4] + q.x * q.w;
            this.M.data[5] = this.M.data[5] + q.x * q.x;
            this.M.data[6] = this.M.data[6] + q.x * q.y;
            this.M.data[7] = this.M.data[7] + q.x * q.z;
            this.M.data[8] = this.M.data[8] + q.y * q.w;
            this.M.data[9] = this.M.data[9] + q.y * q.x;
            this.M.data[10] = this.M.data[10] + q.y * q.y;
            this.M.data[11] = this.M.data[11] + q.y * q.z;
            this.M.data[12] = this.M.data[12] + q.z * q.w;
            this.M.data[13] = this.M.data[13] + q.z * q.x;
            this.M.data[14] = this.M.data[14] + q.z * q.y;
            this.M.data[15] = this.M.data[15] + q.z * q.z;
        }
        if (!this.eig.decompose(this.M)) {
            return false;
        }
        int largest = 0;
        double largestMag = this.eig.getEigenvalue(0).getMagnitude2();
        for (int i = 1; i < 4; ++i) {
            double mag = this.eig.getEigenvalue(i).getMagnitude2();
            if (!(mag > largestMag)) continue;
            largestMag = mag;
            largest = i;
        }
        DenseMatrix64F v = this.eig.getEigenVector(largest);
        average.w = v.get(0);
        average.x = v.get(1);
        average.y = v.get(2);
        average.z = v.get(3);
        return true;
    }
}

