/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.shapes;

import georegression.geometry.UtilPolygons2D_F64;
import georegression.metric.Area2D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import java.io.Serializable;
import org.ddogleg.struct.FastQueue;

public class Polygon2D_F64
implements Serializable {
    public FastQueue<Point2D_F64> vertexes;

    public Polygon2D_F64(Polygon2D_F64 a) {
        this.vertexes = new FastQueue<Point2D_F64>(a.size(), Point2D_F64.class, true);
        for (int i = 0; i < a.size(); ++i) {
            this.vertexes.grow().set(a.get(i));
        }
    }

    public Polygon2D_F64(int numVertexes) {
        this.vertexes = new FastQueue<Point2D_F64>(numVertexes, Point2D_F64.class, true);
        this.vertexes.growArray(numVertexes);
        this.vertexes.size = numVertexes;
    }

    public Polygon2D_F64(double ... points) {
        if (points.length % 2 == 1) {
            throw new IllegalArgumentException("Expected an even number");
        }
        this.vertexes = new FastQueue<Point2D_F64>(points.length / 2, Point2D_F64.class, true);
        this.vertexes.growArray(points.length / 2);
        this.vertexes.size = points.length / 2;
        int count = 0;
        for (int i = 0; i < points.length; i += 2) {
            ((Point2D_F64[])this.vertexes.data)[count++].set(points[i], points[i + 1]);
        }
    }

    public Polygon2D_F64() {
        this.vertexes = new FastQueue<Point2D_F64>(Point2D_F64.class, true);
    }

    public void set(Polygon2D_F64 orig) {
        this.vertexes.resize(orig.size());
        for (int i = 0; i < orig.size(); ++i) {
            ((Point2D_F64[])this.vertexes.data)[i].set(((Point2D_F64[])orig.vertexes.data)[i]);
        }
    }

    public void set(int index, double x, double y) {
        ((Point2D_F64[])this.vertexes.data)[index].set(x, y);
    }

    public Point2D_F64 get(int index) {
        return ((Point2D_F64[])this.vertexes.data)[index];
    }

    public int size() {
        return this.vertexes.size();
    }

    public Polygon2D_F64 copy() {
        return new Polygon2D_F64(this);
    }

    public double areaSimple() {
        return Area2D_F64.polygonSimple(this);
    }

    public boolean isInside(Point2D_F64 p) {
        if (this.isConvex()) {
            return Intersection2D_F64.containConvex(this, p);
        }
        return Intersection2D_F64.containConcave(this, p);
    }

    public boolean isCCW() {
        return UtilPolygons2D_F64.isCCW(this.vertexes.toList());
    }

    public boolean isConvex() {
        return UtilPolygons2D_F64.isConvex(this);
    }

    public boolean isIdentical(Polygon2D_F64 a, double tol) {
        return UtilPolygons2D_F64.isIdentical(this, a, tol);
    }

    public boolean isEquivalent(Polygon2D_F64 a, double tol) {
        return UtilPolygons2D_F64.isEquivalent(this, a, tol);
    }

    public void flip() {
        UtilPolygons2D_F64.flip(this);
    }

    public LineSegment2D_F64 getLine(int index, LineSegment2D_F64 storage) {
        if (storage == null) {
            storage = new LineSegment2D_F64();
        }
        int j = (index + 1) % this.vertexes.size;
        storage.a.set(this.get(index));
        storage.b.set(this.get(j));
        return storage;
    }

    public String toString() {
        String out = this.getClass().getSimpleName() + "{ order " + this.vertexes.size + " : vertexes [ ";
        for (int i = 0; i < this.vertexes.size; ++i) {
            Point2D_F64 p = this.vertexes.get(i);
            out = out + p.x + " , " + p.y + " ; ";
        }
        out = out + " ] }";
        return out;
    }
}

