/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.se;

import georegression.geometry.ConvertRotation3D_F32;
import georegression.struct.EulerType;
import georegression.struct.affine.Affine2D_F32;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.se.Se2_F32;
import georegression.struct.se.Se3_F32;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class SpecialEuclideanOps_F32 {
    public static void setToNoMotion(Se3_F32 se) {
        CommonOps.setIdentity(se.getR());
        se.getT().set(0.0f, 0.0f, 0.0f);
    }

    public static Affine2D_F32 toAffine(Se2_F32 se, Affine2D_F32 affine) {
        if (affine == null) {
            affine = new Affine2D_F32();
        }
        affine.a11 = se.c;
        affine.a12 = -se.s;
        affine.a21 = se.s;
        affine.a22 = se.c;
        affine.tx = se.T.x;
        affine.ty = se.T.y;
        return affine;
    }

    public static DenseMatrix64F toHomogeneous(Se3_F32 se, DenseMatrix64F ret) {
        if (ret == null) {
            ret = new DenseMatrix64F(4, 4);
        } else {
            ret.set(3, 0, 0.0);
            ret.set(3, 1, 0.0);
            ret.set(3, 2, 0.0);
        }
        CommonOps.insert(se.getR(), ret, 0, 0);
        Vector3D_F32 T = se.getT();
        ret.set(0, 3, T.x);
        ret.set(1, 3, T.y);
        ret.set(2, 3, T.z);
        ret.set(3, 3, 1.0);
        return ret;
    }

    public static Se3_F32 toSe3_F32(DenseMatrix64F H, Se3_F32 ret) {
        if (H.numCols != 4 || H.numRows != 4) {
            throw new IllegalArgumentException("The homogeneous matrix must be 4 by 4 by definition.");
        }
        if (ret == null) {
            ret = new Se3_F32();
        }
        ret.setTranslation((float)H.get(0, 3), (float)H.get(1, 3), (float)H.get(2, 3));
        CommonOps.extract(H, 0, 3, 0, 3, ret.getR(), 0, 0);
        return ret;
    }

    public static DenseMatrix64F toHomogeneous(Se2_F32 se, DenseMatrix64F ret) {
        if (ret == null) {
            ret = new DenseMatrix64F(3, 3);
        } else {
            ret.set(2, 0, 0.0);
            ret.set(2, 1, 0.0);
        }
        float c = se.getCosineYaw();
        float s = se.getSineYaw();
        ret.set(0, 0, c);
        ret.set(0, 1, -s);
        ret.set(1, 0, s);
        ret.set(1, 1, c);
        ret.set(0, 2, se.getX());
        ret.set(1, 2, se.getY());
        ret.set(2, 2, 1.0);
        return ret;
    }

    public static Se2_F32 toSe2(DenseMatrix64F H, Se2_F32 ret) {
        if (H.numCols != 3 || H.numRows != 3) {
            throw new IllegalArgumentException("The homogeneous matrix must be 3 by 3 by definition.");
        }
        if (ret == null) {
            ret = new Se2_F32();
        }
        ret.setTranslation((float)H.get(0, 2), (float)H.get(1, 2));
        float c = (float)H.get(0, 0);
        float s = (float)H.get(1, 0);
        ret.setYaw((float)Math.atan2(s, c));
        return ret;
    }

    public static Se3_F32 setEulerXYZ(float rotX, float rotY, float rotZ, float dx, float dy, float dz, Se3_F32 se) {
        if (se == null) {
            se = new Se3_F32();
        }
        ConvertRotation3D_F32.eulerToMatrix(EulerType.XYZ, rotX, rotY, rotZ, se.getR());
        Vector3D_F32 T = se.getT();
        T.x = dx;
        T.y = dy;
        T.z = dz;
        return se;
    }
}

