/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.struct.point.Point2D_F32;
import georegression.struct.shapes.Polygon2D_F32;
import georegression.struct.shapes.Quadrilateral_F32;

public class Area2D_F32 {
    public static float triangle(Point2D_F32 a, Point2D_F32 b, Point2D_F32 c) {
        float inner = a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y);
        return Math.abs(inner / 2.0f);
    }

    public static float quadrilateral(Quadrilateral_F32 quad) {
        float dx;
        float dy;
        float bx = quad.b.x - quad.a.x;
        float cy = quad.c.y - quad.a.y;
        float by = quad.b.y - quad.a.y;
        float cx = quad.c.x - quad.a.x;
        if (bx * cy - by * cx >= 0.0f == cx * (dy = quad.d.y - quad.a.y) - cy * (dx = quad.d.x - quad.a.x) >= 0.0f) {
            return Area2D_F32.triangle(quad.a, quad.b, quad.c) + Area2D_F32.triangle(quad.a, quad.c, quad.d);
        }
        return Area2D_F32.triangle(quad.a, quad.b, quad.d) + Area2D_F32.triangle(quad.b, quad.c, quad.d);
    }

    public static float polygonSimple(Polygon2D_F32 poly) {
        float total = 0.0f;
        Point2D_F32 v0 = poly.get(0);
        Point2D_F32 v1 = poly.get(1);
        for (int i = 2; i < poly.size(); ++i) {
            Point2D_F32 v2 = poly.get(i);
            total += v1.x * (v2.y - v0.y);
            v0 = v1;
            v1 = v2;
        }
        Point2D_F32 v2 = poly.get(0);
        total += v1.x * (v2.y - v0.y);
        v0 = v1;
        v1 = v2;
        v2 = poly.get(1);
        return Math.abs((total += v1.x * (v2.y - v0.y)) / 2.0f);
    }
}

