/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_I32;
import georegression.struct.shapes.Rectangle2D_I32;
import java.util.List;

public class UtilPolygons2D_I32 {
    public static void bounding(List<Point2D_I32> points, Rectangle2D_I32 rectangle) {
        rectangle.x0 = Integer.MAX_VALUE;
        rectangle.y0 = Integer.MAX_VALUE;
        rectangle.x1 = Integer.MIN_VALUE;
        rectangle.y1 = Integer.MIN_VALUE;
        for (int i = 0; i < points.size(); ++i) {
            Point2D_I32 p = points.get(i);
            if (p.x < rectangle.x0) {
                rectangle.x0 = p.x;
            }
            if (p.x > rectangle.x1) {
                rectangle.x1 = p.x;
            }
            if (p.y < rectangle.y0) {
                rectangle.y0 = p.y;
            }
            if (p.y <= rectangle.y1) continue;
            rectangle.y1 = p.y;
        }
        ++rectangle.x1;
        ++rectangle.y1;
    }

    public static void bounding(Polygon2D_I32 quad, Rectangle2D_I32 rectangle) {
        UtilPolygons2D_I32.bounding(quad.vertexes.toList(), rectangle);
    }

    public static boolean isCCW(List<Point2D_I32> polygon) {
        int N = polygon.size();
        int sign = 0;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            int k = (i + 2) % N;
            Point2D_I32 a = polygon.get(i);
            Point2D_I32 b = polygon.get(j);
            Point2D_I32 c = polygon.get(k);
            int dx0 = a.x - b.x;
            int dy1 = c.y - b.y;
            int dy0 = a.y - b.y;
            int dx1 = c.x - b.x;
            int z = dx0 * dy1 - dy0 * dx1;
            if (z > 0) {
                ++sign;
                continue;
            }
            --sign;
        }
        return sign < 0;
    }
}

